/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.BaseFieldAttributes;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.CachedCount;
import org.melati.poem.CachedExists;
import org.melati.poem.CachedSelection;
import org.melati.poem.Capability;
import org.melati.poem.Column;
import org.melati.poem.ColumnInUsePoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.CommitLogEvent;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.DoubleCreatePoemException;
import org.melati.poem.DuplicateColumnNamePoemException;
import org.melati.poem.DuplicateDeletedColumnPoemException;
import org.melati.poem.DuplicateTroidColumnPoemException;
import org.melati.poem.DuplicateTroidPoemException;
import org.melati.poem.ExecutingSQLPoemException;
import org.melati.poem.ExtraColumn;
import org.melati.poem.Field;
import org.melati.poem.FieldAttributes;
import org.melati.poem.FieldContentsPoemException;
import org.melati.poem.InitialisationPoemException;
import org.melati.poem.Initialiser;
import org.melati.poem.IntegrityFix;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.NoSuchColumnPoemException;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemBugPoemException;
import org.melati.poem.PoemException;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTransaction;
import org.melati.poem.PoemType;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.RestrictedReferencePoemType;
import org.melati.poem.ResultSetEnumeration;
import org.melati.poem.RootAccessToken;
import org.melati.poem.RowDisappearedPoemException;
import org.melati.poem.SQLLogEvent;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.Searchability;
import org.melati.poem.Selectable;
import org.melati.poem.SessionToken;
import org.melati.poem.SimplePrepareFailedPoemException;
import org.melati.poem.SimpleRetrievalFailedPoemException;
import org.melati.poem.StringPoemType;
import org.melati.poem.StructuralModificationFailedPoemException;
import org.melati.poem.StructuralModificationLogEvent;
import org.melati.poem.Table;
import org.melati.poem.TableCategory;
import org.melati.poem.TableInfo;
import org.melati.poem.TableListener;
import org.melati.poem.TroidPoemType;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.UnexpectedValidationPoemException;
import org.melati.poem.UnificationPoemException;
import org.melati.poem.UnindexableLogEvent;
import org.melati.poem.User;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.transaction.Transactioned;
import org.melati.poem.transaction.TransactionedSerial;
import org.melati.poem.util.ArrayEnumeration;
import org.melati.poem.util.ArrayUtils;
import org.melati.poem.util.Cache;
import org.melati.poem.util.CachedIndexFactory;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.FilteredEnumeration;
import org.melati.poem.util.FlattenedEnumeration;
import org.melati.poem.util.MappedEnumeration;
import org.melati.poem.util.Order;
import org.melati.poem.util.Procedure;
import org.melati.poem.util.SortUtils;
import org.melati.poem.util.StringUtils;

public class JdbcTable
implements Selectable,
Table {
    private static final int CACHE_LIMIT_DEFAULT = 100;
    private static final int DISPLAY_ORDER_DEFAULT = 100;
    private JdbcTable _this = this;
    private Database database;
    private String name;
    private String quotedName;
    private DefinitionSource definitionSource;
    private TableInfo info = null;
    private TableListener[] listeners = new TableListener[0];
    private Column[] columns = new Column[0];
    private Hashtable columnsByName = new Hashtable();
    private Column troidColumn = null;
    private Column deletedColumn = null;
    private Column canReadColumn = null;
    private Column canSelectColumn = null;
    private Column canWriteColumn = null;
    private Column canDeleteColumn = null;
    private Column displayColumn = null;
    private Column searchColumn = null;
    private String defaultOrderByClause = null;
    private Column[][] displayColumns = new Column[DisplayLevel.count()][];
    private Column[] searchColumns = null;
    private TransactionedSerial serial;
    private CachedSelection allTroids = null;
    private Hashtable cachedSelections = new Hashtable();
    private Hashtable cachedCounts = new Hashtable();
    private Hashtable cachedExists = new Hashtable();
    private int mostRecentTroid = -1;
    private int extrasIndex = 0;
    private CachedIndexFactory transactionStuffs = new CachedIndexFactory(){

        public Object reallyGet(int index) {
            return new TransactionStuff(JdbcTable.this.database.poemTransaction(index).getConnection());
        }
    };
    private TransactionStuff committedTransactionStuff = null;
    private Cache cache = new Cache(100);
    private static final Procedure invalidator = new Procedure(){

        public void apply(Object arg) {
            ((Transactioned)arg).invalidate();
        }
    };

    public JdbcTable(Database database, String name, DefinitionSource definitionSource) {
        this.database = database;
        this.name = name;
        this.definitionSource = definitionSource;
        this.serial = new TransactionedSerial(database);
    }

    public void postInitialise() {
        this.clearColumnInfoCaches();
        this.database.getColumnInfoTable().addListener(new TableListener(){

            public void notifyTouched(PoemTransaction transaction, Table table, Persistent persistent) {
                JdbcTable.this._this.notifyColumnInfo((ColumnInfo)persistent);
            }

            public void notifyUncached(Table table) {
                JdbcTable.this._this.clearColumnInfoCaches();
            }
        });
    }

    public final Database getDatabase() {
        return this.database;
    }

    public final String getName() {
        return this.name;
    }

    public final String quotedName() {
        if (this.quotedName == null) {
            this.quotedName = this.database.quotedName(this.name);
        }
        return this.quotedName;
    }

    public final String getDisplayName() {
        return this.info.getDisplayname();
    }

    public final String getDescription() {
        return this.info.getDescription();
    }

    public final TableCategory getCategory() {
        return this.info.getCategory();
    }

    public final TableInfo getInfo() {
        return this.info;
    }

    public final Integer tableInfoID() {
        return this.info == null ? null : this.info.troid();
    }

    public final Column getColumn(String nameP) throws NoSuchColumnPoemException {
        Column column = this._getColumn(nameP);
        if (column == null) {
            throw new NoSuchColumnPoemException(this, nameP);
        }
        return column;
    }

    protected final Column _getColumn(String nameP) {
        Column column = (Column)this.columnsByName.get(nameP.toLowerCase());
        return column;
    }

    public final Enumeration columns() {
        return new ArrayEnumeration(this.columns);
    }

    public final int getColumnsCount() {
        return this.columns.length;
    }

    public Column columnWithColumnInfoID(int columnInfoID) {
        Enumeration c = this.columns();
        while (c.hasMoreElements()) {
            Column column = (Column)c.nextElement();
            Integer id = column.columnInfoID();
            if (id == null || id != columnInfoID) continue;
            return column;
        }
        return null;
    }

    public final Column troidColumn() {
        return this.troidColumn;
    }

    public final Column deletedColumn() {
        return this.deletedColumn;
    }

    public final Column displayColumn() {
        return this.displayColumn == null ? this.troidColumn : this.displayColumn;
    }

    public final void setDisplayColumn(Column column) {
        this.displayColumn = column;
    }

    public final Column primaryCriterionColumn() {
        return this.searchColumn;
    }

    public void setSearchColumn(Column column) {
        this.searchColumn = column;
    }

    public String defaultOrderByClause() {
        String clause = this.defaultOrderByClause;
        if (clause == null) {
            clause = EnumUtils.concatenated(", ", new MappedEnumeration(new ArrayEnumeration(SortUtils.sorted(new Order(){

                public boolean lessOrEqual(Object a, Object b) {
                    return ((Column)a).getDisplayOrderPriority() <= ((Column)b).getDisplayOrderPriority();
                }
            }, new FilteredEnumeration(this.columns()){

                public boolean isIncluded(Object column) {
                    return ((Column)column).getDisplayOrderPriority() != null;
                }
            }))){

                public Object mapped(Object column) {
                    String sort = ((Column)column).fullQuotedName();
                    if (((Column)column).getSortDescending()) {
                        sort = sort + " desc";
                    }
                    return sort;
                }
            });
            if (clause.equals("") && this.displayColumn() != null) {
                clause = this.displayColumn().fullQuotedName();
            }
            this.defaultOrderByClause = clause;
        }
        return clause;
    }

    public void clearColumnInfoCaches() {
        this.defaultOrderByClause = null;
        for (int i = 0; i < this.displayColumns.length; ++i) {
            this.displayColumns[i] = null;
        }
    }

    public void notifyColumnInfo(ColumnInfo infoP) {
        if (infoP == null || infoP.getTableinfo_unsafe().equals(this.tableInfoID())) {
            this.clearColumnInfoCaches();
        }
    }

    private Column[] columnsWhere(String whereClause) {
        Enumeration colIDs = this.getDatabase().getColumnInfoTable().troidSelection(this.database.quotedName("tableinfo") + " = " + this.tableInfoID() + " AND (" + whereClause + ")", null, false, PoemThread.inSession() ? PoemThread.transaction() : null);
        Vector<Column> them = new Vector<Column>();
        while (colIDs.hasMoreElements()) {
            Column column = this.columnWithColumnInfoID((Integer)colIDs.nextElement());
            if (column == null) continue;
            them.addElement(column);
        }
        Object[] columnsLocal = new Column[them.size()];
        them.copyInto(columnsLocal);
        return columnsLocal;
    }

    public final Enumeration displayColumns(DisplayLevel level) {
        Object[] columnsLocal = this.displayColumns[level.getIndex()];
        if (columnsLocal == null) {
            columnsLocal = this.columnsWhere(this.database.quotedName("displaylevel") + " <= " + level.getIndex());
            this.displayColumns[level.getIndex().intValue()] = columnsLocal;
        }
        return new ArrayEnumeration(columnsLocal);
    }

    public final int displayColumnsCount(DisplayLevel level) {
        int l = level.getIndex();
        if (this.displayColumns[l] == null) {
            this.displayColumns(level);
        }
        return this.displayColumns[l].length;
    }

    public final Enumeration getDetailDisplayColumns() {
        return this.displayColumns(DisplayLevel.detail);
    }

    public final int getDetailDisplayColumnsCount() {
        return this.displayColumnsCount(DisplayLevel.detail);
    }

    public final Enumeration getRecordDisplayColumns() {
        return this.displayColumns(DisplayLevel.record);
    }

    public final int getRecordDisplayColumnsCount() {
        return this.displayColumnsCount(DisplayLevel.record);
    }

    public final Enumeration getSummaryDisplayColumns() {
        return this.displayColumns(DisplayLevel.summary);
    }

    public final int getSummaryDisplayColumnsCount() {
        return this.displayColumnsCount(DisplayLevel.summary);
    }

    public final Enumeration getSearchCriterionColumns() {
        Column[] columnsLocal = this.searchColumns;
        if (columnsLocal == null) {
            this.searchColumns = columnsLocal = this.columnsWhere(this.database.quotedName("searchability") + " <= " + Searchability.yes.getIndex());
        }
        return new ArrayEnumeration(this.searchColumns);
    }

    public final int getSearchCriterionColumnsCount() {
        if (this.searchColumns == null) {
            this.getSearchCriterionColumns();
        }
        return this.searchColumns.length;
    }

    private Dbms dbms() {
        return this.getDatabase().getDbms();
    }

    public void dbModifyStructure(String sql) throws StructuralModificationFailedPoemException {
        if (PoemThread.inSession()) {
            PoemThread.commit();
        }
        try {
            if (this.database.logSQL()) {
                this.database.log("about to execute:" + sql);
            }
            Statement updateStatement = this.database.getCommittedConnection().createStatement();
            updateStatement.executeUpdate(sql);
            updateStatement.close();
            this.database.getCommittedConnection().commit();
            if (this.database.logCommits()) {
                this.database.log(new CommitLogEvent(null));
            }
            if (this.database.logSQL()) {
                this.database.log(new StructuralModificationLogEvent(sql));
            }
            this.database.incrementQueryCount(sql);
        }
        catch (SQLException e) {
            throw new StructuralModificationFailedPoemException(sql, e);
        }
    }

    private void dbCreateTable() {
        String createTableSql = this.dbms().createTableSql(this);
        this.dbModifyStructure(createTableSql);
        String tableSetup = this.database.getDbms().tableInitialisationSql(this);
        if (tableSetup != null) {
            this.dbModifyStructure(tableSetup);
        }
    }

    public String getDbmsTableType() {
        return null;
    }

    public void dbAddConstraints() {
        int c;
        StringBuffer sqb = new StringBuffer();
        for (c = 0; c < this.columns.length; ++c) {
            if (!(this.columns[c].getSQLType() instanceof TroidPoemType)) continue;
            sqb.append("ALTER TABLE " + this.quotedName());
            sqb.append(this.dbms().getPrimaryKeyDefinition(this.columns[c].getName()));
            try {
                this.dbModifyStructure(sqb.toString());
                continue;
            }
            catch (StructuralModificationFailedPoemException e2) {
                Object e2 = null;
            }
        }
        for (c = 0; c < this.columns.length; ++c) {
            if (!(this.columns[c].getSQLType() instanceof ReferencePoemType)) continue;
            IntegrityFix fix = this.columns[c].getIntegrityFix();
            sqb = new StringBuffer();
            sqb.append("ALTER TABLE " + this.quotedName());
            sqb.append(this.dbms().getForeignKeyDefinition(this.getName(), this.columns[c].getName(), ((ReferencePoemType)this.columns[c].getSQLType()).targetTable().getName(), ((ReferencePoemType)this.columns[c].getSQLType()).targetTable().troidColumn().getName(), fix.getName()));
            try {
                this.dbModifyStructure(sqb.toString());
                continue;
            }
            catch (StructuralModificationFailedPoemException e3) {
                Object e3 = null;
            }
        }
    }

    private void dbAddColumn(Column column) {
        if (column.getType().getNullable()) {
            this.dbModifyStructure("ALTER TABLE " + this.quotedName() + " ADD " + column.quotedName() + " " + column.getSQLType().sqlDefinition(this.dbms()));
        } else {
            this.dbModifyStructure("ALTER TABLE " + this.quotedName() + " ADD " + column.quotedName() + " " + column.getSQLType().sqlTypeDefinition(this.dbms()));
            this.dbModifyStructure("UPDATE " + this.quotedName() + " SET " + column.quotedName() + " = " + this.dbms().getQuotedValue(column.getSQLType(), column.getSQLType().sqlDefaultValue(this.dbms())));
            this.dbModifyStructure(this.dbms().alterColumnNotNullableSQL(this.name, column));
        }
    }

    private void dbCreateIndex(Column column) {
        if (column.getIndexed()) {
            if (!this.dbms().canBeIndexed(column)) {
                this.database.log(new UnindexableLogEvent(column));
            } else {
                this.dbModifyStructure("CREATE " + (column.getUnique() ? "UNIQUE " : "") + "INDEX " + this.indexName(column) + " ON " + this.quotedName() + " " + "(" + column.quotedName() + this.dbms().getIndexLength(column) + ")");
            }
        }
    }

    private String indexName(Column column) {
        return this.database.quotedName(this.dbms().unreservedName(this.name) + "_" + this.dbms().unreservedName(column.getName()) + "_index");
    }

    private PreparedStatement simpleInsert(Connection connection) {
        int c;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + this.quotedName() + " (");
        for (c = 0; c < this.columns.length; ++c) {
            if (c > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[c].quotedName());
        }
        sql.append(") VALUES (");
        for (c = 0; c < this.columns.length; ++c) {
            if (c > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        try {
            return connection.prepareStatement(sql.toString());
        }
        catch (SQLException e) {
            throw new SimplePrepareFailedPoemException(sql.toString(), e);
        }
    }

    private PreparedStatement simpleGet(Connection connection) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        for (int c = 0; c < this.columns.length; ++c) {
            if (c > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[c].quotedName());
        }
        sql.append(" FROM " + this.quotedName() + " WHERE " + this.troidColumn.quotedName() + " = ?");
        try {
            return connection.prepareStatement(sql.toString());
        }
        catch (SQLException e) {
            throw new SimplePrepareFailedPoemException(sql.toString(), e);
        }
    }

    private PreparedStatement simpleModify(Connection connection) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + this.quotedName() + " SET ");
        for (int c = 0; c < this.columns.length; ++c) {
            if (c > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[c].quotedName());
            sql.append(" = ?");
        }
        sql.append(" WHERE " + this.troidColumn.quotedName() + " = ?");
        try {
            return connection.prepareStatement(sql.toString());
        }
        catch (SQLException e) {
            throw new SimplePrepareFailedPoemException(sql.toString(), e);
        }
    }

    public void invalidateTransactionStuffs() {
        this.transactionStuffs.invalidate();
    }

    private synchronized TransactionStuff getCommittedTransactionStuff() {
        if (this.committedTransactionStuff == null) {
            this.committedTransactionStuff = new TransactionStuff(this.database.getCommittedConnection());
        }
        return this.committedTransactionStuff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(PreparedStatement select, Persistent p) {
        JdbcPersistent persistent = (JdbcPersistent)p;
        try {
            PreparedStatement preparedStatement = select;
            synchronized (preparedStatement) {
                select.setInt(1, persistent.troid());
                ResultSet rs = select.executeQuery();
                if (this.database.logSQL()) {
                    this.database.log(new SQLLogEvent(select.toString()));
                }
                this.database.incrementQueryCount(select.toString());
                try {
                    if (!rs.next()) {
                        persistent.setStatusNonexistent();
                    } else {
                        persistent.setStatusExistent();
                        for (int c = 0; c < this.columns.length; ++c) {
                            this.columns[c].load_unsafe(rs, c + 1, persistent);
                        }
                    }
                    persistent.setDirty(false);
                    persistent.markValid();
                    if (rs.next()) {
                        throw new DuplicateTroidPoemException(this, persistent.troid());
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        System.err.println("Cannot close resultset after exception.");
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SimpleRetrievalFailedPoemException(e, select.toString());
        }
        catch (ValidationPoemException e) {
            throw new UnexpectedValidationPoemException(e);
        }
    }

    public void load(PoemTransaction transaction, Persistent persistent) {
        this.load(transaction == null ? this.getCommittedTransactionStuff().get : ((TransactionStuff)this.transactionStuffs.get((int)transaction.index)).get, persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modify(PoemTransaction transaction, Persistent persistent) {
        PreparedStatement modify;
        PreparedStatement preparedStatement = modify = ((TransactionStuff)this.transactionStuffs.get((int)transaction.index)).modify;
        synchronized (preparedStatement) {
            for (int c = 0; c < this.columns.length; ++c) {
                this.columns[c].save_unsafe(persistent, modify, c + 1);
            }
            try {
                modify.setInt(this.columns.length + 1, persistent.troid());
            }
            catch (SQLException e) {
                throw new SQLSeriousPoemException(e);
            }
            try {
                modify.executeUpdate();
            }
            catch (SQLException e) {
                throw this.dbms().exceptionForUpdate((Table)this, modify, false, e);
            }
            this.database.incrementQueryCount(modify.toString());
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(modify.toString()));
            }
        }
        persistent.postModify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(PoemTransaction transaction, Persistent persistent) {
        PreparedStatement insert;
        PreparedStatement preparedStatement = insert = ((TransactionStuff)this.transactionStuffs.get((int)transaction.index)).insert;
        synchronized (preparedStatement) {
            for (int c = 0; c < this.columns.length; ++c) {
                this.columns[c].save_unsafe(persistent, insert, c + 1);
            }
            try {
                insert.executeUpdate();
            }
            catch (SQLException e) {
                throw this.dbms().exceptionForUpdate((Table)this, insert, true, e);
            }
            this.database.incrementQueryCount(insert.toString());
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(insert.toString()));
            }
        }
        persistent.postInsert();
    }

    public void delete(Integer troid, PoemTransaction transaction) {
        String sql = "DELETE FROM " + this.quotedName() + " WHERE " + this.troidColumn.quotedName() + " = " + troid.toString();
        try {
            transaction.writeDown();
            Connection connection = transaction.getConnection();
            Statement deleteStatement = connection.createStatement();
            int deleted = deleteStatement.executeUpdate(sql);
            if (deleted != 1) {
                throw new RowDisappearedPoemException(this, troid);
            }
            deleteStatement.close();
            this.database.incrementQueryCount(sql);
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(sql));
            }
            this.cache.delete(troid);
        }
        catch (SQLException e) {
            throw new ExecutingSQLPoemException(sql, e);
        }
    }

    public void writeDown(PoemTransaction transaction, Persistent p) {
        JdbcPersistent persistent = (JdbcPersistent)p;
        if (persistent.isDirty()) {
            this.troidColumn.setRaw_unsafe(persistent, persistent.troid());
            if (persistent.statusExistent()) {
                this.modify(transaction, persistent);
            } else if (persistent.statusNonexistent()) {
                this.insert(transaction, persistent);
                persistent.setStatusExistent();
            }
            persistent.setDirty(false);
            persistent.postWrite();
        }
    }

    public void uncache() {
        this.cache.iterate(invalidator);
        this.serial.invalidate();
        TableListener[] listenersLocal = this.listeners;
        for (int l = 0; l < listenersLocal.length; ++l) {
            listenersLocal[l].notifyUncached(this);
        }
    }

    public void trimCache(int maxSize) {
        this.cache.trim(maxSize);
    }

    public Cache.Info getCacheInfo() {
        return this.cache.getInfo();
    }

    public void addListener(TableListener listener) {
        this.listeners = (TableListener[])ArrayUtils.added(this.listeners, listener);
    }

    public void notifyTouched(PoemTransaction transaction, Persistent persistent) {
        this.serial.increment(transaction);
        TableListener[] listenersLocal = this.listeners;
        for (int l = 0; l < listenersLocal.length; ++l) {
            listenersLocal[l].notifyTouched(transaction, this, persistent);
        }
    }

    public long serial(PoemTransaction transaction) {
        return this.serial.current(transaction);
    }

    public void readLock() {
        this.serial(PoemThread.transaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent getObject(Integer troid) throws NoSuchRowPoemException {
        JdbcPersistent persistent = (JdbcPersistent)this.cache.get(troid);
        if (persistent == null) {
            persistent = (JdbcPersistent)this.newPersistent();
            this.claim(persistent, troid);
            this.load(PoemThread.transaction(), (Persistent)persistent);
            if (persistent.statusExistent()) {
                Cache cache = this.cache;
                synchronized (cache) {
                    JdbcPersistent tryAgain = (JdbcPersistent)this.cache.get(troid);
                    if (tryAgain == null) {
                        try {
                            this.cache.put(troid, persistent);
                        }
                        catch (Cache.InconsistencyException e) {
                            throw new PoemBugPoemException("Problem putting persistent " + persistent + " into cache:", e);
                        }
                    } else {
                        persistent = tryAgain;
                    }
                }
            }
        }
        if (!persistent.statusExistent()) {
            throw new NoSuchRowPoemException(this, troid);
        }
        persistent.existenceLock(PoemThread.sessionToken());
        return persistent;
    }

    public Persistent getObject(int troid) throws NoSuchRowPoemException {
        return this.getObject(new Integer(troid));
    }

    public String selectionSQL(String fromClause, String whereClause, String orderByClause, boolean includeDeleted, boolean excludeUnselectable) {
        return this.selectOrCountSQL(this.troidColumn().fullQuotedName(), fromClause, whereClause, orderByClause, includeDeleted, excludeUnselectable);
    }

    private ResultSet selectionResultSet(String fromClause, String whereClause, String orderByClause, boolean includeDeleted, boolean excludeUnselectable, PoemTransaction transaction) throws SQLPoemException {
        String sql = this.selectionSQL(fromClause, whereClause, orderByClause, includeDeleted, excludeUnselectable);
        try {
            Connection connection;
            if (transaction == null) {
                connection = this.getDatabase().getCommittedConnection();
            } else {
                transaction.writeDown();
                connection = transaction.getConnection();
            }
            Statement selectionStatement = connection.createStatement();
            ResultSet rs = selectionStatement.executeQuery(sql);
            this.database.incrementQueryCount(sql);
            SessionToken token = PoemThread._sessionToken();
            if (token != null) {
                token.toTidy().add(rs);
                token.toTidy().add(selectionStatement);
            }
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(sql));
            }
            return rs;
        }
        catch (SQLException e) {
            throw new ExecutingSQLPoemException(sql, e);
        }
    }

    public Enumeration troidSelection(String whereClause, String orderByClause, boolean includeDeleted, PoemTransaction transaction) {
        return this.troidsFrom(this.selectionResultSet(null, whereClause, orderByClause, includeDeleted, true, transaction));
    }

    public Enumeration troidSelection(Persistent criteria, String orderByClause, boolean includeDeleted, boolean excludeUnselectable, PoemTransaction transaction) {
        return this.troidsFrom(this.selectionResultSet(((JdbcPersistent)criteria).fromClause(), this.whereClause(criteria), orderByClause, includeDeleted, excludeUnselectable, transaction));
    }

    private Enumeration troidsFrom(ResultSet them) {
        return new ResultSetEnumeration(them){

            public Object mapped(ResultSet rs) throws SQLException {
                return new Integer(rs.getInt(1));
            }
        };
    }

    public void rememberAllTroids(boolean flag) {
        if (flag) {
            if (this.allTroids == null && this.troidColumn() != null) {
                this.allTroids = new CachedSelection((Table)this, null, null);
            }
        } else {
            this.allTroids = null;
        }
    }

    public void setCacheLimit(Integer limit) {
        this.cache.setSize(limit == null ? 100 : limit);
    }

    public Enumeration troidSelection(String whereClause, String orderByClause, boolean includeDeleted) throws SQLPoemException {
        if (!(this.allTroids == null || whereClause != null && !whereClause.equals("") || orderByClause != null && !orderByClause.equals("") && orderByClause != this.defaultOrderByClause() || includeDeleted)) {
            return this.allTroids.troids();
        }
        return this.troidSelection(whereClause, orderByClause, includeDeleted, PoemThread.inSession() ? PoemThread.transaction() : null);
    }

    public Enumeration selection() throws SQLPoemException {
        return this.selection(null, null, false);
    }

    public final Enumeration selection(String whereClause) throws SQLPoemException {
        return this.selection(whereClause, null, false);
    }

    public Persistent firstSelection(String whereClause) {
        Enumeration them = this.selection(whereClause);
        return them.hasMoreElements() ? (Persistent)them.nextElement() : null;
    }

    public Enumeration selection(String whereClause, String orderByClause, boolean includeDeleted) throws SQLPoemException {
        return this.objectsFromTroids(this.troidSelection(whereClause, orderByClause, includeDeleted));
    }

    public Enumeration selection(Persistent criteria) throws SQLPoemException {
        return this.selection(criteria, criteria.getTable().defaultOrderByClause(), false, true);
    }

    public Enumeration selection(Persistent criteria, String orderByClause) throws SQLPoemException {
        return this.selection(criteria, orderByClause, false, true);
    }

    public Enumeration selection(Persistent criteria, String orderByClause, boolean includeDeleted, boolean excludeUnselectable) throws SQLPoemException {
        return this.objectsFromTroids(this.troidSelection(criteria, orderByClause, includeDeleted, excludeUnselectable, null));
    }

    private Enumeration objectsFromTroids(Enumeration troids) {
        return new MappedEnumeration(troids){

            public Object mapped(Object troid) {
                return JdbcTable.this.getObject((Integer)troid);
            }
        };
    }

    public String countSQL(String whereClause) {
        return this.countSQL(null, whereClause, false, true);
    }

    public String countSQL(String fromClause, String whereClause, boolean includeDeleted, boolean excludeUnselectable) {
        return this.selectOrCountSQL("count(*)", fromClause, whereClause, "", includeDeleted, excludeUnselectable);
    }

    private String selectOrCountSQL(String selectClause, String fromClause, String whereClause, String orderByClause, boolean includeDeleted, boolean excludeUnselectable) {
        if (fromClause == null) {
            fromClause = this.quotedName();
        }
        String result = "SELECT " + selectClause + " FROM " + fromClause;
        if ((whereClause = this.appendWhereClauseFilters(whereClause, includeDeleted, excludeUnselectable)).length() > 0) {
            result = result + " WHERE " + whereClause;
        }
        if (orderByClause == null) {
            orderByClause = this.defaultOrderByClause();
        }
        if (orderByClause.trim().length() > 0) {
            result = result + " ORDER BY " + orderByClause;
        }
        return result;
    }

    private String appendWhereClauseFilters(String whereClause, boolean includeDeleted, boolean excludeUnselectable) {
        String s;
        whereClause = whereClause == null || whereClause.trim().length() == 0 ? "" : "(" + whereClause + ")";
        if (this.deletedColumn != null && !includeDeleted) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " AND";
            }
            whereClause = whereClause + " NOT " + this.dbms().booleanTrueExpression(this.deletedColumn);
        }
        if (excludeUnselectable && (s = this.canSelectClause()) != null) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " AND ";
            }
            whereClause = whereClause + s;
        }
        return whereClause;
    }

    private String canSelectClause() {
        AccessToken accessToken;
        Column canSelect = this.canSelectColumn();
        AccessToken accessToken2 = accessToken = PoemThread.inSession() ? PoemThread.sessionToken().accessToken : null;
        if (canSelect == null || accessToken instanceof RootAccessToken) {
            return null;
        }
        if (accessToken instanceof User) {
            String query = "(" + canSelect.fullQuotedName() + " IS NULL OR EXISTS( SELECT 1 FROM " + this.quotedName() + ", " + this.database.getGroupCapabilityTable().quotedName() + ", " + this.database.getGroupMembershipTable().quotedName() + " WHERE " + this.database.getGroupMembershipTable().getUserColumn().fullQuotedName() + " = " + ((User)accessToken).getId() + " AND " + this.database.getGroupMembershipTable().getGroupColumn().fullQuotedName() + " = " + this.database.getGroupCapabilityTable().getGroupColumn().fullQuotedName() + " AND " + this.database.getGroupCapabilityTable().getCapabilityColumn().fullQuotedName() + " = " + canSelect.fullQuotedName() + "))";
            return query;
        }
        return canSelect.fullQuotedName() + " IS NULL";
    }

    public int count(String whereClause, boolean includeDeleted, boolean excludeUnselectable) throws SQLPoemException {
        return this.count(this.appendWhereClauseFilters(whereClause, includeDeleted, excludeUnselectable));
    }

    public int count(String whereClause, boolean includeDeleted) throws SQLPoemException {
        return this.count(whereClause, includeDeleted, true);
    }

    public int count(String whereClause) throws SQLPoemException {
        String sql = this.countSQL(whereClause);
        try {
            Connection connection;
            if (PoemThread.inSession()) {
                PoemTransaction transaction = PoemThread.transaction();
                transaction.writeDown();
                connection = transaction.getConnection();
            } else {
                connection = this.getDatabase().getCommittedConnection();
            }
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            this.database.incrementQueryCount(sql);
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(sql));
            }
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            s.close();
            return count;
        }
        catch (SQLException e) {
            throw new ExecutingSQLPoemException(sql, e);
        }
    }

    public int count() throws SQLPoemException {
        return this.count(null);
    }

    public boolean exists(String whereClause) throws SQLPoemException {
        return this.count(whereClause) > 0;
    }

    public boolean exists(Persistent persistent) {
        return this.exists(this.whereClause(persistent));
    }

    public void appendWhereClause(StringBuffer clause, Persistent persistent) {
        Column[] columnsLocal = this.columns;
        boolean hadOne = false;
        for (int c = 0; c < columnsLocal.length; ++c) {
            Column column = columnsLocal[c];
            Object raw = column.getRaw_unsafe(persistent);
            if (raw == null) continue;
            if (hadOne) {
                clause.append(" AND ");
            } else {
                hadOne = true;
            }
            String columnSQL = column.fullQuotedName();
            if (column.getType() instanceof StringPoemType) {
                clause.append(this.dbms().caseInsensitiveRegExpSQL(columnSQL, column.getSQLType().quotedRaw(raw)));
                continue;
            }
            if (column.getType() instanceof BooleanPoemType) {
                clause.append(columnSQL);
                clause.append(" = ");
                clause.append(this.dbms().sqlBooleanValueOfRaw(raw));
                continue;
            }
            clause.append(columnSQL);
            clause.append(" = ");
            clause.append(column.getSQLType().quotedRaw(raw));
        }
    }

    public String whereClause(Persistent criteria) {
        return this.whereClause(criteria, true, true);
    }

    public String whereClause(Persistent criteria, boolean includeDeleted, boolean excludeUnselectable) {
        StringBuffer clause = new StringBuffer();
        this.appendWhereClause(clause, criteria);
        return this.appendWhereClauseFilters(clause.toString(), includeDeleted, excludeUnselectable);
    }

    public String cnfWhereClause(Enumeration persistents) {
        return this.cnfWhereClause(persistents, false, true);
    }

    public String cnfWhereClause(Enumeration persistents, boolean includeDeleted, boolean excludeUnselectable) {
        StringBuffer clause = new StringBuffer();
        boolean hadOne = false;
        while (persistents.hasMoreElements()) {
            StringBuffer pClause = new StringBuffer();
            this.appendWhereClause(pClause, (Persistent)persistents.nextElement());
            if (pClause.length() <= 0) continue;
            if (hadOne) {
                clause.append(" OR ");
            } else {
                hadOne = true;
            }
            clause.append("(");
            clause.append(pClause);
            clause.append(")");
        }
        return this.appendWhereClauseFilters(clause.toString(), includeDeleted, excludeUnselectable);
    }

    public Enumeration referencesTo(final Persistent object) {
        return new FlattenedEnumeration(new MappedEnumeration(this.columns()){

            public Object mapped(Object column) {
                return ((Column)column).referencesTo(object);
            }
        });
    }

    public Enumeration referencesTo(final Table table) {
        return new FilteredEnumeration(this.columns()){

            public boolean isIncluded(Object column) {
                PoemType type = ((Column)column).getType();
                return type instanceof ReferencePoemType && ((ReferencePoemType)type).targetTable() == table;
            }
        };
    }

    private void validate(Persistent persistent) throws FieldContentsPoemException {
        for (int c = 0; c < this.columns.length; ++c) {
            Column column = this.columns[c];
            try {
                column.getType().assertValidRaw(column.getRaw_unsafe(persistent));
                continue;
            }
            catch (Exception e) {
                throw new FieldContentsPoemException(column, e);
            }
        }
    }

    public int getMostRecentTroid() {
        if (this.mostRecentTroid == -1) {
            throw new PoemBugPoemException("Troid still unitialised in " + this.name);
        }
        return this.mostRecentTroid;
    }

    public synchronized Integer troidFor(Persistent persistent) {
        Persistent foolEclipse;
        persistent = foolEclipse = persistent;
        if (this.mostRecentTroid == -1) {
            throw new PoemBugPoemException("Troid still unitialised in " + this.name);
        }
        return new Integer(this.mostRecentTroid++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Persistent p) throws AccessPoemException, ValidationPoemException, InitialisationPoemException {
        JdbcPersistent persistent = (JdbcPersistent)p;
        SessionToken sessionToken = PoemThread.sessionToken();
        if (persistent.getTable() == null) {
            persistent.setTable(this, null);
        }
        persistent.assertCanCreate(sessionToken.accessToken);
        this.claim(persistent, this.troidFor(persistent));
        persistent.setStatusNonexistent();
        try {
            this.validate(persistent);
        }
        catch (Exception e) {
            throw new InitialisationPoemException(this, e);
        }
        Cache cache = this.cache;
        synchronized (cache) {
            persistent.setDirty(true);
            this.writeDown(sessionToken.transaction, persistent);
            persistent.readLock(sessionToken.transaction);
            this.cache.put(persistent.troid(), persistent);
        }
        this.notifyTouched(sessionToken.transaction, persistent);
    }

    public Persistent create(Initialiser initialiser) throws AccessPoemException, ValidationPoemException, InitialisationPoemException {
        Persistent persistent = this.newPersistent();
        initialiser.init(persistent);
        this.create(persistent);
        return persistent;
    }

    private void claim(Persistent p, Integer troid) {
        JdbcPersistent persistent = (JdbcPersistent)p;
        if (this.cache.get(troid) != null) {
            throw new DuplicateTroidPoemException(this, troid);
        }
        if (persistent.troid() != null) {
            throw new DoubleCreatePoemException(persistent);
        }
        persistent.setTable(this, troid);
        this.troidColumn.setRaw_unsafe(persistent, troid);
        if (this.deletedColumn != null) {
            this.deletedColumn.setRaw_unsafe(persistent, Boolean.FALSE);
        }
    }

    public Persistent newPersistent() {
        JdbcPersistent it = this._newPersistent();
        it.setTable(this, null);
        return it;
    }

    protected JdbcPersistent _newPersistent() {
        return new JdbcPersistent();
    }

    public void delete_unsafe(String whereClause) {
        this.serial.increment(PoemThread.transaction());
        this.getDatabase().sqlUpdate("DELETE FROM " + this.quotedName + " WHERE " + whereClause);
        this.uncache();
    }

    public int extrasCount() {
        return this.extrasIndex;
    }

    public final Capability getDefaultCanRead() {
        return this.info == null ? null : this.info.getDefaultcanread();
    }

    public final Capability getDefaultCanWrite() {
        return this.info == null ? null : this.info.getDefaultcanwrite();
    }

    public final Capability getDefaultCanDelete() {
        return this.info == null ? null : this.info.getDefaultcandelete();
    }

    public final Capability getCanCreate() {
        return this.info == null ? null : this.info.getCancreate();
    }

    public final Column canReadColumn() {
        return this.canReadColumn == null ? this.canSelectColumn() : this.canReadColumn;
    }

    public final Column canSelectColumn() {
        return this.canSelectColumn;
    }

    public final Column canWriteColumn() {
        return this.canWriteColumn;
    }

    public final Column canDeleteColumn() {
        return this.canDeleteColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column addColumnAndCommit(ColumnInfo infoP) throws PoemException {
        Column column = ExtraColumn.from(this, infoP, this.extrasIndex++, DefinitionSource.runtime);
        column.setColumnInfo(infoP);
        this.defineColumn(column, false);
        this.database.beginStructuralModification();
        try {
            this.dbAddColumn(column);
            Cache cache = this.cache;
            synchronized (cache) {
                this.uncache();
                this.transactionStuffs.invalidate();
                this.defineColumn(column, true);
            }
            PoemThread.commit();
        }
        finally {
            this.database.endStructuralModification();
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteColumnAndCommit(ColumnInfo columnInfo) throws PoemException {
        this.database.beginStructuralModification();
        try {
            Column column = columnInfo.column();
            columnInfo.delete();
            if (this.database.getDbms().canDropColumns()) {
                this.dbModifyStructure("ALTER TABLE " + this.quotedName() + " DROP " + column.quotedName());
            }
            this.columns = (Column[])ArrayUtils.removed(this.columns, column);
            this.columnsByName.remove(column.getName().toLowerCase());
            Cache cache = this.cache;
            synchronized (cache) {
                this.uncache();
                this.transactionStuffs.invalidate();
            }
            PoemThread.commit();
        }
        finally {
            this.database.endStructuralModification();
        }
    }

    public String toString() {
        return this.getName() + " (from " + this.definitionSource + ")";
    }

    public void dumpCacheAnalysis() {
        System.err.println("\n-------- Analysis of " + this.name + "'s cache\n");
        this.cache.dumpAnalysis();
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream ps) {
        ps.println("=== table " + this.name + " (tableinfo id " + this.tableInfoID() + ")");
        for (int c = 0; c < this.columns.length; ++c) {
            this.columns[c].dump(ps);
        }
    }

    public CachedSelection cachedSelection(String whereClause, String orderByClause) {
        String key = whereClause + "/" + orderByClause;
        CachedSelection them = (CachedSelection)this.cachedSelections.get(key);
        if (them == null) {
            CachedSelection newThem = new CachedSelection((Table)this, whereClause, orderByClause);
            this.cachedSelections.put(key, newThem);
            them = newThem;
        }
        return them;
    }

    public CachedCount cachedCount(String whereClause, boolean includeDeleted) {
        return this.cachedCount(whereClause, includeDeleted, true);
    }

    public CachedCount cachedCount(String whereClause, boolean includeDeleted, boolean excludeUnselectable) {
        return this.cachedCount(this.appendWhereClauseFilters(whereClause, includeDeleted, excludeUnselectable));
    }

    public CachedCount cachedCount(Persistent criteria, boolean includeDeleted, boolean excludeUnselectable) {
        return this.cachedCount(this.whereClause(criteria, includeDeleted, excludeUnselectable));
    }

    public CachedCount cachedCount(Persistent criteria) {
        return this.cachedCount(this.whereClause(criteria, true, false));
    }

    public CachedCount cachedCount(String whereClause) {
        String key = "" + whereClause;
        CachedCount it = (CachedCount)this.cachedCounts.get(key);
        if (it == null) {
            it = new CachedCount(this, whereClause);
            this.cachedCounts.put(key, it);
        }
        return it;
    }

    public CachedExists cachedExists(String whereClause) {
        String key = "" + whereClause;
        CachedExists it = null;
        it = (CachedExists)this.cachedExists.get(key);
        if (it == null) {
            it = new CachedExists(this, whereClause);
            this.cachedExists.put(key, it);
        }
        return it;
    }

    public RestrictedReferencePoemType cachedSelectionType(String whereClause, String orderByClause, boolean nullable) {
        return new RestrictedReferencePoemType(this.cachedSelection(whereClause, orderByClause), nullable);
    }

    public Field cachedSelectionField(String whereClause, String orderByClause, boolean nullable, Integer selectedTroid, String nameP) {
        return new Field(selectedTroid, (FieldAttributes)new BaseFieldAttributes(nameP, (PoemType)this.cachedSelectionType(whereClause, orderByClause, nullable)));
    }

    private synchronized void defineColumn(Column column, boolean reallyDoIt) throws DuplicateColumnNamePoemException, DuplicateTroidColumnPoemException, DuplicateDeletedColumnPoemException {
        PoemType type;
        if (column.getTable() != this) {
            throw new ColumnInUsePoemException(this, column);
        }
        if (this._getColumn(column.getName()) != null) {
            throw new DuplicateColumnNamePoemException(this, column);
        }
        if (column.isTroidColumn()) {
            if (this.troidColumn != null) {
                throw new DuplicateTroidColumnPoemException(this, column);
            }
            if (reallyDoIt) {
                this.troidColumn = column;
            }
        } else if (column.isDeletedColumn()) {
            if (this.deletedColumn != null) {
                throw new DuplicateDeletedColumnPoemException(this, column);
            }
            if (reallyDoIt) {
                this.deletedColumn = column;
            }
        } else if (reallyDoIt && (type = column.getType()) instanceof ReferencePoemType && ((ReferencePoemType)type).targetTable() == this.database.getCapabilityTable()) {
            if (column.getName().equals("canRead")) {
                this.canReadColumn = column;
            } else if (column.getName().equals("canWrite")) {
                this.canWriteColumn = column;
            } else if (column.getName().equals("canDelete")) {
                this.canDeleteColumn = column;
            } else if (column.getName().equals("canSelect")) {
                this.canSelectColumn = column;
            }
        }
        if (reallyDoIt) {
            column.setTable(this);
            this.columns = (Column[])ArrayUtils.added(this.columns, column);
            this.columnsByName.put(column.getName().toLowerCase(), column);
        }
    }

    public final void defineColumn(Column column) throws DuplicateColumnNamePoemException, DuplicateTroidColumnPoemException, DuplicateDeletedColumnPoemException {
        this.defineColumn(column, true);
    }

    private void _defineColumn(Column column) {
        try {
            this.defineColumn(column);
        }
        catch (DuplicateColumnNamePoemException e) {
            throw new UnexpectedExceptionPoemException(e);
        }
        catch (DuplicateTroidColumnPoemException e) {
            throw new UnexpectedExceptionPoemException(e);
        }
    }

    public int getNextExtrasIndex() {
        return this.extrasIndex++;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.info = tableInfo;
        this.rememberAllTroids(tableInfo.getSeqcached());
        this.setCacheLimit(tableInfo.getCachelimit());
    }

    public TableInfo getTableInfo() {
        return this.info;
    }

    protected String defaultDisplayName() {
        return StringUtils.capitalised(this.getName());
    }

    public String getDsdName() {
        return StringUtils.capitalised(this.getName());
    }

    protected int defaultDisplayOrder() {
        return 100;
    }

    protected String defaultDescription() {
        return null;
    }

    protected Integer defaultCacheLimit() {
        return new Integer(100);
    }

    protected boolean defaultRememberAllTroids() {
        return false;
    }

    protected String defaultCategory() {
        return "Normal";
    }

    public void createTableInfo() throws PoemException {
        if (this.info == null) {
            this.info = this.getDatabase().getTableInfoTable().defaultTableInfoFor(this);
            try {
                this.getDatabase().getTableInfoTable().create(this.info);
            }
            catch (PoemException e) {
                throw new UnificationPoemException("Problem creating new tableInfo for table " + this.getName() + ":", e);
            }
            this.setTableInfo(this.info);
        }
    }

    public synchronized void unifyWithColumnInfo() throws PoemException {
        if (this.info == null) {
            throw new PoemBugPoemException("Get the initialisation order right ...");
        }
        Enumeration ci = this.database.getColumnInfoTable().getTableinfoColumn().selectionWhereEq(this.info.troid());
        while (ci.hasMoreElements()) {
            ColumnInfo columnInfo = (ColumnInfo)ci.nextElement();
            Column column = this._getColumn(columnInfo.getName());
            if (column == null) {
                column = ExtraColumn.from(this, columnInfo, this.extrasIndex++, DefinitionSource.infoTables);
                this._defineColumn(column);
            }
            column.setColumnInfo(columnInfo);
        }
        Enumeration c = this.columns();
        while (c.hasMoreElements()) {
            ((Column)c.nextElement()).createColumnInfo();
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void unifyWithDB(ResultSet colDescs) throws PoemException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void init() {
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object t) {
        return t instanceof JdbcTable && ((Table)t).getName().equals(this.name);
    }

    private class TransactionStuff {
        PreparedStatement insert;
        PreparedStatement modify;
        PreparedStatement get;

        TransactionStuff(Connection connection) {
            this.insert = JdbcTable.this._this.simpleInsert(connection);
            this.modify = JdbcTable.this._this.simpleModify(connection);
            this.get = JdbcTable.this._this.simpleGet(connection);
        }
    }
}

