/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AtomPoemType;
import org.melati.poem.ColumnInfo;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.util.StringUtils;

public class TimestampPoemType
extends AtomPoemType {
    public static final DateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public TimestampPoemType(boolean nullable) {
        super(93, "TIMESTAMP", nullable);
    }

    public TimestampPoemType(int sqlTypeCode, String sqlTypeName, boolean nullable) {
        super(sqlTypeCode, sqlTypeName, nullable);
    }

    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof Timestamp)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        return rs.getTimestamp(col);
    }

    protected void _setRaw(PreparedStatement ps, int col, Object raw) throws SQLException {
        ps.setTimestamp(col, (Timestamp)raw);
    }

    protected String _stringOfRaw(Object raw) {
        return format.format((Date)raw);
    }

    protected Object _rawOfString(String raw) {
        try {
            return new Timestamp(format.parse(raw).getTime());
        }
        catch (ParseException e) {
            try {
                return Timestamp.valueOf(raw);
            }
            catch (IllegalArgumentException e2) {
                throw new ParsingPoemException(this, raw, e2);
            }
        }
    }

    protected String _stringOfCooked(Object cooked, PoemLocale locale, int style) {
        return locale.timestampFormat(style).format((Timestamp)cooked);
    }

    protected boolean _canRepresent(SQLPoemType other) {
        return other instanceof TimestampPoemType;
    }

    public String toDsdType() {
        return "Timestamp";
    }

    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.TIMESTAMP);
    }

    protected String _quotedRaw(Object raw) {
        return StringUtils.quoted(this._stringOfRaw(raw), '\'');
    }
}

