/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Base64;
import org.melati.poem.AccessPoemException;
import org.melati.poem.BinaryLengthValidationPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.PoemType;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.SizedAtomPoemType;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.util.StringUtils;

public class BinaryPoemType
extends SizedAtomPoemType<byte[]> {
    public BinaryPoemType(boolean nullable, int size) {
        super(-3, "VARBINARY", nullable, size);
    }

    @Override
    protected void _assertValidRaw(Object raw) throws ValidationPoemException {
        if (raw != null) {
            if (!(raw instanceof byte[])) {
                throw new TypeMismatchPoemException(raw, this);
            }
            if (!BinaryPoemType.sizeGreaterEqual(this.getSize(), ((byte[])raw).length)) {
                throw new BinaryLengthValidationPoemException((PoemType<?>)this, (byte[])raw);
            }
        }
    }

    @Override
    protected String _stringOfRaw(Object raw) {
        return new String(Base64.encodeBase64((byte[])((byte[])raw)));
    }

    @Override
    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        return rs.getBytes(col);
    }

    @Override
    protected void _setRaw(PreparedStatement ps, int col, Object string) throws SQLException {
        ps.setBytes(col, (byte[])string);
    }

    @Override
    protected byte[] _rawOfString(String rawString) {
        return Base64.decodeBase64((byte[])rawString.getBytes());
    }

    @Override
    protected String _sqlDefinition(Dbms dbms) {
        try {
            return dbms.getBinarySqlDefinition(this.getSize());
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return this.sqlTypeCode() == other.sqlTypeCode() && other instanceof BinaryPoemType && BinaryPoemType.sizeGreaterEqual(this.getSize(), ((BinaryPoemType)other).getSize());
    }

    @Override
    public String toString() {
        return (this.getNullable() ? "nullable " : "") + "binary(" + this.getSize() + ")";
    }

    @Override
    public String toDsdType() {
        return "byte[]";
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.BINARY);
        columnInfo.setSize(this.getSize());
    }

    @Override
    protected String _quotedRaw(Object raw) {
        return StringUtils.quoted(this._stringOfRaw(raw), '\'');
    }
}

