/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.lang.reflect.Method;
import java.util.Enumeration;
import org.melati.poem.AppBugPoemException;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.Persistent;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.Table;
import org.melati.poem.TableFactory;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.util.ClassUtils;
import org.melati.poem.util.StringUtils;

public final class PersistentFactory {
    private PersistentFactory() {
    }

    public static Persistent fromInstance(Database db, Object pojo) {
        System.err.println("fromInstance - looking for " + pojo.getClass().getName());
        Table table = null;
        Persistent p = null;
        if (pojo instanceof Persistent) {
            if (((Persistent)pojo).troid() != null) {
                return (Persistent)pojo;
            }
            p = PersistentFactory.populatedPersistent(((Persistent)pojo).getTable(), pojo);
            p.makePersistent();
            return p;
        }
        table = TableFactory.fromInstance(db, pojo);
        p = PersistentFactory.populatedPersistent(table, pojo);
        Enumeration<Persistent> candidates = table.selection(p);
        while (candidates.hasMoreElements()) {
            Persistent candidate = candidates.nextElement();
            if (PersistentFactory.commonFieldsEqual(p, candidate)) {
                p = candidate;
                System.err.println("Candidate: " + p);
                break;
            }
            System.err.println("Non Candidate: " + p);
        }
        if (p.getTroid() == null) {
            System.err.println("About to persist : " + p);
            p.makePersistent();
            System.err.println("Have persisted : " + p);
        }
        System.err.println("Returning : " + p);
        return p;
    }

    private static boolean commonFieldsEqual(Persistent criterion, Persistent candidate) {
        Enumeration<Column<?>> cols = criterion.getTable().columns();
        while (cols.hasMoreElements()) {
            Column<?> col = cols.nextElement();
            if (col.isTroidColumn() || col.getRaw(criterion) == null || col.getRaw(criterion).equals(col.getRaw(candidate))) continue;
            System.err.println("Reject");
            return false;
        }
        return true;
    }

    public static Persistent populatedPersistent(Table table, Object pojo) {
        if (pojo instanceof Persistent) {
            if (((Persistent)pojo).troid() != null) {
                return table.getObject((int)((Persistent)pojo).troid());
            }
            return (Persistent)pojo;
        }
        Persistent p = table.newPersistent();
        Class<?> c = pojo.getClass();
        Enumeration<Column<?>> columns = table.columns();
        while (columns.hasMoreElements()) {
            Object raw;
            Method memberGetter;
            Column<?> col = columns.nextElement();
            if (col.isTroidColumn()) continue;
            try {
                memberGetter = c.getMethod("get" + StringUtils.capitalised(col.getName()), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    memberGetter = c.getMethod("is" + StringUtils.capitalised(col.getName()), new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw new AppBugPoemException("No getter available for field " + col.getName() + " on object of class " + pojo.getClass().getName(), e1);
                }
            }
            try {
                raw = memberGetter.invoke(pojo, new Object[0]);
            }
            catch (Exception e) {
                throw new AppBugPoemException("Problem invoking getter on column  " + col.getName(), e);
            }
            if (raw == null) continue;
            try {
                if (col.getType() instanceof ReferencePoemType) {
                    p.setCooked(col.getName(), PersistentFactory.fromInstance(table.getDatabase(), raw));
                    continue;
                }
                p.setCooked(col.getName(), raw);
            }
            catch (TypeMismatchPoemException e) {
                throw new AppBugPoemException("Problem setting value of Column " + col.getName(), e);
            }
        }
        return p;
    }

    public static Object from(Persistent persistent, Class<?> clazz) throws NoSuchMethodException {
        Object it;
        try {
            it = clazz.newInstance();
        }
        catch (Exception e) {
            throw new AppBugPoemException("Problem creating new instance of " + clazz.getName(), e);
        }
        return PersistentFactory.populatedPojo(it, persistent);
    }

    private static Object populatedPojo(Object pojo, Persistent persistent) throws NoSuchMethodException {
        Enumeration<Column<?>> columns = persistent.getTable().columns();
        while (columns.hasMoreElements()) {
            Object cooked;
            Column<?> col = columns.nextElement();
            if (col.isTroidColumn() && !(pojo instanceof Persistent) || (cooked = col.getCooked(persistent)) == null) continue;
            String setterName = "set" + StringUtils.capitalised(col.getName());
            Method[] possibleSetters = ClassUtils.getOneArgumentMethods(pojo.getClass(), setterName);
            if (possibleSetters.length == 0) {
                throw new NoSuchMethodException("No setter called " + setterName + " could be found " + "on Class " + pojo.getClass().getName());
            }
            for (int i = 0; i < possibleSetters.length; ++i) {
                if (col.getType() instanceof ReferencePoemType) {
                    Object newPojo = PersistentFactory.from((Persistent)cooked, possibleSetters[i].getParameterTypes()[0]);
                    try {
                        possibleSetters[i].invoke(pojo, newPojo);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AppBugPoemException("Problem setting value of Column " + col.getName(), e);
                    }
                }
                try {
                    possibleSetters[i].invoke(pojo, cooked);
                    continue;
                }
                catch (Exception e) {
                    throw new AppBugPoemException("Problem setting value of Column " + col.getName(), e);
                }
            }
        }
        return pojo;
    }
}

