/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import org.melati.poem.CachedQuery;
import org.melati.poem.Persistent;
import org.melati.poem.Table;
import org.melati.poem.util.MappedEnumeration;

public class CachedSelection
extends CachedQuery {
    public CachedSelection(Table table, String whereClause, String orderByClause, Table[] otherTables) {
        super(table, null, otherTables);
        String fromClause = table.quotedName();
        if (otherTables != null) {
            for (int i = 0; i < otherTables.length; ++i) {
                fromClause = fromClause + ", " + otherTables[i].quotedName();
            }
        }
        this.setQuery(table.selectionSQL(fromClause, whereClause, orderByClause, false, true));
    }

    public CachedSelection(Table table, String whereClause, String orderByClause) {
        this(table, whereClause, orderByClause, null);
    }

    public Enumeration troids() {
        this.compute();
        return this.rows.elements();
    }

    public Enumeration objects() {
        return new MappedEnumeration(this.troids()){

            public Object mapped(Object troid) {
                return CachedSelection.this.table.getObject((Integer)troid);
            }
        };
    }

    public Persistent firstObject() {
        return this.nth(0);
    }

    public Persistent nth(int n) {
        this.compute();
        return this.rows.size() <= n ? null : this.table.getObject((Integer)this.rows.elementAt(n));
    }

    public int count() {
        this.compute();
        return this.rows.size();
    }
}

