/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.melati.poem.ConnectionPendingException;
import org.melati.poem.Database;
import org.melati.poem.DatabaseInitialisationPoemException;

public final class PoemDatabaseFactory {
    private static final Hashtable databases = new Hashtable();
    private static PoemShutdownThread poemShutdownThread = new PoemShutdownThread();
    private static final Object pending = new Object();

    private PoemDatabaseFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector initialisedDatabases() {
        Vector dbs = new Vector();
        Enumeration e = null;
        Hashtable hashtable = databases;
        synchronized (hashtable) {
            e = databases.keys();
            while (e.hasMoreElements()) {
                Object dbOrPending = databases.get(e.nextElement());
                if (dbOrPending == pending) continue;
                dbs.addElement(dbOrPending);
            }
        }
        return dbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getInitialisedDatabaseNames() {
        Vector<String> dbs = new Vector<String>();
        Enumeration e = null;
        Hashtable hashtable = databases;
        synchronized (hashtable) {
            e = databases.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object dbOrPending = databases.get(key);
                if (dbOrPending == pending) continue;
                dbs.addElement(key);
            }
        }
        return dbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String name) throws DatabaseInitialisationPoemException {
        Object dbOrPending;
        if (name == null) {
            throw new NullPointerException();
        }
        Hashtable hashtable = databases;
        synchronized (hashtable) {
            dbOrPending = databases.get(name);
        }
        if (dbOrPending == pending) {
            throw new ConnectionPendingException(name);
        }
        return (Database)dbOrPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String name, String url, String user, String password, String clazz, String dbmsClass, boolean addConstraints, boolean logSQL, boolean logCommits, int maxTransactions) {
        Object dbOrPending;
        Hashtable hashtable = databases;
        synchronized (hashtable) {
            dbOrPending = databases.get(name);
        }
        if (dbOrPending == pending) {
            throw new ConnectionPendingException(name);
        }
        if (dbOrPending != null) {
            return (Database)dbOrPending;
        }
        databases.put(name, pending);
        Database database = null;
        try {
            try {
                Object databaseObject = null;
                try {
                    databaseObject = Thread.currentThread().getContextClassLoader().loadClass(clazz).newInstance();
                }
                catch (Exception e) {
                    databaseObject = Class.forName(clazz).newInstance();
                }
                if (!(databaseObject instanceof Database)) {
                    throw new ClassCastException("The .class=" + clazz + " entry named a class of type " + databaseObject.getClass() + ", " + "which is not an org.melati.poem.Database");
                }
                database = (Database)databaseObject;
                database.setLogSQL(logSQL);
                database.setLogCommits(logCommits);
                database.connect(name, dbmsClass, url, user, password, maxTransactions);
                if (addConstraints) {
                    database.addConstraints();
                }
            }
            finally {
                databases.remove(name);
            }
            databases.put(name, database);
        }
        catch (Exception e) {
            throw new DatabaseInitialisationPoemException(name, e);
        }
        return database;
    }

    public static void removeDatabase(String name) {
        databases.remove(name);
    }

    public static void disconnectDatabase(String name) {
        Database db = (Database)databases.get(name);
        if (db != null && db.getCommittedConnection() != null) {
            db.disconnect();
            databases.remove(name);
        }
    }

    public static void disconnectFromDatabases() {
        Vector dbs = PoemDatabaseFactory.getInitialisedDatabaseNames();
        Enumeration them = dbs.elements();
        while (them.hasMoreElements()) {
            PoemDatabaseFactory.disconnectDatabase((String)them.nextElement());
        }
    }

    public static PoemShutdownThread getPoemShutdownThread() {
        return poemShutdownThread;
    }

    public static class PoemShutdownThread
    extends Thread {
        private static Boolean haveRun = Boolean.FALSE;

        public PoemShutdownThread() {
            this.setName("PoemShutdownThread");
            try {
                Runtime.getRuntime().addShutdownHook(this);
                System.err.println("\n*** PoemShutdownThread registered. ***\n");
            }
            catch (IllegalStateException e) {
                System.err.println("\n*** PoemShutdownThread tried to register during shutdown. ***\n");
                Object var1_2 = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Boolean bl = haveRun;
            synchronized (bl) {
                if (!haveRun.booleanValue()) {
                    haveRun = Boolean.TRUE;
                    try {
                        boolean removed = Runtime.getRuntime().removeShutdownHook(this);
                        System.err.println("\n*** PoemShutdownThread removed: " + removed + " ***\n");
                    }
                    catch (IllegalStateException e) {
                        System.err.println("\n*** PoemShutdownThread cannot be removed at this stage. ***\n");
                        Object var2_4 = null;
                    }
                    System.err.println("*** PoemShutdownThread starting to shutdown dbs. ***");
                    PoemDatabaseFactory.disconnectFromDatabases();
                    System.err.println("*** PoemShutdownThread has shutdown dbs. ***");
                } else {
                    System.err.println("*** PoemShutdownThread has already run. ***");
                }
            }
        }
    }
}

