/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Hashtable;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.PoemException;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.Setting;
import org.melati.poem.generated.SettingTableBase;

public class SettingTable
extends SettingTableBase {
    private static final Object nullEntry = new Object();
    private Hashtable cache = null;
    private long cacheSerial = 0L;

    public SettingTable(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public Object getCooked(String name) {
        if (this.cache == null || this.cacheSerial != this.serial(PoemThread.transaction())) {
            this.cacheSerial = this.serial(PoemThread.transaction());
            this.cache = new Hashtable();
        } else {
            Object value = this.cache.get(name);
            if (value == nullEntry) {
                return null;
            }
            if (value != null) {
                return value;
            }
        }
        Setting prop = (Setting)this.getNameColumn().firstWhereEq(name);
        if (prop == null) {
            this.cache.put(name, nullEntry);
            return null;
        }
        Object propValue = prop.getCooked();
        this.cache.put(name, propValue == null ? nullEntry : propValue);
        return propValue;
    }

    public String get(String name) {
        Object it = this.getCooked(name);
        return it == null ? null : it.toString();
    }

    public Object getOrDie(String name) {
        String it = this.get(name);
        if (it == null) {
            throw new UnsetException(name);
        }
        return it;
    }

    public Setting ensure(String name, PoemTypeFactory typefactory, Object value, String displayname, String description) {
        Setting setting = (Setting)this.getNameColumn().firstWhereEq(name);
        if (setting != null) {
            return setting;
        }
        setting = (Setting)this.newPersistent();
        setting.setName(name);
        setting.setDisplayname(displayname);
        setting.setDescription(description);
        setting.setUsereditable(true);
        setting.setWidth(20);
        setting.setHeight(1);
        setting.setPrecision(22);
        setting.setScale(2);
        setting.setNullable(true);
        setting.setSize(-1);
        setting.setTypefactory(typefactory);
        setting.setRaw(value);
        return (Setting)this.getNameColumn().ensure(setting);
    }

    public Setting ensure(String name, String value, String displayname, String description) {
        return this.ensure(name, PoemTypeFactory.STRING, value, displayname, description);
    }

    public Setting ensure(String name, int value, String displayname, String description) {
        return this.ensure(name, PoemTypeFactory.INTEGER, new Integer(value), displayname, description);
    }

    public Setting ensure(String name, boolean value, String displayname, String description) {
        return this.ensure(name, PoemTypeFactory.BOOLEAN, value ? Boolean.TRUE : Boolean.FALSE, displayname, description);
    }

    public static class UnsetException
    extends PoemException {
        private static final long serialVersionUID = 1L;
        public String name;

        public UnsetException(String name) {
            this.name = name;
        }

        public String getMessage() {
            return "The application's `" + this.name + "' parameter has not been set";
        }
    }
}

