/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.PoemType;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.SizedAtomPoemType;
import org.melati.poem.StringLengthValidationPoemException;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.util.StringUtils;

public class StringPoemType
extends SizedAtomPoemType {
    public static final StringPoemType nullableInstance = new StringPoemType(true, -1);

    public StringPoemType(boolean nullable, int size) {
        super(12, "VARCHAR", nullable, size);
    }

    protected void _assertValidRaw(Object raw) throws ValidationPoemException {
        if (raw != null) {
            if (!(raw instanceof String)) {
                throw new TypeMismatchPoemException(raw, this);
            }
            if (!StringPoemType.sizeGreaterEqual(this.getSize(), ((String)raw).length())) {
                throw new StringLengthValidationPoemException((PoemType)this, (String)raw);
            }
        }
    }

    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        return rs.getString(col);
    }

    protected void _setRaw(PreparedStatement ps, int col, Object string) throws SQLException {
        ps.setString(col, (String)string);
    }

    protected Object _rawOfString(String rawString) {
        return rawString;
    }

    protected String _sqlDefinition(Dbms dbms) {
        try {
            return dbms.getStringSqlDefinition(this.getSize());
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    protected boolean _canRepresent(SQLPoemType other) {
        return other instanceof StringPoemType && StringPoemType.sizeGreaterEqual(this.getSize(), ((StringPoemType)other).getSize());
    }

    public String toString() {
        return (this.getNullable() ? "nullable " : "") + "String(" + this.getSize() + ")";
    }

    public String toDsdType() {
        return "String";
    }

    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.STRING);
        columnInfo.setSize(this.getSize());
    }

    protected String _quotedRaw(Object raw) {
        return StringUtils.quoted((String)raw, '\'');
    }
}

