/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.JdbcTable;
import org.melati.poem.Table;
import org.melati.poem.TableRenamePoemException;
import org.melati.poem.generated.TableInfoBase;

public class TableInfo
extends TableInfoBase {
    private Table _actualTable = null;

    public TableInfo() {
    }

    public TableInfo(JdbcTable table) {
        this.setName_unsafe(table.getName());
        this.setDisplayname_unsafe(table.defaultDisplayName());
        this.setDisplayorder_unsafe(new Integer(table.defaultDisplayOrder()));
        this.setDescription_unsafe(table.defaultDescription());
        this.setCachelimit_unsafe(table.defaultCacheLimit());
        this.setSeqcached_unsafe(table.defaultRememberAllTroids() ? Boolean.TRUE : Boolean.FALSE);
        this.setCategory_unsafe(table.getDatabase().getTableCategoryTable().ensure(table.defaultCategory()).troid());
    }

    public Table actualTable() {
        if (this._actualTable == null && this.troid() != null) {
            this._actualTable = this.getDatabase().tableWithTableInfoID(this.troid());
        }
        return this._actualTable;
    }

    public void assertCanRead(AccessToken token) {
    }

    public void setName(String name) {
        String current = this.getName();
        if (current != null && !current.equals(name)) {
            throw new TableRenamePoemException(name);
        }
        super.setName(name);
    }

    public void setSeqcached(Boolean b) throws AccessPoemException {
        super.setSeqcached(b);
        Table t = this.actualTable();
        if (t != null) {
            t.rememberAllTroids(b);
        }
    }

    public void setCachelimit(Integer limit) throws AccessPoemException {
        super.setCachelimit(limit);
        Table t = this.actualTable();
        if (t != null) {
            t.setCacheLimit(limit);
        }
    }
}

