/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.dbms.AnsiStandard;
import org.melati.poem.util.StringUtils;

public class Hsqldb
extends AnsiStandard {
    public static int hsqldbTextHack = 266;

    public Hsqldb() {
        this.setDriverClassName("org.hsqldb.jdbcDriver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Connection connection) throws SQLException {
        if (!connection.isClosed()) {
            Statement st = connection.createStatement();
            try {
                st.execute("SHUTDOWN SCRIPT");
            }
            catch (SQLException e) {
                if (!e.getMessage().equals("Access is denied: Session is closed")) {
                    throw e;
                }
            }
            finally {
                st.close();
            }
        }
    }

    public String createTableTypeQualifierSql(Table table) {
        String tableType = table == null || table.getDbmsTableType() == null ? "CACHED " : table.getDbmsTableType() + " ";
        return tableType;
    }

    public String getStringSqlDefinition(int size) {
        if (size < 0) {
            return "LONGVARCHAR";
        }
        return "VARCHAR(" + size + ")";
    }

    public String getLongSqlDefinition() {
        return "BIGINT";
    }

    public String getBinarySqlDefinition(int size) throws SQLException {
        return "LONGVARBINARY";
    }

    public PoemType canRepresent(PoemType storage, PoemType type) {
        if (storage instanceof StringPoemType && type instanceof StringPoemType) {
            if (((StringPoemType)storage).getSize() == hsqldbTextHack && ((StringPoemType)type).getSize() == -1 && (storage.getNullable() || !type.getNullable())) {
                return type;
            }
            return storage.canRepresent(type);
        }
        if (storage instanceof BinaryPoemType && type instanceof BinaryPoemType) {
            if (!(((BinaryPoemType)storage).getSize() != 0 && ((BinaryPoemType)storage).getSize() <= ((BinaryPoemType)type).getSize() || !storage.getNullable() && type.getNullable())) {
                return type;
            }
            return storage.canRepresent(type);
        }
        return super.canRepresent(storage, type);
    }

    public String unreservedName(String name) {
        if (name.equalsIgnoreCase("UNIQUE")) {
            name = "MELATI_" + name.toUpperCase();
        }
        if (name.equalsIgnoreCase("CONSTRAINT")) {
            name = "MELATI_" + name.toUpperCase();
        }
        return name.toUpperCase();
    }

    public String melatiName(String name) {
        if (name == null) {
            return name;
        }
        if (name.equalsIgnoreCase("MELATI_UNIQUE")) {
            name = "UNIQUE";
        }
        if (name.equalsIgnoreCase("MELATI_CONSTRAINT")) {
            name = "CONSTRAINT";
        }
        return name.toLowerCase();
    }

    public String caseInsensitiveRegExpSQL(String term1, String term2) {
        if (StringUtils.isQuoted(term2)) {
            term2 = term2.substring(1, term2.length() - 1);
        }
        term2 = StringUtils.quoted(StringUtils.quoted(term2, '%'), '\'');
        return term1 + " LIKE " + term2;
    }

    public String getForeignKeyDefinition(String tableName, String fieldName, String targetTableName, String targetTableFieldName, String fixName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ADD FOREIGN KEY (" + this.getQuotedName(fieldName) + ") REFERENCES " + this.getQuotedName(targetTableName) + "(" + this.getQuotedName(targetTableFieldName) + ")");
        if (fixName.equals("delete")) {
            sb.append(" ON DELETE CASCADE");
        }
        if (fixName.equals("clear")) {
            sb.append(" ON DELETE SET NULL");
        }
        return sb.toString();
    }

    public String getJdbcMetadataName(String name) {
        return name.toUpperCase();
    }
}

