/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SizedAtomPoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.dbms.AnsiStandard;
import org.melati.poem.dbms.DuplicateKeySQLPoemException;
import org.melati.poem.util.StringUtils;

public class MySQL
extends AnsiStandard {
    public static final int indexSize = 30;
    public static final int mysqlTextSize = 65535;

    public MySQL() {
        this.setDriverClassName("org.gjt.mm.mysql.Driver");
    }

    public String createTableOptionsSql() {
        return " TYPE='InnoDB' ";
    }

    public String getSqlDefinition(String sqlTypeName) {
        if (sqlTypeName.equals("BOOLEAN")) {
            return "BOOL";
        }
        return super.getSqlDefinition(sqlTypeName);
    }

    public String getStringSqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "TEXT";
        }
        return super.getStringSqlDefinition(size);
    }

    public String getBinarySqlDefinition(int size) {
        return "BLOB";
    }

    public String getQuotedName(String name) {
        return this.unreservedName(name);
    }

    public PoemType canRepresent(PoemType storage, PoemType type) {
        if (storage instanceof IntegerPoemType && type instanceof BooleanPoemType && (storage.getNullable() || !type.getNullable())) {
            return type;
        }
        return storage.canRepresent(type);
    }

    public SQLPoemType defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        boolean nullable = md.getInt("NULLABLE") == 1;
        String typeName = md.getString("TYPE_NAME");
        if (typeName.equals("blob")) {
            return new BlobPoemType(nullable, md.getInt("COLUMN_SIZE"));
        }
        if (typeName.equals("text")) {
            return new MySQLStringPoemType(nullable, md.getInt("COLUMN_SIZE"));
        }
        if (typeName.equals("smallint")) {
            return new IntegerPoemType(nullable);
        }
        if (typeName.equals("char")) {
            return new StringPoemType(nullable, 1);
        }
        if (typeName.equals("tinyint")) {
            return new MySQLBooleanPoemType(nullable);
        }
        return super.defaultPoemTypeOfColumnMetaData(md);
    }

    public SQLPoemException exceptionForUpdate(Table table, String sql, boolean insert, SQLException e) {
        String m = e.getMessage();
        if (m != null && m.indexOf("1062") >= 0) {
            try {
                int preIndex = m.indexOf(39);
                int postIndex = m.lastIndexOf(39);
                int preColumn = m.indexOf("key ");
                String indexValue = m.substring(preIndex + 1, postIndex);
                String indexColumn = m.substring(preColumn + 4);
                System.err.println("Duplicated value " + indexValue + " of " + indexColumn + "th unique field.");
                int indexNum = Integer.parseInt(indexColumn);
                Column column = table.troidColumn();
                Enumeration columns = table.columns();
                while (columns.hasMoreElements() && (!(column = (Column)columns.nextElement()).getUnique() || --indexNum != 0)) {
                }
                if (indexNum == 0) {
                    return new DuplicateKeySQLPoemException(column, sql, insert, e);
                }
            }
            catch (NumberFormatException f) {
                throw new RuntimeException("Number format exception parsing dbms error.");
            }
            return new DuplicateKeySQLPoemException(table, sql, insert, e);
        }
        return super.exceptionForUpdate(table, sql, insert, e);
    }

    public String unreservedName(String name) {
        if (name.equalsIgnoreCase("group")) {
            name = "poem_" + name;
        }
        if (name.equalsIgnoreCase("precision")) {
            name = "poem_" + name;
        }
        if (name.equalsIgnoreCase("unique")) {
            name = "poem_" + name;
        }
        return name;
    }

    public String melatiName(String name) {
        if (name == null) {
            return name;
        }
        if (name.equalsIgnoreCase("poem_group")) {
            name = "group";
        }
        if (name.equalsIgnoreCase("poem_precision")) {
            name = "precision";
        }
        if (name.equalsIgnoreCase("poem_unique")) {
            name = "unique";
        }
        return name;
    }

    public String getIndexLength(Column column) {
        PoemType t = column.getType();
        if (t instanceof StringPoemType && ((StringPoemType)t).getSize() < 0) {
            return "(30)";
        }
        if (t instanceof BinaryPoemType) {
            return "(30)";
        }
        return "";
    }

    public String givesCapabilitySQL(Integer userTroid, String capabilityExpr) {
        return "SELECT groupmembership.* FROM groupmembership LEFT JOIN groupcapability ON groupmembership." + this.getQuotedName("group") + " =  groupcapability." + this.getQuotedName("group") + " " + "WHERE " + this.getQuotedName("user") + " = " + userTroid + " " + "AND groupcapability." + this.getQuotedName("group") + " IS NOT NULL " + "AND capability = " + capabilityExpr;
    }

    public String caseInsensitiveRegExpSQL(String term1, String term2) {
        if (StringUtils.isQuoted(term2)) {
            term2 = term2.substring(1, term2.length() - 1);
        }
        term2 = StringUtils.quoted(StringUtils.quoted(term2, '%'), '\'');
        return term1 + " LIKE " + term2;
    }

    public String alterColumnNotNullableSQL(String tableName, Column column) {
        return "ALTER TABLE " + this.getQuotedName(tableName) + " CHANGE " + this.getQuotedName(column.getName()) + " " + this.getQuotedName(column.getName()) + " " + column.getSQLType().sqlDefinition(this);
    }

    public static class BlobPoemType
    extends BinaryPoemType {
        public BlobPoemType(boolean nullable, int size) {
            super(nullable, size);
        }

        protected boolean _canRepresent(SQLPoemType other) {
            return other instanceof BinaryPoemType;
        }

        public PoemType canRepresent(PoemType other) {
            return other instanceof BinaryPoemType && (this.getNullable() || !((BinaryPoemType)other).getNullable()) ? other : null;
        }
    }

    public static class MySQLBooleanPoemType
    extends BooleanPoemType {
        public MySQLBooleanPoemType(boolean nullable) {
            super(nullable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object _getRaw(ResultSet rs, int col) throws SQLException {
            ResultSet resultSet = rs;
            synchronized (resultSet) {
                int i = rs.getInt(col);
                return rs.wasNull() ? null : (i == 1 ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        protected void _setRaw(PreparedStatement ps, int col, Object bool) throws SQLException {
            ps.setInt(col, (Boolean)bool != false ? 1 : 0);
        }

        protected Object _rawOfString(String rawString) throws ParsingPoemException {
            rawString = rawString.trim();
            switch (rawString.charAt(0)) {
                case '1': {
                    return Boolean.TRUE;
                }
                case '0': {
                    return Boolean.FALSE;
                }
            }
            throw new ParsingPoemException(this, rawString);
        }
    }

    public static class MySQLStringPoemType
    extends StringPoemType {
        public MySQLStringPoemType(boolean nullable, int size) {
            super(nullable, size);
        }

        protected boolean _canRepresent(SQLPoemType other) {
            return this.sqlTypeCode() == other.sqlTypeCode() && other instanceof StringPoemType && (this.getSize() < 0 || this.getSize() == 65535 || this.getSize() >= ((StringPoemType)other).getSize());
        }

        public SizedAtomPoemType withSize(int newSize) {
            if (newSize == 65535) {
                return super.withSize(-1);
            }
            return super.withSize(newSize);
        }
    }
}

