/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.Capability;
import org.melati.poem.PoemThread;
import org.melati.poem.ReadPasswordAccessPoemException;
import org.melati.poem.UserTable;
import org.melati.poem.WriteFieldAccessPoemException;
import org.melati.poem.generated.UserBase;

public class User
extends UserBase
implements AccessToken {
    public User() {
    }

    public User(String login, String password, String name) {
        this.setLogin_unsafe(login);
        this.setPassword_unsafe(password);
        this.setName_unsafe(name);
    }

    public boolean givesCapability(Capability capability) {
        return this.getDatabase().hasCapability(this, capability);
    }

    public String getPassword() throws AccessPoemException {
        AccessToken token;
        if (this.troid() != null && (token = PoemThread.accessToken()) != this && !token.givesCapability(this.getUserTable().canReadPasswords())) {
            throw new ReadPasswordAccessPoemException(this, this.getUserTable().getPasswordColumn(), token, this.getUserTable().canReadPasswords());
        }
        return super.getPassword();
    }

    public void setPassword(String cooked) throws AccessPoemException {
        AccessToken token;
        if (this.troid() != null && (token = PoemThread.accessToken()) != this && !token.givesCapability(this.getUserTable().canWritePasswords())) {
            throw new WriteFieldAccessPoemException(this, this.getUserTable().getPasswordColumn(), token, this.getUserTable().canWritePasswords());
        }
        super.setPassword(cooked);
    }

    public String toString() {
        return this.getLogin_unsafe() == null ? super.toString() : this.getLogin_unsafe();
    }

    public boolean isGuest() {
        return this == ((UserTable)this.getTable()).guestUser();
    }

    public boolean isAdministrator() {
        return this == ((UserTable)this.getTable()).administratorUser();
    }
}

