/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Properties;
import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.DatePoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.ExecutingSQLPoemException;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.IntegrityFixPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PasswordPoemType;
import org.melati.poem.PoemBugPoemException;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLType;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.dbms.ConnectionFailurePoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.dbms.UnsupportedTypePoemException;
import org.melati.poem.util.StringUtils;

public class AnsiStandard
implements Dbms {
    private boolean driverLoaded = false;
    private String driverClassName = null;
    private Driver driver = null;
    protected String schema;

    protected synchronized void setDriverClassName(String name) {
        this.driverClassName = name;
    }

    protected synchronized String getDriverClassName() {
        if (this.driverClassName == null) {
            throw new PoemBugPoemException("No Driver Classname set in dbms specific class");
        }
        return this.driverClassName;
    }

    protected synchronized void setDriverLoaded(boolean loaded) {
        this.driverLoaded = loaded;
    }

    public void unloadDriver() {
        this.driver = null;
        this.setDriverLoaded(false);
    }

    protected synchronized boolean getDriverLoaded() {
        return this.driverLoaded;
    }

    public String getSchema() {
        return null;
    }

    public void shutdown(Connection connection) throws SQLException {
    }

    public boolean canDropColumns() {
        return true;
    }

    public boolean canStoreBlobs() {
        return true;
    }

    protected synchronized void loadDriver() {
        Class<?> driverClass;
        try {
            driverClass = Class.forName(this.getDriverClassName());
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedExceptionPoemException(e);
        }
        this.setDriverLoaded(true);
        try {
            this.driver = (Driver)driverClass.newInstance();
        }
        catch (Exception e) {
            throw new UnexpectedExceptionPoemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String url, String user, String password) throws ConnectionFailurePoemException {
        this.schema = user;
        try {
            String string = this.driverClassName;
            synchronized (string) {
                if (!this.getDriverLoaded()) {
                    this.loadDriver();
                }
            }
            Connection c = null;
            if (this.driver != null) {
                Properties info = new Properties();
                if (user != null) {
                    info.put("user", user);
                }
                if (password != null) {
                    info.put("password", password);
                }
                if ((c = this.driver.connect(url, info)) == null) {
                    throw new SQLException("Null connection from driver using url: " + url + " user: " + user + " password: " + password);
                }
            } else {
                c = DriverManager.getConnection(url, user, password);
                if (c == null) {
                    throw new SQLException("Null connection from DriverManager using url: " + url + " user: " + user + " password: " + password);
                }
            }
            if (c.getAutoCommit()) {
                c.setAutoCommit(false);
            }
            return c;
        }
        catch (Exception e) {
            throw new ConnectionFailurePoemException(e);
        }
    }

    public String preparedStatementPlaceholder(PoemType type) {
        return "?";
    }

    public String createTableSql(Table table) {
        StringBuffer sqb = new StringBuffer();
        sqb.append("CREATE " + this.createTableTypeQualifierSql(table) + "TABLE " + table.quotedName() + " (");
        Enumeration columns = table.columns();
        int colCount = 0;
        while (columns.hasMoreElements()) {
            Column col = (Column)columns.nextElement();
            if (colCount != 0) {
                sqb.append(", ");
            }
            ++colCount;
            sqb.append(col.quotedName() + " " + col.getSQLType().sqlDefinition(this));
        }
        sqb.append(")");
        sqb.append(this.createTableOptionsSql());
        return sqb.toString();
    }

    public String createTableTypeQualifierSql(Table table) {
        return "";
    }

    public String createTableOptionsSql() {
        return "";
    }

    public String tableInitialisationSql(Table table) {
        return null;
    }

    public String getSqlDefinition(String sqlTypeName) {
        return sqlTypeName;
    }

    public String getStringSqlDefinition(int size) throws SQLException {
        if (size < 0) {
            throw new SQLException("unlimited length not supported in AnsiStandard STRINGs");
        }
        return "VARCHAR(" + size + ")";
    }

    public String getLongSqlDefinition() {
        return "INT8";
    }

    public String getBinarySqlDefinition(int size) throws SQLException {
        if (size < 0) {
            throw new SQLException("unlimited length not supported in AnsiStandard BINARYs");
        }
        return "LONGVARBINARY(" + size + ")";
    }

    public String getFixedPtSqlDefinition(int scale, int precision) throws SQLException {
        if (scale < 0) {
            throw new SQLException("negative scale not supported in AnsiStandard DECIMALs");
        }
        if (precision <= 0) {
            throw new SQLException("nonpositive precision not supported in AnsiStandard DECIMALs");
        }
        return "DECIMAL(" + precision + "," + scale + ")";
    }

    public String sqlBooleanValueOfRaw(Object raw) {
        return raw.toString();
    }

    public PoemType canRepresent(PoemType storage, PoemType type) {
        return storage.canRepresent(type);
    }

    private SQLPoemType unsupported(String sqlTypeName, ResultSet md) throws UnsupportedTypePoemException {
        UnsupportedTypePoemException e;
        try {
            e = new UnsupportedTypePoemException(md.getString("TABLE_NAME"), md.getString("COLUMN_NAME"), md.getShort("DATA_TYPE"), sqlTypeName, md.getString("TYPE_NAME"));
        }
        catch (SQLException ee) {
            throw new UnsupportedTypePoemException(sqlTypeName);
        }
        throw e;
    }

    public SQLPoemType defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        short typeCode = md.getShort("DATA_TYPE");
        boolean nullable = md.getInt("NULLABLE") == 1;
        int width = md.getInt("COLUMN_SIZE");
        int scale = md.getInt("DECIMAL_DIGITS");
        switch (typeCode) {
            case -7: {
                return new BooleanPoemType(nullable);
            }
            case -6: {
                return this.unsupported("TINYINT", md);
            }
            case 5: {
                return this.unsupported("SMALLINT", md);
            }
            case 4: {
                return new IntegerPoemType(nullable);
            }
            case -5: {
                return new LongPoemType(nullable);
            }
            case 6: {
                return this.unsupported("FLOAT", md);
            }
            case 7: {
                return new DoublePoemType(nullable);
            }
            case 8: {
                return new DoublePoemType(nullable);
            }
            case 2: {
                return new BigDecimalPoemType(nullable, width, scale);
            }
            case 3: {
                return new BigDecimalPoemType(nullable, width, scale);
            }
            case 1: {
                return this.unsupported("CHAR", md);
            }
            case 12: {
                return new StringPoemType(nullable, width == 0 ? -1 : width);
            }
            case -1: {
                return new StringPoemType(nullable, width == 0 ? -1 : width);
            }
            case 91: {
                return new DatePoemType(nullable);
            }
            case 92: {
                return this.unsupported("TIME", md);
            }
            case 93: {
                return new TimestampPoemType(nullable);
            }
            case -2: {
                return this.unsupported("BINARY", md);
            }
            case -3: {
                return new BinaryPoemType(nullable, width);
            }
            case -4: {
                return new BinaryPoemType(nullable, width);
            }
            case 0: {
                return this.unsupported("NULL", md);
            }
            case 1111: {
                return this.unsupported("OTHER", md);
            }
            case 2000: {
                return this.unsupported("JAVA_OBJECT", md);
            }
            case 2001: {
                return this.unsupported("DISTINCT", md);
            }
            case 2002: {
                return this.unsupported("STRUCT", md);
            }
            case 2003: {
                return this.unsupported("ARRAY", md);
            }
            case 2004: {
                return this.unsupported("BLOB", md);
            }
            case 2005: {
                return this.unsupported("CLOB", md);
            }
            case 2006: {
                return this.unsupported("REF", md);
            }
            case 70: {
                return this.unsupported("DATLINK", md);
            }
            case 16: {
                return new BooleanPoemType(nullable);
            }
        }
        return this.unsupported("<code not in Types.java!>", md);
    }

    public SQLPoemException exceptionForUpdate(Table table, String sql, boolean insert, SQLException e) {
        return new ExecutingSQLPoemException(sql, e);
    }

    public SQLPoemException exceptionForUpdate(Table table, PreparedStatement ps, boolean insert, SQLException e) {
        return this.exceptionForUpdate(table, ps == null ? null : ps.toString(), insert, e);
    }

    public String getQuotedName(String name) {
        StringBuffer b = new StringBuffer();
        StringUtils.appendQuoted(b, this.unreservedName(name), '\"');
        return b.toString();
    }

    public String getQuotedValue(SQLType sqlType, String value) {
        if (sqlType instanceof BooleanPoemType) {
            return value;
        }
        if (sqlType instanceof DoublePoemType) {
            return value;
        }
        if (sqlType instanceof LongPoemType) {
            return value;
        }
        if (sqlType instanceof BinaryPoemType) {
            return StringUtils.quoted(value, '\'');
        }
        if (sqlType instanceof BigDecimalPoemType) {
            return value;
        }
        if (sqlType instanceof DatePoemType) {
            return StringUtils.quoted(value, '\'');
        }
        if (sqlType instanceof TimestampPoemType) {
            return StringUtils.quoted(value, '\'');
        }
        if (sqlType instanceof PasswordPoemType) {
            return StringUtils.quoted(value, '\'');
        }
        if (sqlType instanceof StringPoemType) {
            return StringUtils.quoted(value, '\'');
        }
        if (sqlType instanceof IntegrityFixPoemType) {
            return value;
        }
        if (sqlType instanceof IntegerPoemType) {
            return value;
        }
        throw new PoemBugPoemException("Unrecognised sqlType: " + sqlType);
    }

    public String getJdbcMetadataName(String name) {
        return name;
    }

    public String unreservedName(String name) {
        return name;
    }

    public String melatiName(String name) {
        return name;
    }

    public String getIndexLength(Column column) {
        return "";
    }

    public boolean canBeIndexed(Column column) {
        return true;
    }

    public String givesCapabilitySQL(Integer userTroid, String capabilityExpr) {
        return "SELECT * FROM " + this.getQuotedName("groupmembership") + " WHERE " + this.getQuotedName("user") + " = " + userTroid + " AND " + "EXISTS ( " + "SELECT " + this.getQuotedName("groupcapability") + "." + this.getQuotedName("group") + " FROM " + this.getQuotedName("groupcapability") + " WHERE " + this.getQuotedName("groupcapability") + "." + this.getQuotedName("group") + " = " + this.getQuotedName("groupmembership") + "." + this.getQuotedName("group") + " AND " + this.getQuotedName("capability") + " = " + capabilityExpr + ")";
    }

    public String caseInsensitiveRegExpSQL(String term1, String term2) {
        if (StringUtils.isQuoted(term2)) {
            term2 = term2.substring(1, term2.length() - 1);
        }
        term2 = StringUtils.quoted(StringUtils.quoted(term2, '%'), '\'');
        return term1 + " ILIKE " + term2;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getForeignKeyDefinition(String tableName, String fieldName, String targetTableName, String targetTableFieldName, String fixName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ADD FOREIGN KEY (" + this.getQuotedName(fieldName) + ") REFERENCES " + this.getQuotedName(targetTableName) + "(" + this.getQuotedName(targetTableFieldName) + ")");
        if (fixName.equals("prevent")) {
            sb.append(" ON DELETE RESTRICT");
        }
        if (fixName.equals("delete")) {
            sb.append(" ON DELETE CASCADE");
        }
        if (fixName.equals("clear")) {
            sb.append(" ON DELETE SET NULL");
        }
        return sb.toString();
    }

    public String getPrimaryKeyDefinition(String fieldName) {
        return " ADD PRIMARY KEY (" + this.getQuotedName(fieldName) + ")";
    }

    public String alterColumnNotNullableSQL(String tableName, Column column) {
        return "ALTER TABLE " + this.getQuotedName(tableName) + " ALTER COLUMN " + this.getQuotedName(column.getName()) + " SET NOT NULL";
    }

    public String selectLimit(String querySelection, int limit) {
        return "SELECT " + querySelection + " LIMIT " + limit;
    }

    public String booleanTrueExpression(Column booleanColumn) {
        return booleanColumn.fullQuotedName();
    }

    public String getSqlDefaultValue(SQLType sqlType) {
        if (sqlType instanceof BooleanPoemType) {
            return "false";
        }
        if (sqlType instanceof DoublePoemType) {
            return "0.0";
        }
        if (sqlType instanceof LongPoemType) {
            return "0";
        }
        if (sqlType instanceof BinaryPoemType) {
            return "";
        }
        if (sqlType instanceof BigDecimalPoemType) {
            return new BigDecimal(0.0).toString();
        }
        if (sqlType instanceof DatePoemType) {
            return new Date(new java.util.Date().getTime()).toString();
        }
        if (sqlType instanceof TimestampPoemType) {
            return new Timestamp(System.currentTimeMillis()).toString();
        }
        if (sqlType instanceof PasswordPoemType) {
            return "FIXME";
        }
        if (sqlType instanceof StringPoemType) {
            return "default";
        }
        if (sqlType instanceof IntegrityFixPoemType) {
            return StandardIntegrityFix.prevent.getIndex().toString();
        }
        if (sqlType instanceof IntegerPoemType) {
            return "0";
        }
        throw new PoemBugPoemException("Unrecognised sqlType: " + sqlType);
    }
}

