/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.melati.poem.CachedQuery;
import org.melati.poem.Persistent;
import org.melati.poem.Table;
import org.melati.poem.util.MappedEnumeration;

public class CachedSelection<T>
extends CachedQuery<T> {
    public CachedSelection(Table table, String whereClause, String orderByClause, Table[] otherTables) {
        super(table, null, otherTables);
        String fromClause = table.quotedName();
        if (otherTables != null) {
            for (int i = 0; i < otherTables.length; ++i) {
                fromClause = fromClause + ", " + otherTables[i].quotedName();
            }
        }
        this.setQuery(table.selectionSQL(fromClause, whereClause, orderByClause, false, true));
    }

    public CachedSelection(Table table, String whereClause, String orderByClause) {
        this(table, whereClause, orderByClause, null);
    }

    public Enumeration<Integer> troids() {
        this.compute();
        return this.rows.elements();
    }

    public Enumeration<T> objects() {
        return new MappedEnumeration<T, Integer>(this.troids()){

            @Override
            public T mapped(Integer troid) {
                return CachedSelection.this.table.getObject(troid);
            }
        };
    }

    public List<T> objectList() {
        return Collections.list(this.objects());
    }

    public Persistent firstObject() {
        return this.nth(0);
    }

    public Persistent nth(int n) {
        this.compute();
        return this.rows.size() <= n ? null : this.table.getObject((Integer)this.rows.elementAt(n));
    }

    public int count() {
        this.compute();
        return this.rows.size();
    }
}

