/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AtomPoemType;
import org.melati.poem.ColumnInfo;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.util.IntegerEnumeration;

public class IntegerPoemType
extends AtomPoemType<Integer> {
    public static final IntegerPoemType nullableInstance = new IntegerPoemType(true);

    public IntegerPoemType(boolean nullable) {
        super(4, "INT", nullable);
    }

    protected IntegerPoemType(int sqlTypeCode, String sqlTypeName, boolean nullable) {
        super(sqlTypeCode, sqlTypeName, nullable);
    }

    @Override
    protected Enumeration<Integer> _possibleRaws() {
        Integer low = (Integer)this.getLowRaw();
        Integer limit = (Integer)this.getLimitRaw();
        return low == null ? null : new IntegerEnumeration(low, limit == null ? Integer.MAX_VALUE : limit);
    }

    @Override
    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof Integer)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        ResultSet resultSet = rs;
        synchronized (resultSet) {
            int i = rs.getInt(col);
            return i == 0 && rs.wasNull() ? null : new Integer(i);
        }
    }

    @Override
    protected void _setRaw(PreparedStatement ps, int col, Object integer) throws SQLException {
        ps.setInt(col, (Integer)integer);
    }

    @Override
    protected Integer _rawOfString(String rawString) throws ParsingPoemException {
        try {
            return new Integer(rawString);
        }
        catch (NumberFormatException e) {
            throw new ParsingPoemException(this, rawString, e);
        }
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return other instanceof IntegerPoemType;
    }

    @Override
    public String toDsdType() {
        return "Integer";
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.INTEGER);
    }
}

