/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.BaseFieldAttributes;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.CachedCount;
import org.melati.poem.CachedExists;
import org.melati.poem.CachedSelection;
import org.melati.poem.Capability;
import org.melati.poem.Column;
import org.melati.poem.ColumnInUsePoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.DoubleCreatePoemException;
import org.melati.poem.DuplicateColumnNamePoemException;
import org.melati.poem.DuplicateDeletedColumnPoemException;
import org.melati.poem.DuplicateTroidColumnPoemException;
import org.melati.poem.DuplicateTroidPoemException;
import org.melati.poem.ExecutingSQLPoemException;
import org.melati.poem.ExtraColumn;
import org.melati.poem.Field;
import org.melati.poem.FieldContentsPoemException;
import org.melati.poem.InitialisationPoemException;
import org.melati.poem.Initialiser;
import org.melati.poem.IntegrityFix;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.NoSuchColumnPoemException;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemBugPoemException;
import org.melati.poem.PoemException;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTransaction;
import org.melati.poem.PoemType;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.RestrictedReferencePoemType;
import org.melati.poem.ResultSetEnumeration;
import org.melati.poem.RootAccessToken;
import org.melati.poem.RowDisappearedPoemException;
import org.melati.poem.SQLLogEvent;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.Searchability;
import org.melati.poem.Selectable;
import org.melati.poem.SessionToken;
import org.melati.poem.SimplePrepareFailedPoemException;
import org.melati.poem.SimpleRetrievalFailedPoemException;
import org.melati.poem.StringPoemType;
import org.melati.poem.StructuralModificationFailedPoemException;
import org.melati.poem.Table;
import org.melati.poem.TableCategory;
import org.melati.poem.TableInfo;
import org.melati.poem.TableListener;
import org.melati.poem.TroidPoemType;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.UnexpectedValidationPoemException;
import org.melati.poem.UnificationPoemException;
import org.melati.poem.UnindexableLogEvent;
import org.melati.poem.User;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.transaction.Transactioned;
import org.melati.poem.transaction.TransactionedSerial;
import org.melati.poem.util.ArrayEnumeration;
import org.melati.poem.util.ArrayUtils;
import org.melati.poem.util.Cache;
import org.melati.poem.util.CachedIndexFactory;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.FilteredEnumeration;
import org.melati.poem.util.FlattenedEnumeration;
import org.melati.poem.util.MappedEnumeration;
import org.melati.poem.util.Order;
import org.melati.poem.util.Procedure;
import org.melati.poem.util.SortUtils;
import org.melati.poem.util.StringUtils;

public class JdbcTable
implements Selectable,
Table {
    private static final int CACHE_LIMIT_DEFAULT = 100;
    private static final int DISPLAY_ORDER_DEFAULT = 100;
    private JdbcTable _this = this;
    Database database;
    private String name;
    private String quotedName;
    private DefinitionSource definitionSource;
    private TableInfo info = null;
    private TableListener[] listeners = new TableListener[0];
    private Column<?>[] columns = new Column[0];
    private Hashtable<String, Column<?>> columnsByName = new Hashtable();
    private Column<Integer> troidColumn = null;
    private Column<Boolean> deletedColumn = null;
    private Column<Capability> canReadColumn = null;
    private Column<Capability> canSelectColumn = null;
    private Column<Capability> canWriteColumn = null;
    private Column<Capability> canDeleteColumn = null;
    private Column<?> displayColumn = null;
    private Column<?> searchColumn = null;
    private String defaultOrderByClause = null;
    private Column<?>[][] displayColumns = new Column[DisplayLevel.count()][];
    private Column<?>[] searchColumns = null;
    private TransactionedSerial serial;
    private CachedSelection<Integer> allTroids = null;
    private Hashtable<String, CachedSelection<?>> cachedSelections = new Hashtable();
    private Hashtable<String, CachedCount> cachedCounts = new Hashtable();
    private Hashtable<String, CachedExists> cachedExists = new Hashtable();
    private int mostRecentTroid = -1;
    private int extrasIndex = 0;
    private CachedIndexFactory transactionStuffs = new CachedIndexFactory(){

        @Override
        public Object reallyGet(int index) {
            return new TransactionStuff(JdbcTable.this.database.poemTransaction(index).getConnection());
        }
    };
    private TransactionStuff committedTransactionStuff = null;
    private Cache cache = new Cache(100);
    private static final Procedure invalidator = new Procedure(){

        @Override
        public void apply(Object arg) {
            ((Transactioned)arg).invalidate();
        }
    };

    public JdbcTable(Database database, String name, DefinitionSource definitionSource) {
        this.database = database;
        this.name = name;
        this.definitionSource = definitionSource;
        this.serial = new TransactionedSerial(database);
    }

    @Override
    public void postInitialise() {
        this.clearColumnInfoCaches();
        this.database.getColumnInfoTable().addListener(new TableListener(){

            @Override
            public void notifyTouched(PoemTransaction transaction, Table table, Persistent persistent) {
                JdbcTable.this._this.notifyColumnInfo((ColumnInfo)persistent);
            }

            @Override
            public void notifyUncached(Table table) {
                JdbcTable.this._this.clearColumnInfoCaches();
            }
        });
    }

    @Override
    public final Database getDatabase() {
        return this.database;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String quotedName() {
        if (this.quotedName == null) {
            this.quotedName = this.database.quotedName(this.name);
        }
        return this.quotedName;
    }

    @Override
    public final String getDisplayName() {
        return this.info.getDisplayname();
    }

    @Override
    public final String getDescription() {
        return this.info.getDescription();
    }

    @Override
    public final TableCategory getCategory() {
        return this.info.getCategory();
    }

    @Override
    public final TableInfo getInfo() {
        return this.info;
    }

    @Override
    public final Integer tableInfoID() {
        return this.info == null ? null : this.info.troid();
    }

    public final Column getColumn(String nameP) throws NoSuchColumnPoemException {
        Column column = this._getColumn(nameP);
        if (column == null) {
            throw new NoSuchColumnPoemException(this, nameP);
        }
        return column;
    }

    protected final Column _getColumn(String nameP) {
        Column<?> column = this.columnsByName.get(nameP.toLowerCase());
        return column;
    }

    @Override
    public final Enumeration<Column<?>> columns() {
        return new ArrayEnumeration(this.columns);
    }

    @Override
    public final int getColumnsCount() {
        return this.columns.length;
    }

    @Override
    public Column<?> columnWithColumnInfoID(int columnInfoID) {
        Enumeration<Column<?>> c = this.columns();
        while (c.hasMoreElements()) {
            Column<?> column = c.nextElement();
            Integer id = column.columnInfoID();
            if (id == null || id != columnInfoID) continue;
            return column;
        }
        return null;
    }

    @Override
    public final Column<Integer> troidColumn() {
        return this.troidColumn;
    }

    @Override
    public final Column<Boolean> deletedColumn() {
        return this.deletedColumn;
    }

    @Override
    public final Column<?> displayColumn() {
        return this.displayColumn == null ? this.troidColumn : this.displayColumn;
    }

    @Override
    public final void setDisplayColumn(Column<?> column) {
        this.displayColumn = column;
    }

    @Override
    public final Column<?> primaryCriterionColumn() {
        return this.searchColumn;
    }

    @Override
    public void setSearchColumn(Column<?> column) {
        this.searchColumn = column;
    }

    @Override
    public String defaultOrderByClause() {
        String clause = this.defaultOrderByClause;
        if (clause == null) {
            clause = EnumUtils.concatenated(", ", new MappedEnumeration(new ArrayEnumeration(SortUtils.sorted(new Order(){

                @Override
                public boolean lessOrEqual(Object a, Object b) {
                    return ((Column)a).getDisplayOrderPriority() <= ((Column)b).getDisplayOrderPriority();
                }
            }, new FilteredEnumeration<Column<?>>(this.columns()){

                @Override
                public boolean isIncluded(Column<?> column) {
                    return column.getDisplayOrderPriority() != null;
                }
            }))){

                public Object mapped(Object column) {
                    String sort = ((Column)column).fullQuotedName();
                    if (((Column)column).getSortDescending()) {
                        sort = sort + " desc";
                    }
                    return sort;
                }
            });
            if (clause.equals("") && this.displayColumn() != null) {
                clause = this.displayColumn().fullQuotedName();
            }
            this.defaultOrderByClause = clause;
        }
        return clause;
    }

    @Override
    public void clearColumnInfoCaches() {
        this.defaultOrderByClause = null;
        for (int i = 0; i < this.displayColumns.length; ++i) {
            this.displayColumns[i] = null;
        }
    }

    @Override
    public void notifyColumnInfo(ColumnInfo infoP) {
        if (infoP == null || infoP.getTableinfo_unsafe().equals(this.tableInfoID())) {
            this.clearColumnInfoCaches();
        }
    }

    private Column<?>[] columnsWhere(String whereClause) {
        Enumeration<Integer> colIDs = this.getDatabase().getColumnInfoTable().troidSelection(this.database.quotedName("tableinfo") + " = " + this.tableInfoID() + " AND (" + whereClause + ")", null, false, PoemThread.inSession() ? PoemThread.transaction() : null);
        Vector them = new Vector();
        while (colIDs.hasMoreElements()) {
            Column<?> column = this.columnWithColumnInfoID(colIDs.nextElement());
            if (column == null) continue;
            them.addElement(column);
        }
        Object[] columnsLocal = new Column[them.size()];
        them.copyInto(columnsLocal);
        return columnsLocal;
    }

    @Override
    public final Enumeration<Column<?>> displayColumns(DisplayLevel level) {
        Column<?>[] columnsLocal = this.displayColumns[level.getIndex()];
        if (columnsLocal == null) {
            columnsLocal = this.columnsWhere(this.database.quotedName("displaylevel") + " <= " + level.getIndex());
            this.displayColumns[level.getIndex().intValue()] = columnsLocal;
        }
        return new ArrayEnumeration(columnsLocal);
    }

    @Override
    public final int displayColumnsCount(DisplayLevel level) {
        int l = level.getIndex();
        if (this.displayColumns[l] == null) {
            this.displayColumns(level);
        }
        return this.displayColumns[l].length;
    }

    @Override
    public final Enumeration<Column<?>> getDetailDisplayColumns() {
        return this.displayColumns(DisplayLevel.detail);
    }

    @Override
    public final int getDetailDisplayColumnsCount() {
        return this.displayColumnsCount(DisplayLevel.detail);
    }

    @Override
    public final Enumeration<Column<?>> getRecordDisplayColumns() {
        return this.displayColumns(DisplayLevel.record);
    }

    @Override
    public final int getRecordDisplayColumnsCount() {
        return this.displayColumnsCount(DisplayLevel.record);
    }

    @Override
    public final Enumeration<Column<?>> getSummaryDisplayColumns() {
        return this.displayColumns(DisplayLevel.summary);
    }

    @Override
    public final int getSummaryDisplayColumnsCount() {
        return this.displayColumnsCount(DisplayLevel.summary);
    }

    @Override
    public final Enumeration<Column<?>> getSearchCriterionColumns() {
        Column<?>[] columnsLocal = this.searchColumns;
        if (columnsLocal == null) {
            this.searchColumns = columnsLocal = this.columnsWhere(this.database.quotedName("searchability") + " <= " + Searchability.yes.getIndex());
        }
        return new ArrayEnumeration(this.searchColumns);
    }

    @Override
    public final int getSearchCriterionColumnsCount() {
        if (this.searchColumns == null) {
            this.getSearchCriterionColumns();
        }
        return this.searchColumns.length;
    }

    private Dbms dbms() {
        return this.getDatabase().getDbms();
    }

    @Override
    public void dbModifyStructure(String sql) throws StructuralModificationFailedPoemException {
        this.database.modifyStructure(sql);
    }

    private void dbCreateTable() {
        String createTableSql = this.dbms().createTableSql(this);
        this.database.modifyStructure(createTableSql);
        String tableSetup = this.database.getDbms().tableInitialisationSql(this);
        if (tableSetup != null) {
            this.database.modifyStructure(tableSetup);
        }
    }

    @Override
    public String getDbmsTableType() {
        return null;
    }

    @Override
    public void dbAddConstraints() {
        int c;
        StringBuffer sqb = new StringBuffer();
        for (c = 0; c < this.columns.length; ++c) {
            if (!(this.columns[c].getSQLType() instanceof TroidPoemType)) continue;
            sqb.append("ALTER TABLE " + this.quotedName());
            sqb.append(this.dbms().getPrimaryKeyDefinition(this.columns[c].getName()));
            try {
                this.dbModifyStructure(sqb.toString());
                continue;
            }
            catch (StructuralModificationFailedPoemException e2) {
                Object e2 = null;
            }
        }
        for (c = 0; c < this.columns.length; ++c) {
            if (!(this.columns[c].getSQLType() instanceof ReferencePoemType)) continue;
            IntegrityFix fix = this.columns[c].getIntegrityFix();
            sqb = new StringBuffer();
            sqb.append("ALTER TABLE " + this.quotedName());
            sqb.append(this.dbms().getForeignKeyDefinition(this.getName(), this.columns[c].getName(), ((ReferencePoemType)this.columns[c].getSQLType()).targetTable().getName(), ((ReferencePoemType)this.columns[c].getSQLType()).targetTable().troidColumn().getName(), fix.getName()));
            try {
                this.dbModifyStructure(sqb.toString());
                continue;
            }
            catch (StructuralModificationFailedPoemException e3) {
                Object e3 = null;
            }
        }
    }

    private void dbAddColumn(Column<?> column) {
        if (column.getType().getNullable()) {
            this.dbModifyStructure("ALTER TABLE " + this.quotedName() + " ADD " + column.quotedName() + " " + column.getSQLType().sqlDefinition(this.dbms()));
        } else {
            this.dbModifyStructure("ALTER TABLE " + this.quotedName() + " ADD " + column.quotedName() + " " + column.getSQLType().sqlTypeDefinition(this.dbms()));
            this.dbModifyStructure("UPDATE " + this.quotedName() + " SET " + column.quotedName() + " = " + this.dbms().getQuotedValue(column.getSQLType(), column.getSQLType().sqlDefaultValue(this.dbms())));
            this.dbModifyStructure(this.dbms().alterColumnNotNullableSQL(this.name, column));
        }
    }

    private void dbCreateIndex(Column<?> column) {
        if (column.getIndexed()) {
            if (!this.dbms().canBeIndexed(column)) {
                this.database.log(new UnindexableLogEvent(column));
            } else {
                this.dbModifyStructure("CREATE " + (column.getUnique() ? "UNIQUE " : "") + "INDEX " + this.indexName(column) + " ON " + this.quotedName() + " " + "(" + column.quotedName() + this.dbms().getIndexLength(column) + ")");
            }
        }
    }

    private String indexName(Column<?> column) {
        return this.database.quotedName(this.dbms().unreservedName(this.name) + "_" + this.dbms().unreservedName(column.getName()) + "_index");
    }

    private PreparedStatement simpleInsert(Connection connection) {
        int c;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + this.quotedName() + " (");
        for (c = 0; c < this.columns.length; ++c) {
            if (c > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[c].quotedName());
        }
        sql.append(") VALUES (");
        for (c = 0; c < this.columns.length; ++c) {
            if (c > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        try {
            return connection.prepareStatement(sql.toString());
        }
        catch (SQLException e) {
            throw new SimplePrepareFailedPoemException(sql.toString(), e);
        }
    }

    private PreparedStatement simpleGet(Connection connection) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        for (int c = 0; c < this.columns.length; ++c) {
            if (c > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[c].quotedName());
        }
        sql.append(" FROM " + this.quotedName() + " WHERE " + this.troidColumn.quotedName() + " = ?");
        try {
            return connection.prepareStatement(sql.toString());
        }
        catch (SQLException e) {
            throw new SimplePrepareFailedPoemException(sql.toString(), e);
        }
    }

    private PreparedStatement simpleModify(Connection connection) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + this.quotedName() + " SET ");
        for (int c = 0; c < this.columns.length; ++c) {
            if (c > 0) {
                sql.append(", ");
            }
            sql.append(this.columns[c].quotedName());
            sql.append(" = ?");
        }
        sql.append(" WHERE " + this.troidColumn.quotedName() + " = ?");
        try {
            return connection.prepareStatement(sql.toString());
        }
        catch (SQLException e) {
            throw new SimplePrepareFailedPoemException(sql.toString(), e);
        }
    }

    @Override
    public void invalidateTransactionStuffs() {
        this.transactionStuffs.invalidate();
    }

    private synchronized TransactionStuff getCommittedTransactionStuff() {
        if (this.committedTransactionStuff == null) {
            this.committedTransactionStuff = new TransactionStuff(this.database.getCommittedConnection());
        }
        return this.committedTransactionStuff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(PreparedStatement select, Persistent p) {
        JdbcPersistent persistent = (JdbcPersistent)p;
        try {
            PreparedStatement preparedStatement = select;
            synchronized (preparedStatement) {
                select.setInt(1, persistent.troid());
                ResultSet rs = select.executeQuery();
                if (this.database.logSQL()) {
                    this.database.log(new SQLLogEvent(select.toString()));
                }
                this.database.incrementQueryCount(select.toString());
                try {
                    if (!rs.next()) {
                        persistent.setStatusNonexistent();
                    } else {
                        persistent.setStatusExistent();
                        for (int c = 0; c < this.columns.length; ++c) {
                            this.columns[c].load_unsafe(rs, c + 1, persistent);
                        }
                    }
                    persistent.setDirty(false);
                    persistent.markValid();
                    if (rs.next()) {
                        throw new DuplicateTroidPoemException(this, persistent.troid());
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        System.err.println("Cannot close resultset after exception.");
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SimpleRetrievalFailedPoemException(e, select.toString());
        }
        catch (ValidationPoemException e) {
            throw new UnexpectedValidationPoemException(e);
        }
    }

    @Override
    public void load(PoemTransaction transaction, Persistent persistent) {
        this.load(transaction == null ? this.getCommittedTransactionStuff().get : ((TransactionStuff)this.transactionStuffs.get((int)transaction.index)).get, persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modify(PoemTransaction transaction, Persistent persistent) {
        PreparedStatement modify;
        PreparedStatement preparedStatement = modify = ((TransactionStuff)this.transactionStuffs.get((int)transaction.index)).modify;
        synchronized (preparedStatement) {
            for (int c = 0; c < this.columns.length; ++c) {
                this.columns[c].save_unsafe(persistent, modify, c + 1);
            }
            try {
                modify.setInt(this.columns.length + 1, persistent.troid());
            }
            catch (SQLException e) {
                throw new SQLSeriousPoemException(e);
            }
            try {
                modify.executeUpdate();
            }
            catch (SQLException e) {
                throw this.dbms().exceptionForUpdate((Table)this, modify, false, e);
            }
            this.database.incrementQueryCount(modify.toString());
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(modify.toString()));
            }
        }
        persistent.postModify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(PoemTransaction transaction, Persistent persistent) {
        PreparedStatement insert;
        PreparedStatement preparedStatement = insert = ((TransactionStuff)this.transactionStuffs.get((int)transaction.index)).insert;
        synchronized (preparedStatement) {
            for (int c = 0; c < this.columns.length; ++c) {
                this.columns[c].save_unsafe(persistent, insert, c + 1);
            }
            try {
                insert.executeUpdate();
            }
            catch (SQLException e) {
                throw this.dbms().exceptionForUpdate((Table)this, insert, true, e);
            }
            this.database.incrementQueryCount(insert.toString());
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(insert.toString()));
            }
        }
        persistent.postInsert();
    }

    @Override
    public void delete(Integer troid, PoemTransaction transaction) {
        String sql = "DELETE FROM " + this.quotedName() + " WHERE " + this.troidColumn.quotedName() + " = " + troid.toString();
        try {
            transaction.writeDown();
            Connection connection = transaction.getConnection();
            Statement deleteStatement = connection.createStatement();
            int deleted = deleteStatement.executeUpdate(sql);
            if (deleted != 1) {
                throw new RowDisappearedPoemException(this, troid);
            }
            deleteStatement.close();
            this.database.incrementQueryCount(sql);
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(sql));
            }
            this.cache.delete(troid);
        }
        catch (SQLException e) {
            throw new ExecutingSQLPoemException(sql, e);
        }
    }

    @Override
    public void writeDown(PoemTransaction transaction, Persistent p) {
        JdbcPersistent persistent = (JdbcPersistent)p;
        if (persistent.isDirty()) {
            this.troidColumn.setRaw_unsafe(persistent, persistent.troid());
            if (persistent.statusExistent()) {
                this.modify(transaction, persistent);
            } else if (persistent.statusNonexistent()) {
                this.insert(transaction, persistent);
                persistent.setStatusExistent();
            }
            persistent.setDirty(false);
            persistent.postWrite();
        }
    }

    @Override
    public void uncache() {
        this.cache.iterate(invalidator);
        this.serial.invalidate();
        TableListener[] listenersLocal = this.listeners;
        for (int l = 0; l < listenersLocal.length; ++l) {
            listenersLocal[l].notifyUncached(this);
        }
    }

    @Override
    public void trimCache(int maxSize) {
        this.cache.trim(maxSize);
    }

    @Override
    public Cache.Info getCacheInfo() {
        return this.cache.getInfo();
    }

    @Override
    public void addListener(TableListener listener) {
        this.listeners = (TableListener[])ArrayUtils.added(this.listeners, listener);
    }

    @Override
    public void notifyTouched(PoemTransaction transaction, Persistent persistent) {
        this.serial.increment(transaction);
        TableListener[] listenersLocal = this.listeners;
        for (int l = 0; l < listenersLocal.length; ++l) {
            listenersLocal[l].notifyTouched(transaction, this, persistent);
        }
    }

    @Override
    public long serial(PoemTransaction transaction) {
        return this.serial.current(transaction);
    }

    @Override
    public void readLock() {
        this.serial(PoemThread.transaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Persistent getObject(Integer troid) throws NoSuchRowPoemException {
        JdbcPersistent persistent = (JdbcPersistent)this.cache.get(troid);
        if (persistent == null) {
            persistent = (JdbcPersistent)this.newPersistent();
            this.claim(persistent, troid);
            this.load(PoemThread.transaction(), (Persistent)persistent);
            if (persistent.statusExistent()) {
                Cache cache = this.cache;
                synchronized (cache) {
                    JdbcPersistent tryAgain = (JdbcPersistent)this.cache.get(troid);
                    if (tryAgain == null) {
                        try {
                            this.cache.put(troid, persistent);
                        }
                        catch (Cache.InconsistencyException e) {
                            throw new PoemBugPoemException("Problem putting persistent " + persistent + " into cache:", e);
                        }
                    } else {
                        persistent = tryAgain;
                    }
                }
            }
        }
        if (!persistent.statusExistent()) {
            throw new NoSuchRowPoemException(this, troid);
        }
        persistent.existenceLock(PoemThread.sessionToken());
        return persistent;
    }

    @Override
    public Persistent getObject(int troid) throws NoSuchRowPoemException {
        return this.getObject(new Integer(troid));
    }

    @Override
    public String selectionSQL(String fromClause, String whereClause, String orderByClause, boolean includeDeleted, boolean excludeUnselectable) {
        return this.selectOrCountSQL(this.troidColumn().fullQuotedName(), fromClause, whereClause, orderByClause, includeDeleted, excludeUnselectable);
    }

    private ResultSet selectionResultSet(String fromClause, String whereClause, String orderByClause, boolean includeDeleted, boolean excludeUnselectable, PoemTransaction transaction) throws SQLPoemException {
        String sql = this.selectionSQL(fromClause, whereClause, orderByClause, includeDeleted, excludeUnselectable);
        try {
            Connection connection;
            if (transaction == null) {
                connection = this.getDatabase().getCommittedConnection();
            } else {
                transaction.writeDown();
                connection = transaction.getConnection();
            }
            Statement selectionStatement = connection.createStatement();
            ResultSet rs = selectionStatement.executeQuery(sql);
            this.database.incrementQueryCount(sql);
            SessionToken token = PoemThread._sessionToken();
            if (token != null) {
                token.toTidy().add(rs);
                token.toTidy().add(selectionStatement);
            }
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(sql));
            }
            return rs;
        }
        catch (SQLException e) {
            throw new ExecutingSQLPoemException(sql, e);
        }
    }

    @Override
    public Enumeration<Integer> troidSelection(String whereClause, String orderByClause, boolean includeDeleted, PoemTransaction transaction) {
        return this.troidsFrom(this.selectionResultSet(null, whereClause, orderByClause, includeDeleted, true, transaction));
    }

    @Override
    public Enumeration<Integer> troidSelection(Persistent criteria, String orderByClause, boolean includeDeleted, boolean excludeUnselectable, PoemTransaction transaction) {
        return this.troidsFrom(this.selectionResultSet(((JdbcPersistent)criteria).fromClause(), this.whereClause(criteria), orderByClause, includeDeleted, excludeUnselectable, transaction));
    }

    private Enumeration<Integer> troidsFrom(ResultSet them) {
        return new ResultSetEnumeration<Integer>(them){

            @Override
            public Integer mapped(ResultSet rs) throws SQLException {
                return new Integer(rs.getInt(1));
            }
        };
    }

    @Override
    public void rememberAllTroids(boolean flag) {
        if (flag) {
            if (this.allTroids == null && this.troidColumn() != null) {
                this.allTroids = new CachedSelection((Table)this, null, null);
            }
        } else {
            this.allTroids = null;
        }
    }

    @Override
    public void setCacheLimit(Integer limit) {
        this.cache.setSize(limit == null ? 100 : limit);
    }

    @Override
    public Enumeration<Integer> troidSelection(String whereClause, String orderByClause, boolean includeDeleted) throws SQLPoemException {
        if (!(this.allTroids == null || whereClause != null && !whereClause.equals("") || orderByClause != null && !orderByClause.equals("") && orderByClause != this.defaultOrderByClause() || includeDeleted)) {
            return this.allTroids.troids();
        }
        return this.troidSelection(whereClause, orderByClause, includeDeleted, PoemThread.inSession() ? PoemThread.transaction() : null);
    }

    @Override
    public Enumeration<Persistent> selection() throws SQLPoemException {
        return this.selection(null, null, false);
    }

    @Override
    public final Enumeration<Persistent> selection(String whereClause) throws SQLPoemException {
        return this.selection(whereClause, null, false);
    }

    @Override
    public Persistent firstSelection(String whereClause) {
        Enumeration<Persistent> them = this.selection(whereClause);
        return them.hasMoreElements() ? them.nextElement() : null;
    }

    @Override
    public Enumeration<Persistent> selection(String whereClause, String orderByClause, boolean includeDeleted) throws SQLPoemException {
        return this.objectsFromTroids(this.troidSelection(whereClause, orderByClause, includeDeleted));
    }

    @Override
    public Enumeration<Persistent> selection(Persistent criteria) throws SQLPoemException {
        return this.selection(criteria, criteria.getTable().defaultOrderByClause(), false, true);
    }

    @Override
    public Enumeration<Persistent> selection(Persistent criteria, String orderByClause) throws SQLPoemException {
        return this.selection(criteria, orderByClause, false, true);
    }

    @Override
    public Enumeration<Persistent> selection(Persistent criteria, String orderByClause, boolean includeDeleted, boolean excludeUnselectable) throws SQLPoemException {
        return this.objectsFromTroids(this.troidSelection(criteria, orderByClause, includeDeleted, excludeUnselectable, null));
    }

    private Enumeration<Persistent> objectsFromTroids(Enumeration<Integer> troids) {
        return new MappedEnumeration<Persistent, Integer>(troids){

            @Override
            public Persistent mapped(Integer troid) {
                return JdbcTable.this.getObject(troid);
            }
        };
    }

    @Override
    public String countSQL(String whereClause) {
        return this.countSQL(null, whereClause, false, true);
    }

    @Override
    public String countSQL(String fromClause, String whereClause, boolean includeDeleted, boolean excludeUnselectable) {
        return this.selectOrCountSQL("count(*)", fromClause, whereClause, "", includeDeleted, excludeUnselectable);
    }

    private String selectOrCountSQL(String selectClause, String fromClause, String whereClause, String orderByClause, boolean includeDeleted, boolean excludeUnselectable) {
        if (fromClause == null) {
            fromClause = this.quotedName();
        }
        String result = "SELECT " + selectClause + " FROM " + fromClause;
        if ((whereClause = this.appendWhereClauseFilters(whereClause, includeDeleted, excludeUnselectable)).length() > 0) {
            result = result + " WHERE " + whereClause;
        }
        if (orderByClause == null) {
            orderByClause = this.defaultOrderByClause();
        }
        if (orderByClause.trim().length() > 0) {
            result = result + " ORDER BY " + orderByClause;
        }
        return result;
    }

    private String appendWhereClauseFilters(String whereClause, boolean includeDeleted, boolean excludeUnselectable) {
        String s;
        whereClause = whereClause == null || whereClause.trim().length() == 0 ? "" : "(" + whereClause + ")";
        if (this.deletedColumn != null && !includeDeleted) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " AND";
            }
            whereClause = whereClause + " NOT " + this.dbms().booleanTrueExpression(this.deletedColumn);
        }
        if (excludeUnselectable && (s = this.canSelectClause()) != null) {
            if (whereClause.length() > 0) {
                whereClause = whereClause + " AND ";
            }
            whereClause = whereClause + s;
        }
        return whereClause;
    }

    private String canSelectClause() {
        AccessToken accessToken;
        Column<Capability> canSelect = this.canSelectColumn();
        AccessToken accessToken2 = accessToken = PoemThread.inSession() ? PoemThread.sessionToken().accessToken : null;
        if (canSelect == null || accessToken instanceof RootAccessToken) {
            return null;
        }
        if (accessToken instanceof User) {
            String query = "(" + canSelect.fullQuotedName() + " IS NULL OR EXISTS( SELECT 1 FROM " + this.quotedName() + ", " + this.database.getGroupCapabilityTable().quotedName() + ", " + this.database.getGroupMembershipTable().quotedName() + " WHERE " + this.database.getGroupMembershipTable().getUserColumn().fullQuotedName() + " = " + ((User)accessToken).getId() + " AND " + this.database.getGroupMembershipTable().getGroupColumn().fullQuotedName() + " = " + this.database.getGroupCapabilityTable().getGroupColumn().fullQuotedName() + " AND " + this.database.getGroupCapabilityTable().getCapabilityColumn().fullQuotedName() + " = " + canSelect.fullQuotedName() + "))";
            return query;
        }
        return canSelect.fullQuotedName() + " IS NULL";
    }

    @Override
    public int count(String whereClause, boolean includeDeleted, boolean excludeUnselectable) throws SQLPoemException {
        return this.count(this.appendWhereClauseFilters(whereClause, includeDeleted, excludeUnselectable));
    }

    @Override
    public int count(String whereClause, boolean includeDeleted) throws SQLPoemException {
        return this.count(whereClause, includeDeleted, true);
    }

    @Override
    public int count(String whereClause) throws SQLPoemException {
        String sql = this.countSQL(whereClause);
        try {
            Connection connection;
            if (PoemThread.inSession()) {
                PoemTransaction transaction = PoemThread.transaction();
                transaction.writeDown();
                connection = transaction.getConnection();
            } else {
                connection = this.getDatabase().getCommittedConnection();
            }
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            this.database.incrementQueryCount(sql);
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent(sql));
            }
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            s.close();
            return count;
        }
        catch (SQLException e) {
            throw new ExecutingSQLPoemException(sql, e);
        }
    }

    @Override
    public int count() throws SQLPoemException {
        return this.count(null);
    }

    @Override
    public boolean exists(String whereClause) throws SQLPoemException {
        return this.count(whereClause) > 0;
    }

    @Override
    public boolean exists(Persistent persistent) {
        return this.exists(this.whereClause(persistent));
    }

    @Override
    public void appendWhereClause(StringBuffer clause, Persistent persistent) {
        Column<?>[] columnsLocal = this.columns;
        boolean hadOne = false;
        for (int c = 0; c < columnsLocal.length; ++c) {
            Column<?> column = columnsLocal[c];
            Object raw = column.getRaw_unsafe(persistent);
            if (raw == null) continue;
            if (hadOne) {
                clause.append(" AND ");
            } else {
                hadOne = true;
            }
            String columnSQL = column.fullQuotedName();
            if (column.getType() instanceof StringPoemType) {
                clause.append(this.dbms().caseInsensitiveRegExpSQL(columnSQL, column.getSQLType().quotedRaw(raw)));
                continue;
            }
            if (column.getType() instanceof BooleanPoemType) {
                clause.append(columnSQL);
                clause.append(" = ");
                clause.append(this.dbms().sqlBooleanValueOfRaw(raw));
                continue;
            }
            clause.append(columnSQL);
            clause.append(" = ");
            clause.append(column.getSQLType().quotedRaw(raw));
        }
    }

    @Override
    public String whereClause(Persistent criteria) {
        return this.whereClause(criteria, true, true);
    }

    @Override
    public String whereClause(Persistent criteria, boolean includeDeleted, boolean excludeUnselectable) {
        StringBuffer clause = new StringBuffer();
        this.appendWhereClause(clause, criteria);
        return this.appendWhereClauseFilters(clause.toString(), includeDeleted, excludeUnselectable);
    }

    public String cnfWhereClause(Enumeration persistents) {
        return this.cnfWhereClause(persistents, false, true);
    }

    public String cnfWhereClause(Enumeration persistents, boolean includeDeleted, boolean excludeUnselectable) {
        StringBuffer clause = new StringBuffer();
        boolean hadOne = false;
        while (persistents.hasMoreElements()) {
            StringBuffer pClause = new StringBuffer();
            this.appendWhereClause(pClause, (Persistent)persistents.nextElement());
            if (pClause.length() <= 0) continue;
            if (hadOne) {
                clause.append(" OR ");
            } else {
                hadOne = true;
            }
            clause.append("(");
            clause.append(pClause);
            clause.append(")");
        }
        return this.appendWhereClauseFilters(clause.toString(), includeDeleted, excludeUnselectable);
    }

    public Enumeration referencesTo(final Persistent object) {
        return new FlattenedEnumeration(new MappedEnumeration(this.columns()){

            public Object mapped(Object column) {
                return ((Column)column).referencesTo(object);
            }
        });
    }

    @Override
    public Enumeration<Column<?>> referencesTo(final Table table) {
        return new FilteredEnumeration<Column<?>>(this.columns()){

            @Override
            public boolean isIncluded(Column<?> column) {
                PoemType<?> type = column.getType();
                return type instanceof ReferencePoemType && ((ReferencePoemType)type).targetTable() == table;
            }
        };
    }

    private void validate(Persistent persistent) throws FieldContentsPoemException {
        for (int c = 0; c < this.columns.length; ++c) {
            Column<?> column = this.columns[c];
            try {
                column.getType().assertValidRaw(column.getRaw_unsafe(persistent));
                continue;
            }
            catch (Exception e) {
                throw new FieldContentsPoemException(column, e);
            }
        }
    }

    @Override
    public int getMostRecentTroid() {
        if (this.mostRecentTroid == -1) {
            throw new PoemBugPoemException("Troid still unitialised in " + this.name);
        }
        return this.mostRecentTroid;
    }

    @Override
    public synchronized Integer troidFor(Persistent persistent) {
        Persistent foolEclipse;
        persistent = foolEclipse = persistent;
        if (this.mostRecentTroid == -1) {
            throw new PoemBugPoemException("Troid still unitialised in " + this.name);
        }
        return new Integer(this.mostRecentTroid++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Persistent p) throws AccessPoemException, ValidationPoemException, InitialisationPoemException {
        JdbcPersistent persistent = (JdbcPersistent)p;
        SessionToken sessionToken = PoemThread.sessionToken();
        if (persistent.getTable() == null) {
            persistent.setTable(this, null);
        }
        persistent.assertCanCreate(sessionToken.accessToken);
        this.claim(persistent, this.troidFor(persistent));
        persistent.setStatusNonexistent();
        try {
            this.validate(persistent);
        }
        catch (Exception e) {
            throw new InitialisationPoemException(this, e);
        }
        Cache cache = this.cache;
        synchronized (cache) {
            persistent.setDirty(true);
            this.writeDown(sessionToken.transaction, persistent);
            persistent.readLock(sessionToken.transaction);
            this.cache.put(persistent.troid(), persistent);
        }
        this.notifyTouched(sessionToken.transaction, persistent);
    }

    @Override
    public Persistent create(Initialiser initialiser) throws AccessPoemException, ValidationPoemException, InitialisationPoemException {
        Persistent persistent = this.newPersistent();
        initialiser.init(persistent);
        this.create(persistent);
        return persistent;
    }

    private void claim(Persistent p, Integer troid) {
        JdbcPersistent persistent = (JdbcPersistent)p;
        if (this.cache.get(troid) != null) {
            throw new DuplicateTroidPoemException(this, troid);
        }
        if (persistent.troid() != null) {
            throw new DoubleCreatePoemException(persistent);
        }
        persistent.setTable(this, troid);
        this.troidColumn.setRaw_unsafe(persistent, troid);
        if (this.deletedColumn != null) {
            this.deletedColumn.setRaw_unsafe(persistent, Boolean.FALSE);
        }
    }

    @Override
    public Persistent newPersistent() {
        JdbcPersistent it = this._newPersistent();
        it.setTable(this, null);
        return it;
    }

    protected JdbcPersistent _newPersistent() {
        return new JdbcPersistent();
    }

    @Override
    public void delete_unsafe(String whereClause) {
        this.serial.increment(PoemThread.transaction());
        this.getDatabase().sqlUpdate("DELETE FROM " + this.quotedName + " WHERE " + whereClause);
        this.uncache();
    }

    @Override
    public int extrasCount() {
        return this.extrasIndex;
    }

    @Override
    public final Capability getDefaultCanRead() {
        return this.info == null ? null : this.info.getDefaultcanread();
    }

    @Override
    public final Capability getDefaultCanWrite() {
        return this.info == null ? null : this.info.getDefaultcanwrite();
    }

    @Override
    public final Capability getDefaultCanDelete() {
        return this.info == null ? null : this.info.getDefaultcandelete();
    }

    @Override
    public final Capability getCanCreate() {
        return this.info == null ? null : this.info.getCancreate();
    }

    @Override
    public final Column<Capability> canReadColumn() {
        return this.canReadColumn == null ? this.canSelectColumn() : this.canReadColumn;
    }

    @Override
    public final Column<Capability> canSelectColumn() {
        return this.canSelectColumn;
    }

    @Override
    public final Column<Capability> canWriteColumn() {
        return this.canWriteColumn;
    }

    @Override
    public final Column<Capability> canDeleteColumn() {
        return this.canDeleteColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Column<?> addColumnAndCommit(ColumnInfo infoP) throws PoemException {
        System.err.println("Adding extra column from runtime " + this.dbms().melatiName(infoP.getName_unsafe()) + " to " + this.name);
        Column column = ExtraColumn.from(this, infoP, this.getNextExtrasIndex(), DefinitionSource.runtime);
        column.setColumnInfo(infoP);
        this.defineColumn(column, false);
        this.database.beginStructuralModification();
        try {
            this.dbAddColumn(column);
            Cache cache = this.cache;
            synchronized (cache) {
                this.uncache();
                this.transactionStuffs.invalidate();
                this.defineColumn(column, true);
            }
            PoemThread.commit();
        }
        finally {
            this.database.endStructuralModification();
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteColumnAndCommit(ColumnInfo columnInfo) throws PoemException {
        this.database.beginStructuralModification();
        try {
            Column<?> column = columnInfo.column();
            columnInfo.delete();
            if (this.database.getDbms().canDropColumns()) {
                this.dbModifyStructure("ALTER TABLE " + this.quotedName() + " DROP " + column.quotedName());
            }
            this.columns = (Column[])ArrayUtils.removed(this.columns, column);
            this.columnsByName.remove(column.getName().toLowerCase());
            Cache cache = this.cache;
            synchronized (cache) {
                this.uncache();
                this.transactionStuffs.invalidate();
            }
            PoemThread.commit();
        }
        finally {
            this.database.endStructuralModification();
        }
    }

    @Override
    public String toString() {
        return this.getName() + " (from " + this.definitionSource + ")";
    }

    @Override
    public void dumpCacheAnalysis() {
        System.err.println("\n-------- Analysis of " + this.name + "'s cache\n");
        this.cache.dumpAnalysis();
    }

    @Override
    public void dump() {
        this.dump(System.out);
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("=== table " + this.name + " (tableinfo id " + this.tableInfoID() + ")");
        for (int c = 0; c < this.columns.length; ++c) {
            this.columns[c].dump(ps);
        }
    }

    public CachedSelection cachedSelection(String whereClause, String orderByClause) {
        String key = whereClause + "/" + orderByClause;
        CachedSelection<Object> them = this.cachedSelections.get(key);
        if (them == null) {
            CachedSelection newThem = new CachedSelection((Table)this, whereClause, orderByClause);
            this.cachedSelections.put(key, newThem);
            them = newThem;
        }
        return them;
    }

    @Override
    public CachedCount cachedCount(String whereClause, boolean includeDeleted) {
        return this.cachedCount(whereClause, includeDeleted, true);
    }

    @Override
    public CachedCount cachedCount(String whereClause, boolean includeDeleted, boolean excludeUnselectable) {
        return this.cachedCount(this.appendWhereClauseFilters(whereClause, includeDeleted, excludeUnselectable));
    }

    @Override
    public CachedCount cachedCount(Persistent criteria, boolean includeDeleted, boolean excludeUnselectable) {
        return this.cachedCount(this.whereClause(criteria, includeDeleted, excludeUnselectable));
    }

    @Override
    public CachedCount cachedCount(Persistent criteria) {
        return this.cachedCount(this.whereClause(criteria, true, false));
    }

    @Override
    public CachedCount cachedCount(String whereClause) {
        String key = "" + whereClause;
        CachedCount it = this.cachedCounts.get(key);
        if (it == null) {
            it = new CachedCount(this, whereClause);
            this.cachedCounts.put(key, it);
        }
        return it;
    }

    @Override
    public CachedExists cachedExists(String whereClause) {
        String key = "" + whereClause;
        CachedExists it = null;
        it = this.cachedExists.get(key);
        if (it == null) {
            it = new CachedExists(this, whereClause);
            this.cachedExists.put(key, it);
        }
        return it;
    }

    public RestrictedReferencePoemType cachedSelectionType(String whereClause, String orderByClause, boolean nullable) {
        return new RestrictedReferencePoemType(this.cachedSelection(whereClause, orderByClause), nullable);
    }

    public Field cachedSelectionField(String whereClause, String orderByClause, boolean nullable, Integer selectedTroid, String nameP) {
        return new Field<Integer>(selectedTroid, new BaseFieldAttributes<Integer>(nameP, this.cachedSelectionType(whereClause, orderByClause, nullable)));
    }

    private synchronized void defineColumn(Column column, boolean reallyDoIt) throws DuplicateColumnNamePoemException, DuplicateTroidColumnPoemException, DuplicateDeletedColumnPoemException {
        PoemType type;
        if (column.getTable() != this) {
            throw new ColumnInUsePoemException(this, column);
        }
        if (this._getColumn(column.getName()) != null) {
            throw new DuplicateColumnNamePoemException(this, column);
        }
        if (column.isTroidColumn()) {
            if (this.troidColumn != null) {
                throw new DuplicateTroidColumnPoemException(this, column);
            }
            if (reallyDoIt) {
                this.troidColumn = column;
            }
        } else if (column.isDeletedColumn()) {
            if (this.deletedColumn != null) {
                throw new DuplicateDeletedColumnPoemException(this, column);
            }
            if (reallyDoIt) {
                this.deletedColumn = column;
            }
        } else if (reallyDoIt && (type = column.getType()) instanceof ReferencePoemType && ((ReferencePoemType)type).targetTable() == this.database.getCapabilityTable()) {
            if (column.getName().equals("canRead")) {
                this.canReadColumn = column;
            } else if (column.getName().equals("canWrite")) {
                this.canWriteColumn = column;
            } else if (column.getName().equals("canDelete")) {
                this.canDeleteColumn = column;
            } else if (column.getName().equals("canSelect")) {
                this.canSelectColumn = column;
            }
        }
        if (reallyDoIt) {
            column.setTable(this);
            this.columns = (Column[])ArrayUtils.added(this.columns, column);
            this.columnsByName.put(column.getName().toLowerCase(), column);
        }
    }

    public final void defineColumn(Column column) throws DuplicateColumnNamePoemException, DuplicateTroidColumnPoemException, DuplicateDeletedColumnPoemException {
        this.defineColumn(column, true);
    }

    private void _defineColumn(Column column) {
        try {
            this.defineColumn(column);
        }
        catch (DuplicateColumnNamePoemException e) {
            throw new UnexpectedExceptionPoemException(e);
        }
        catch (DuplicateTroidColumnPoemException e) {
            throw new UnexpectedExceptionPoemException(e);
        }
    }

    @Override
    public int getNextExtrasIndex() {
        return this.extrasIndex++;
    }

    @Override
    public void setTableInfo(TableInfo tableInfo) {
        this.info = tableInfo;
        this.rememberAllTroids(tableInfo.getSeqcached());
        this.setCacheLimit(tableInfo.getCachelimit());
    }

    @Override
    public TableInfo getTableInfo() {
        return this.info;
    }

    protected String defaultDisplayName() {
        return StringUtils.capitalised(this.getName());
    }

    protected int defaultDisplayOrder() {
        return 100;
    }

    protected String defaultDescription() {
        return null;
    }

    protected Integer defaultCacheLimit() {
        return new Integer(100);
    }

    protected boolean defaultRememberAllTroids() {
        return false;
    }

    protected String defaultCategory() {
        return "Normal";
    }

    @Override
    public void createTableInfo() throws PoemException {
        if (this.info == null) {
            this.info = this.getDatabase().getTableInfoTable().defaultTableInfoFor(this);
            try {
                this.getDatabase().getTableInfoTable().create(this.info);
            }
            catch (PoemException e) {
                throw new UnificationPoemException("Problem creating new tableInfo for table " + this.getName() + ":", e);
            }
            this.setTableInfo(this.info);
        }
    }

    @Override
    public synchronized void unifyWithColumnInfo() throws PoemException {
        if (this.info == null) {
            throw new PoemBugPoemException("Get the initialisation order right ...");
        }
        Enumeration<Persistent> ci = this.database.getColumnInfoTable().getTableinfoColumn().selectionWhereEq(this.info.troid());
        while (ci.hasMoreElements()) {
            ColumnInfo columnInfo = (ColumnInfo)ci.nextElement();
            Column column = this._getColumn(columnInfo.getName());
            if (column == null) {
                System.err.println("Adding extra column from info tables " + this.dbms().melatiName(columnInfo.getName_unsafe()));
                column = ExtraColumn.from(this, columnInfo, this.getNextExtrasIndex(), DefinitionSource.infoTables);
                this._defineColumn(column);
            }
            column.setColumnInfo(columnInfo);
        }
        Enumeration<Column<?>> c = this.columns();
        while (c.hasMoreElements()) {
            c.nextElement().createColumnInfo();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized void unifyWithDB(ResultSet colDescs, String troidColumnName) throws PoemException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void init() {
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object t) {
        return t instanceof JdbcTable && ((Table)t).getName().equals(this.name);
    }

    private class TransactionStuff {
        PreparedStatement insert;
        PreparedStatement modify;
        PreparedStatement get;

        TransactionStuff(Connection connection) {
            this.insert = JdbcTable.this._this.simpleInsert(connection);
            this.modify = JdbcTable.this._this.simpleModify(connection);
            this.get = JdbcTable.this._this.simpleGet(connection);
        }
    }
}

