/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.util;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.melati.poem.util.EnumUtils;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T[] arrayOf(Vector<T> v) {
        Object[] arr;
        Vector<T> vector = v;
        synchronized (vector) {
            arr = new Object[v.size()];
            v.copyInto(arr);
        }
        return arr;
    }

    public static Object[] arrayOf(Enumeration<Object> e) {
        Vector<Object> v = EnumUtils.vectorOf(e);
        return ArrayUtils.arrayOf(v);
    }

    public static Object[] added(Object[] xs, Object y) {
        Object[] xsx = (Object[])Array.newInstance(xs.getClass().getComponentType(), xs.length + 1);
        System.arraycopy(xs, 0, xsx, 0, xs.length);
        xsx[xs.length] = y;
        return xsx;
    }

    public static Object[] removed(Object[] xs, Object y) {
        Object[] xsx = (Object[])Array.newInstance(xs.getClass().getComponentType(), xs.length - 1);
        int j = 0;
        for (int i = 0; i < xs.length; ++i) {
            if (xs[i] == y) continue;
            xsx[j] = xs[i];
            ++j;
        }
        return xsx;
    }

    public static Object[] concatenated(Object[] xs, Object[] ys) {
        Object[] xsys = (Object[])Array.newInstance(xs.getClass().getComponentType(), xs.length + ys.length);
        System.arraycopy(xs, 0, xsys, 0, xs.length);
        System.arraycopy(ys, 0, xsys, xs.length, ys.length);
        return xsys;
    }

    public static Object[] section(Object[] xs, int start, int limit) {
        Object[] xs_ = (Object[])Array.newInstance(xs.getClass().getComponentType(), limit - start);
        System.arraycopy(xs, start, xs_, 0, xs_.length);
        return xs_;
    }

    public static int indexOf(Object[] xs, Object x) {
        for (int i = 0; i < xs.length; ++i) {
            if (!xs[i].equals(x)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object[] xs, Object x) {
        return ArrayUtils.indexOf(xs, x) != -1;
    }
}

