/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.DoublePoemType;
import org.melati.poem.FixedPointAtomPoemType;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.dbms.Dbms;

public class BigDecimalPoemType
extends FixedPointAtomPoemType<BigDecimal> {
    public BigDecimalPoemType(boolean nullable) {
        super(3, "DECIMAL", nullable, 22, 2);
    }

    public BigDecimalPoemType(boolean nullable, int precision, int scale) {
        super(3, "DECIMAL", nullable, precision, scale);
    }

    @Override
    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof BigDecimal)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _getRaw(ResultSet rs, int col) throws SQLException {
        ResultSet resultSet = rs;
        synchronized (resultSet) {
            BigDecimal x = rs.getBigDecimal(col);
            return rs.wasNull() ? null : x;
        }
    }

    @Override
    protected void _setRaw(PreparedStatement ps, int col, Object real) throws SQLException {
        ps.setBigDecimal(col, (BigDecimal)real);
    }

    @Override
    protected BigDecimal _rawOfString(String rawString) throws ParsingPoemException {
        try {
            return new BigDecimal(rawString);
        }
        catch (NumberFormatException e) {
            throw new ParsingPoemException(this, rawString, e);
        }
    }

    @Override
    protected String _sqlDefinition(Dbms dbms) {
        try {
            return dbms.getFixedPtSqlDefinition(this.getScale(), this.getPrecision());
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e);
        }
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return other instanceof BigDecimalPoemType || other instanceof DoublePoemType;
    }

    @Override
    public String toDsdType() {
        return "BigDecimal";
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.BIGDECIMAL);
        columnInfo.setPrecision(this.getPrecision());
        columnInfo.setScale(this.getScale());
    }
}

