/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.generated;

import org.melati.poem.AccessPoemException;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.Group;
import org.melati.poem.GroupMembership;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabaseTables;
import org.melati.poem.PoemException;
import org.melati.poem.PoemTable;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.Table;
import org.melati.poem.TroidPoemType;
import org.melati.poem.User;
import org.melati.poem.ValidationPoemException;

public class GroupMembershipTableBase
extends PoemTable {
    private Column<Integer> col_id = null;
    private Column<Integer> col_user = null;
    private Column<Integer> col_group = null;

    public GroupMembershipTableBase(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public PoemDatabaseTables getPoemDatabaseTables() {
        return (PoemDatabaseTables)((Object)this.getDatabase());
    }

    @Override
    public void init() throws PoemException {
        super.init();
        this.col_id = new Column<Integer>((Table)this, "id", (SQLPoemType)new TroidPoemType(), DefinitionSource.dsd){

            @Override
            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((GroupMembership)g).getId();
            }

            @Override
            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((GroupMembership)g).setId((Integer)cooked);
            }

            @Override
            public Field<Integer> asField(Persistent g) {
                return ((GroupMembership)g).getIdField();
            }

            @Override
            protected boolean defaultUserEditable() {
                return false;
            }

            @Override
            protected boolean defaultUserCreateable() {
                return false;
            }

            @Override
            protected DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.detail;
            }

            @Override
            protected int defaultDisplayOrder() {
                return 0;
            }

            @Override
            protected String defaultDescription() {
                return "The Table Row Object ID";
            }

            @Override
            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((GroupMembership)g).getId_unsafe();
            }

            @Override
            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((GroupMembership)g).setId_unsafe((Integer)raw);
            }

            @Override
            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((GroupMembership)g).getId();
            }

            @Override
            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((GroupMembership)g).setId((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_id);
        this.col_user = new Column<Integer>((Table)this, "user", (SQLPoemType)new ReferencePoemType(this.getPoemDatabaseTables().getUserTable(), false), DefinitionSource.dsd){

            @Override
            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((GroupMembership)g).getUser();
            }

            @Override
            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((GroupMembership)g).setUser((User)cooked);
            }

            @Override
            public Field<Integer> asField(Persistent g) {
                return ((GroupMembership)g).getUserField();
            }

            @Override
            protected Searchability defaultSearchability() {
                return Searchability.yes;
            }

            @Override
            protected Integer defaultDisplayOrderPriority() {
                return new Integer(0);
            }

            @Override
            protected String defaultDisplayName() {
                return "User";
            }

            @Override
            protected int defaultDisplayOrder() {
                return 1;
            }

            @Override
            protected String defaultDescription() {
                return "The user who belongs to the group";
            }

            @Override
            protected boolean defaultIndexed() {
                return true;
            }

            @Override
            protected String defaultRenderinfo() {
                return "SelectionWindow";
            }

            @Override
            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((GroupMembership)g).getUser_unsafe();
            }

            @Override
            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((GroupMembership)g).setUser_unsafe((Integer)raw);
            }

            @Override
            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((GroupMembership)g).getUserTroid();
            }

            @Override
            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((GroupMembership)g).setUserTroid((Integer)raw);
            }

            @Override
            public StandardIntegrityFix defaultIntegrityFix() {
                return StandardIntegrityFix.delete;
            }
        };
        this.defineColumn((Column)this.col_user);
        this.col_group = new Column<Integer>((Table)this, "group", (SQLPoemType)new ReferencePoemType(this.getPoemDatabaseTables().getGroupTable(), false), DefinitionSource.dsd){

            @Override
            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((GroupMembership)g).getGroup();
            }

            @Override
            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((GroupMembership)g).setGroup((Group)cooked);
            }

            @Override
            public Field<Integer> asField(Persistent g) {
                return ((GroupMembership)g).getGroupField();
            }

            @Override
            protected Searchability defaultSearchability() {
                return Searchability.primary;
            }

            @Override
            protected Integer defaultDisplayOrderPriority() {
                return new Integer(1);
            }

            @Override
            protected String defaultDisplayName() {
                return "Group";
            }

            @Override
            protected int defaultDisplayOrder() {
                return 2;
            }

            @Override
            protected String defaultDescription() {
                return "The group to which the user belongs";
            }

            @Override
            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((GroupMembership)g).getGroup_unsafe();
            }

            @Override
            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((GroupMembership)g).setGroup_unsafe((Integer)raw);
            }

            @Override
            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((GroupMembership)g).getGroupTroid();
            }

            @Override
            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((GroupMembership)g).setGroupTroid((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_group);
    }

    public final Column<Integer> getIdColumn() {
        return this.col_id;
    }

    public final Column<Integer> getUserColumn() {
        return this.col_user;
    }

    public final Column<Integer> getGroupColumn() {
        return this.col_group;
    }

    public GroupMembership getGroupMembershipObject(Integer troid) {
        return (GroupMembership)this.getObject(troid);
    }

    public GroupMembership getGroupMembershipObject(int troid) {
        return (GroupMembership)this.getObject(troid);
    }

    @Override
    protected JdbcPersistent _newPersistent() {
        return new GroupMembership();
    }

    @Override
    protected String defaultDisplayName() {
        return "Group membership";
    }

    @Override
    protected String defaultDescription() {
        return "A record that a given User is a member of a given Group";
    }

    @Override
    protected String defaultCategory() {
        return "User";
    }

    @Override
    protected int defaultDisplayOrder() {
        return 2040;
    }
}

