/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import org.melati.poem.AccessPoemException;
import org.melati.poem.Column;
import org.melati.poem.ColumnInfo;
import org.melati.poem.DefinitionSource;
import org.melati.poem.Field;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Table;
import org.melati.poem.ValidationPoemException;

public class ExtraColumn<T>
extends Column<T> {
    private final int extrasIndex;

    public ExtraColumn(Table table, String name, SQLPoemType<T> type, DefinitionSource definitionSource, int extrasIndex) {
        super(table, name, type, definitionSource);
        this.extrasIndex = extrasIndex;
    }

    @Override
    public T getRaw(Persistent g) throws AccessPoemException {
        ((JdbcPersistent)g).readLock();
        return this.getRaw_unsafe(g);
    }

    @Override
    public T getRaw_unsafe(Persistent g) {
        return (T)((JdbcPersistent)g).extras()[this.extrasIndex];
    }

    @Override
    public void setRaw(Persistent g, Object raw) throws AccessPoemException, ValidationPoemException {
        this.getType().assertValidRaw(raw);
        ((JdbcPersistent)g).writeLock();
        this.setRaw_unsafe(g, raw);
    }

    @Override
    public void setRaw_unsafe(Persistent g, Object raw) {
        ((JdbcPersistent)g).extras()[this.extrasIndex] = raw;
    }

    @Override
    public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
        return this.getType().cookedOfRaw(this.getRaw(g));
    }

    @Override
    public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
        this.getType().assertValidCooked(cooked);
        this.setRaw(g, this.getType().rawOfCooked(cooked));
    }

    @Override
    public Field<T> asField(Persistent g) {
        try {
            return new Field(this.getRaw(g), this);
        }
        catch (AccessPoemException accessException) {
            return new Field(accessException, this);
        }
    }

    public static <O> Column<O> from(Table table, ColumnInfo columnInfo, int extrasIndex, DefinitionSource source) {
        return new ExtraColumn(table, columnInfo.getName(), columnInfo.getType(), source, extrasIndex);
    }
}

