/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.Database;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTransaction;
import org.melati.poem.PreparedSQLSeriousPoemException;
import org.melati.poem.SQLLogEvent;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SessionToken;
import org.melati.poem.util.CachedIndexFactory;

public class PreparedStatementFactory
extends CachedIndexFactory {
    private Database database;
    private long structureSerial;
    private String sql;

    public PreparedStatementFactory(Database database, String sql) {
        this.database = database;
        this.structureSerial = database.structureSerial();
        this.sql = sql;
    }

    @Override
    protected Object reallyGet(int index) {
        try {
            Connection c = index == 0 ? this.database.getCommittedConnection() : this.database.poemTransaction(index - 1).getConnection();
            return c.prepareStatement(this.sql);
        }
        catch (SQLException e) {
            throw new SQLPoemException(e);
        }
    }

    @Override
    public Object get(int index) {
        if (this.structureSerial != this.database.structureSerial()) {
            this.invalidate();
            this.structureSerial = this.database.structureSerial();
        }
        return super.get(index);
    }

    public PreparedStatement preparedStatement(PoemTransaction transaction) {
        return (PreparedStatement)this.get(transaction == null ? 0 : transaction.index + 1);
    }

    public final PreparedStatement preparedStatement() {
        return this.preparedStatement(PoemThread.transaction());
    }

    protected ResultSet resultSet(SessionToken token, PreparedStatement statement) {
        try {
            if (this.database.logSQL()) {
                this.database.log(new SQLLogEvent("PS about to:" + statement.toString() + "(" + this.sql + ")"));
            }
            token.transaction.writeDown();
            ResultSet rs = null;
            rs = statement.executeQuery();
            token.toTidy().add(rs);
            this.database.incrementQueryCount(statement.toString());
            return rs;
        }
        catch (SQLException e) {
            throw new PreparedSQLSeriousPoemException(statement, e);
        }
    }

    protected final ResultSet resultSet(SessionToken token) {
        return this.resultSet(token, this.preparedStatement(token.transaction));
    }

    public final ResultSet resultSet() {
        return this.resultSet(PoemThread.sessionToken());
    }

    public String toString() {
        return super.toString() + " (SQL: " + this.sql + ")";
    }
}

