/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import org.melati.poem.BooleanPoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.dbms.AnsiStandard;

public class Mimer
extends AnsiStandard {
    public static final int mimerTextHack = 2500;

    public Mimer() {
        this.setDriverClassName("com.mimer.jdbc.Driver");
    }

    @Override
    public String getStringSqlDefinition(int size) {
        if (size < 0) {
            return "VARCHAR(2500)";
        }
        return "VARCHAR(" + size + ")";
    }

    @Override
    public <S, O> PoemType<O> canRepresent(PoemType<S> storage, PoemType<O> type) {
        if (storage instanceof StringPoemType && type instanceof StringPoemType) {
            if (((StringPoemType)storage).getSize() == 2500 && ((StringPoemType)type).getSize() == -1 && (storage.getNullable() || !type.getNullable())) {
                return type;
            }
            return storage.canRepresent(type);
        }
        if (storage instanceof IntegerPoemType && type instanceof BooleanPoemType && (storage.getNullable() || !type.getNullable())) {
            return type;
        }
        return storage.canRepresent(type);
    }

    @Override
    public String getSqlDefinition(String sqlTypeName) {
        if (sqlTypeName.equals("BOOLEAN")) {
            return "INT";
        }
        return super.getSqlDefinition(sqlTypeName);
    }
}

