/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.util.Enumeration;
import org.melati.poem.AccessToken;
import org.melati.poem.CachedCount;
import org.melati.poem.Capability;
import org.melati.poem.DeletionIntegrityPoemException;
import org.melati.poem.Field;
import org.melati.poem.Group;
import org.melati.poem.GroupCapability;
import org.melati.poem.GroupMembership;
import org.melati.poem.NonRootSetAccessTokenPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemThread;
import org.melati.poem.ReadPersistentAccessPoemException;
import org.melati.poem.User;
import org.melati.poem.test.EverythingDatabase;
import org.melati.poem.test.PersistentTest;
import org.melati.poem.test.Protected;
import org.melati.poem.util.StringUtils;

public class ProtectedPersistentTest
extends PersistentTest {
    public ProtectedPersistentTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void databaseUnchanged() {
        this.deleteUser("moneypenny");
        this.deleteUser("smiley");
        this.deleteUser("bond");
        this.deleteGroup("officeWorkers");
        this.deleteGroup("spyMasters");
        this.deleteCapability("monitor");
        this.deleteCapability("commission");
        this.getDb().getUserTable().getTableInfo().setDefaultcanread(null);
        super.databaseUnchanged();
    }

    private void deleteCapability(String name) {
        Capability c = (Capability)this.getDb().getCapabilityTable().getNameColumn().firstWhereEq((Object)name);
        if (c != null) {
            System.err.println("Cleaning up: " + c);
            c.delete();
        } else {
            System.err.println("Nothing to clean up");
        }
    }

    private void deleteUser(String name) {
        User u = (User)this.getDb().getUserTable().getLoginColumn().firstWhereEq((Object)name);
        if (u != null) {
            System.err.println("Cleaning up: " + u);
            u.delete();
        } else {
            System.err.println("Nothing to clean up");
        }
    }

    private void deleteGroup(String group) {
        Group g = (Group)this.getDb().getGroupTable().getNameColumn().firstWhereEq((Object)group);
        if (g != null) {
            System.err.println("Cleaning up: " + g);
            Enumeration gcs = this.getDb().getGroupCapabilityTable().getGroupColumn().selectionWhereEq((Object)g.getTroid());
            while (gcs.hasMoreElements()) {
                GroupCapability gc = (GroupCapability)gcs.nextElement();
                System.err.println("Cleaning up: " + gc);
                gc.delete();
            }
            Enumeration gms = this.getDb().getGroupMembershipTable().getGroupColumn().selectionWhereEq((Object)g.getTroid());
            while (gms.hasMoreElements()) {
                GroupMembership gm = (GroupMembership)gms.nextElement();
                System.err.println("Cleaning up: " + gm);
                gm.delete();
            }
            try {
                g.delete();
            }
            catch (DeletionIntegrityPoemException e) {
                Enumeration refs = e.references;
                while (refs.hasMoreElements()) {
                    Object o = refs.nextElement();
                    System.err.println("Failed to delete " + g + " due to " + o);
                }
            }
        }
    }

    @Override
    public void testDelete() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        super.testDelete();
    }

    @Override
    public void testDeleteAndCommit() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        super.testDeleteAndCommit();
    }

    public void testAssertCanReadAccessToken() {
        User admin = this.getDb().getUserTable().administratorUser();
        User guest = this.getDb().getUserTable().guestUser();
        if (admin.getTable().getTableInfo().getDefaultcanread() == null) {
            admin.assertCanRead((AccessToken)guest);
        }
        admin.getTable().getTableInfo().setDefaultcanread(this.getDb().getCanAdminister());
        try {
            admin.assertCanRead((AccessToken)guest);
            System.err.println("WTF:" + guest.givesCapability(this.getDb().administerCapability()));
            ProtectedPersistentTest.fail((String)"Should have bombed");
        }
        catch (ReadPersistentAccessPoemException e2) {
            Object e2 = null;
        }
        User a = this.getDb().getUserTable().administratorUser();
        admin.assertCanRead((AccessToken)a);
        admin.getTable().getTableInfo().setDefaultcanread(null);
    }

    public void testAssertCanRead() {
        User p = this.getDb().getUserTable().administratorUser();
        p.assertCanRead();
        p.getTable().getTableInfo().setDefaultcanread(this.getDb().getCanAdminister());
        User g = this.getDb().getUserTable().guestUser();
        PoemThread.setAccessToken((AccessToken)g);
        try {
            p.assertCanRead();
            ProtectedPersistentTest.fail((String)"Should have bombed");
        }
        catch (ReadPersistentAccessPoemException e2) {
            Object e2 = null;
        }
        User a = this.getDb().getUserTable().administratorUser();
        try {
            PoemThread.setAccessToken((AccessToken)a);
            ProtectedPersistentTest.fail((String)"Should have bombed");
        }
        catch (NonRootSetAccessTokenPoemException e3) {
            Object e3 = null;
        }
    }

    public void testGetReadable() {
        User p = this.getDb().getUserTable().administratorUser();
        ProtectedPersistentTest.assertTrue((boolean)p.getReadable());
        p.getTable().getTableInfo().setDefaultcanread(this.getDb().getCanAdminister());
        User g = this.getDb().getUserTable().guestUser();
        PoemThread.setAccessToken((AccessToken)g);
        ProtectedPersistentTest.assertFalse((boolean)p.getReadable());
    }

    @Override
    public void testGetPrimaryDisplayField() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        Field f = p.getPrimaryDisplayField();
        ProtectedPersistentTest.assertEquals((String)"id: 0", (String)f.toString());
    }

    public void testCachedCountStringBooleanBoolean() {
        EverythingDatabase db = (EverythingDatabase)this.getDb();
        Capability commission = db.getCapabilityTable().ensure("commission");
        Capability monitor = db.getCapabilityTable().ensure("monitor");
        User spy = this.ensureUser("bond");
        User smiley = this.ensureUser("smiley");
        User moneypenny = this.ensureUser("moneypenny");
        Protected spyMission = (Protected)db.getProtectedTable().newPersistent();
        spyMission.setCanRead(monitor);
        spyMission.setCanSelect(monitor);
        spyMission.setCanWrite(monitor);
        spyMission.setCanDelete(commission);
        spyMission.setSpy(spy);
        spyMission.setMission("impossible");
        spyMission.setDeleted(false);
        spyMission.makePersistent();
        Group officeWorkers = db.getGroupTable().ensure("officeWorkers");
        GroupMembership inOfficeWorkersMoneyPenny = (GroupMembership)db.getGroupMembershipTable().newPersistent();
        inOfficeWorkersMoneyPenny.setGroup(officeWorkers);
        inOfficeWorkersMoneyPenny.setUser(moneypenny);
        inOfficeWorkersMoneyPenny.makePersistent();
        Group spyMasters = db.getGroupTable().ensure("spyMasters");
        GroupMembership inSpyMastersSmiley = (GroupMembership)db.getGroupMembershipTable().newPersistent();
        inSpyMastersSmiley.setGroup(spyMasters);
        inSpyMastersSmiley.setUser(smiley);
        inSpyMastersSmiley.makePersistent();
        db.getGroupCapabilityTable().ensure(spyMasters, commission);
        db.getGroupCapabilityTable().ensure(spyMasters, monitor);
        PoemThread.setAccessToken((AccessToken)smiley);
        spyMission.assertCanRead();
        String query = db.getProtectedTable().getMissionColumn().fullQuotedName() + "='impossible'";
        CachedCount cached = db.getProtectedTable().cachedCount(query, false, true);
        ProtectedPersistentTest.assertEquals((int)1, (int)cached.count());
        spyMission.delete();
    }

    private User ensureUser(String name) {
        User u = (User)((EverythingDatabase)this.getDb()).getUserTable().newPersistent();
        u.setLogin(name);
        u.setName(StringUtils.capitalised((String)name));
        u.setPassword(name);
        u.makePersistent();
        return u;
    }
}

