/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import org.melati.poem.AccessToken;
import org.melati.poem.Column;
import org.melati.poem.Group;
import org.melati.poem.GroupMembership;
import org.melati.poem.Persistent;
import org.melati.poem.PoemThread;
import org.melati.poem.ReadPasswordAccessPoemException;
import org.melati.poem.RowDisappearedPoemException;
import org.melati.poem.User;
import org.melati.poem.WriteFieldAccessPoemException;
import org.melati.poem.WritePersistentAccessPoemException;
import org.melati.poem.test.PoemTestCase;

public class UserTest
extends PoemTestCase {
    public UserTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void databaseUnchanged() {
        Column c = this.getDb().getUserTable().getNameColumn();
        User tester = (User)c.firstWhereEq((Object)"tester");
        if (tester != null) {
            tester.delete();
        }
        super.databaseUnchanged();
    }

    public void testToString() {
    }

    public void testGetPassword() {
        if (this.getDb().getDbms().toString().equals("org.melati.poem.dbms.Hsqldb")) {
            UserTest.assertEquals((String)"guest", (String)this.getDb().guestUser().getPassword());
            User tester = (User)this.getDb().getUserTable().newPersistent();
            tester.setName("tester");
            tester.setLogin("tester");
            tester.setPassword("pwd");
            tester.makePersistent();
            UserTest.assertEquals((String)"pwd", (String)tester.getPassword());
            PoemThread.setAccessToken((AccessToken)this.getDb().guestUser());
            UserTest.assertEquals((String)"guest", (String)this.getDb().guestUser().getPassword());
            try {
                UserTest.assertEquals((String)"pwd", (String)tester.getPassword());
                UserTest.fail((String)"should have blown up");
            }
            catch (ReadPasswordAccessPoemException e) {
                Object var2_3 = null;
            }
            UserTest.assertFalse((boolean)tester.isGuest());
            UserTest.assertFalse((boolean)tester.isAdministrator());
        }
    }

    public void testSetPassword() {
        if (this.getDb().getDbms().toString().equals("org.melati.poem.dbms.Hsqldb")) {
            UserTest.assertEquals((String)"guest", (String)this.getDb().guestUser().getPassword());
            this.getDb().guestUser().setPassword("fred");
            UserTest.assertEquals((String)"fred", (String)this.getDb().guestUser().getPassword());
            this.getDb().guestUser().setPassword("guest");
            UserTest.assertEquals((String)"guest", (String)this.getDb().guestUser().getPassword());
            User tester = (User)this.getDb().getUserTable().newPersistent();
            tester.setName("tester");
            tester.setLogin("tester");
            tester.setPassword("pwd");
            tester.makePersistent();
            UserTest.assertEquals((String)"pwd", (String)tester.getPassword());
            PoemThread.setAccessToken((AccessToken)tester);
            UserTest.assertEquals((String)"pwd", (String)tester.getPassword());
            try {
                tester.setPassword("new");
                UserTest.fail((String)"should have blown up");
            }
            catch (WritePersistentAccessPoemException e) {
                Object var2_3 = null;
            }
        }
    }

    public void testSetPassword2() {
        if (this.getDb().getDbms().toString().equals("org.melati.poem.dbms.Hsqldb")) {
            User tester = (User)this.getDb().getUserTable().newPersistent();
            tester.setName("tester");
            tester.setLogin("tester");
            tester.setPassword("pwd");
            tester.makePersistent();
            UserTest.assertEquals((String)"pwd", (String)tester.getPassword());
            PoemThread.setAccessToken((AccessToken)this.getDb().guestAccessToken());
            try {
                tester.setPassword("new");
                UserTest.fail((String)"should have blown up");
            }
            catch (WriteFieldAccessPoemException e) {
                Object var2_3 = null;
            }
        }
    }

    public void testUser() {
    }

    public void testUserStringStringString() {
        User u = new User("tester", "tester", "tester");
        this.getDb().getUserTable().create((Persistent)u);
        UserTest.assertEquals((String)"tester", (String)u.getName());
        u.setName("tester2");
        this.getDb().setLogSQL(true);
        PoemThread.commit();
        u.delete();
        this.getDb().setLogSQL(false);
    }

    public void testGivesCapability() {
    }

    public void testIsGuest() {
        UserTest.assertTrue((boolean)this.getDb().guestUser().isGuest());
        UserTest.assertFalse((boolean)this.getDb().administratorUser().isGuest());
    }

    public void testIsAdministrator() {
        UserTest.assertFalse((boolean)this.getDb().guestUser().isAdministrator());
        UserTest.assertTrue((boolean)this.getDb().administratorUser().isAdministrator());
    }

    public void testIntegrityFixDelete() {
        User u = new User("tester", "tester", "tester");
        this.getDb().getUserTable().create((Persistent)u);
        UserTest.assertEquals((String)"tester", (String)u.getName());
        Group g = this.getDb().getGroupTable().administratorsGroup();
        GroupMembership gm = (GroupMembership)this.getDb().getGroupMembershipTable().newPersistent();
        gm.setGroup(g);
        gm.setUser(u);
        gm.makePersistent();
        u.delete();
        try {
            gm.delete();
            UserTest.fail((String)"Should have blown up.");
        }
        catch (RowDisappearedPoemException e2) {
            Object e2 = null;
        }
    }
}

