/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.ColumnTypePoemType;
import org.melati.poem.Database;
import org.melati.poem.DatePoemType;
import org.melati.poem.DeletedPoemType;
import org.melati.poem.DisplayLevelPoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.IntegrityFixPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PasswordPoemType;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SearchabilityPoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TimePoemType;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.TroidPoemType;

public abstract class PoemTypeFactory {
    final Integer code;
    public static final PoemTypeFactory TROID;
    public static final PoemTypeFactory DELETED;
    public static final PoemTypeFactory TYPE;
    public static final PoemTypeFactory BOOLEAN;
    public static final PoemTypeFactory INTEGER;
    public static final PoemTypeFactory DOUBLE;
    public static final PoemTypeFactory LONG;
    public static final PoemTypeFactory BIGDECIMAL;
    public static final PoemTypeFactory STRING;
    public static final PoemTypeFactory PASSWORD;
    public static final PoemTypeFactory DATE;
    public static final PoemTypeFactory TIMESTAMP;
    public static final PoemTypeFactory BINARY;
    public static final PoemTypeFactory DISPLAYLEVEL;
    public static final PoemTypeFactory SEARCHABILITY;
    public static final PoemTypeFactory INTEGRITYFIX;
    public static final PoemTypeFactory TIME;
    private static int n;
    static final PoemTypeFactory[] atomTypeFactories;

    public PoemTypeFactory(int c) {
        this.code = new Integer(c);
    }

    abstract <T> SQLPoemType<T> typeOf(Database var1, Parameter var2);

    public Integer getCode() {
        return this.code;
    }

    public abstract String getName();

    public String getDisplayName() {
        return this.getName();
    }

    public abstract String getDescription();

    public static PoemTypeFactory forCode(Database database, int code) {
        if (code < 0) {
            return atomTypeFactories[-code - 1];
        }
        final Table table = database.tableWithTableInfoID(code);
        return new PoemTypeFactory(code){

            public SQLPoemType typeOf(Database db, Parameter info) {
                return new ReferencePoemType(table, info.getNullable());
            }

            @Override
            public String getName() {
                return table.getName();
            }

            @Override
            public String getDisplayName() {
                return table.getDisplayName();
            }

            @Override
            public String getDescription() {
                return table.getDescription();
            }
        };
    }

    static {
        n = -1;
        atomTypeFactories = new PoemTypeFactory[]{TROID = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return TroidPoemType.it;
            }

            @Override
            public String getName() {
                return "TROID";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, DELETED = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return DeletedPoemType.it;
            }

            @Override
            public String getName() {
                return "DELETED";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, TYPE = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new ColumnTypePoemType(database);
            }

            @Override
            public String getName() {
                return "TYPE";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, BOOLEAN = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new BooleanPoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "BOOLEAN";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, INTEGER = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new IntegerPoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "INTEGER";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, DOUBLE = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new DoublePoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "DOUBLE";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, STRING = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new StringPoemType(info.getNullable(), info.getSize());
            }

            @Override
            public String getName() {
                return "STRING";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, DATE = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new DatePoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "DATE";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, PASSWORD = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new PasswordPoemType(info.getNullable(), info.getSize());
            }

            @Override
            public String getName() {
                return "PASSWORD";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, TIMESTAMP = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new TimestampPoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "TIMESTAMP";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, DISPLAYLEVEL = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new DisplayLevelPoemType();
            }

            @Override
            public String getName() {
                return "DISPLAYLEVEL";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, SEARCHABILITY = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new SearchabilityPoemType();
            }

            @Override
            public String getName() {
                return "SEARCHABILITY";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, BINARY = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new BinaryPoemType(info.getNullable(), info.getSize());
            }

            @Override
            public String getName() {
                return "BINARY";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, LONG = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new LongPoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "LONG";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, INTEGRITYFIX = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new IntegrityFixPoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "INTEGRITYFIX";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, BIGDECIMAL = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new BigDecimalPoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "BIGDECIMAL";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }, TIME = new PoemTypeFactory(n--){

            public SQLPoemType typeOf(Database database, Parameter info) {
                return new TimePoemType(info.getNullable());
            }

            @Override
            public String getName() {
                return "TIME";
            }

            @Override
            public String getDescription() {
                return "...";
            }
        }};
    }

    public static interface Parameter {
        public boolean getNullable();

        public int getSize();
    }
}

