/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.DatePoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.dbms.test.DbmsSpec;

public class MySQLTest
extends DbmsSpec {
    public MySQLTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void setObjectUnderTest() {
        this.it = DbmsFactory.getDbms((String)"org.melati.poem.dbms.MySQL");
    }

    @Override
    public void testCreateTableOptionsSql() {
        MySQLTest.assertEquals((String)" TYPE='InnoDB' ", (String)this.it.createTableOptionsSql());
    }

    @Override
    public void testGetStringSqlDefinition() throws Exception {
        MySQLTest.assertEquals((String)"VARCHAR(0)", (String)this.it.getStringSqlDefinition(0));
        MySQLTest.assertEquals((String)"text", (String)this.it.getStringSqlDefinition(-1));
    }

    @Override
    public void testGetSqlDefinition() throws Exception {
        MySQLTest.assertEquals((String)"bool", (String)this.it.getSqlDefinition("BOOLEAN"));
        MySQLTest.assertEquals((String)"DOUBLE PRECISION", (String)this.it.getSqlDefinition("DOUBLE PRECISION"));
        MySQLTest.assertEquals((String)"INT8", (String)this.it.getSqlDefinition("INT8"));
        MySQLTest.assertEquals((String)"Big Decimal", (String)this.it.getSqlDefinition("Big Decimal"));
    }

    @Override
    public void testGetBinarySqlDefinition() throws Exception {
        MySQLTest.assertEquals((String)"BLOB", (String)this.it.getBinarySqlDefinition(0));
    }

    @Override
    public void testGetIndexLength() throws Exception {
        MySQLTest.assertEquals((String)"", (String)this.it.getIndexLength(this.getDb().getUserTable().troidColumn()));
        MySQLTest.assertEquals((String)"(30)", (String)this.it.getIndexLength(this.getDb().getTableInfoTable().getDescriptionColumn()));
    }

    @Override
    public void testCanRepresent() {
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)StringPoemType.nullableInstance, (PoemType)IntegerPoemType.nullableInstance));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)IntegerPoemType.nullableInstance, (PoemType)StringPoemType.nullableInstance));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)new BigDecimalPoemType(false), (PoemType)new BigDecimalPoemType(true)));
        MySQLTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BigDecimalPoemType(true), (PoemType)new BigDecimalPoemType(false)) instanceof BigDecimalPoemType));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)new StringPoemType(true, 255), (PoemType)new StringPoemType(true, -1)));
        MySQLTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, -1), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)new TimestampPoemType(true), (PoemType)new DatePoemType(true)));
        MySQLTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BooleanPoemType(true), (PoemType)new BooleanPoemType(false)) instanceof BooleanPoemType));
        MySQLTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new IntegerPoemType(true), (PoemType)new BooleanPoemType(false)) instanceof BooleanPoemType));
        MySQLTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new IntegerPoemType(false), (PoemType)new BooleanPoemType(false)) instanceof BooleanPoemType));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(false), (PoemType)new BigDecimalPoemType(true)));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(true), (PoemType)new BigDecimalPoemType(false)));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)new IntegerPoemType(false), (PoemType)new LongPoemType(true)));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)new BinaryPoemType(false, 10), (PoemType)new BinaryPoemType(true, 10)));
        MySQLTest.assertNull((Object)this.it.canRepresent((PoemType)new BinaryPoemType(true, 10), (PoemType)new BinaryPoemType(true, 11)));
        MySQLTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BinaryPoemType(true, -1), (PoemType)new BinaryPoemType(true, -1)) instanceof BinaryPoemType));
        MySQLTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BinaryPoemType(true, 2500), (PoemType)new BinaryPoemType(true, 10)) instanceof BinaryPoemType));
    }

    @Override
    public void testGetForeignKeyDefinition() {
        MySQLTest.assertEquals((String)" ADD FOREIGN KEY (user) REFERENCES user(id) ON DELETE CASCADE", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "delete"));
    }

    @Override
    public void testGetPrimaryKeyDefinition() {
        MySQLTest.assertEquals((String)" ADD PRIMARY KEY (name)", (String)this.it.getPrimaryKeyDefinition("name"));
    }

    @Override
    public void testGivesCapabilitySQL() {
        String actual = this.it.givesCapabilitySQL(new Integer(42), "hello");
        String expected = "SELECT " + this.it.getQuotedName("groupMembership") + ".* " + "FROM " + this.it.getQuotedName("groupMembership") + " LEFT JOIN " + this.it.getQuotedName("groupCapability") + " ON " + this.it.getQuotedName("groupMembership") + "." + this.it.getQuotedName("group") + " =  " + this.it.getQuotedName("groupCapability") + "." + this.it.getQuotedName("group") + " WHERE " + this.it.getQuotedName("user") + " = 42" + " " + "AND " + this.it.getQuotedName("groupCapability") + "." + this.it.getQuotedName("group") + " IS NOT NULL " + "AND " + this.it.getQuotedName("capability") + " = hello";
        MySQLTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQL() {
        String expected = "a LIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "b");
        MySQLTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQLQuoted() {
        String expected = "a LIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "\"b\"");
        MySQLTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQLBlank() {
        String expected = " LIKE '%%'";
        String actual = this.it.caseInsensitiveRegExpSQL("", "");
        MySQLTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCreateTableSql() {
        if (this.getDb().getDbms() == this.it) {
            MySQLTest.assertEquals((String)"CREATE TABLE user (id INT NOT NULL, name VARCHAR(60) NOT NULL, login VARCHAR(255) NOT NULL, password VARCHAR(20) NOT NULL) TYPE='InnoDB' ", (String)this.it.createTableSql((Table)this.getDb().getUserTable()));
        }
    }
}

