/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.melati.poem.CachedCount;
import org.melati.poem.CachedExists;
import org.melati.poem.CapabilityTable;
import org.melati.poem.Column;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.GroupTable;
import org.melati.poem.NoSuchColumnPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemThread;
import org.melati.poem.Table;
import org.melati.poem.TableInfo;
import org.melati.poem.User;
import org.melati.poem.UserTable;
import org.melati.poem.test.PoemTestCase;
import org.melati.poem.util.EmptyEnumeration;
import org.melati.poem.util.EnumUtils;

public class TableTest
extends PoemTestCase {
    public TableTest(String arg0) {
        super(arg0);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testTable() {
    }

    public void testPostInitialise() {
    }

    public void testGetDatabase() {
        TableTest.assertTrue((boolean)this.getDb().getUserTable().getDatabase().equals(this.getDb()));
    }

    public void testGetName() {
        UserTable ut = this.getDb().getUserTable();
        TableTest.assertEquals((String)"user", (String)ut.getName());
    }

    public void testQuotedName() {
        UserTable ut = this.getDb().getUserTable();
        TableTest.assertEquals((String)this.getDb().getDbms().getQuotedName("user"), (String)ut.quotedName());
    }

    public void testGetDisplayName() {
    }

    public void testGetDescription() {
        TableTest.assertEquals((String)"A registered User of the database", (String)this.getDb().getUserTable().getDescription());
    }

    public void testGetCategory() {
        TableTest.assertEquals((String)"User", (String)this.getDb().getUserTable().getCategory().getName());
    }

    public void testGetInfo() {
        TableTest.assertEquals((String)"User", (String)this.getDb().getUserTable().getInfo().getCategory().getName());
    }

    public void testTableInfoID() {
    }

    public void testGetColumn() {
        try {
            this.getDb().getUserTable().getColumn("nonexistantcolum");
            TableTest.fail((String)"Should have blown up");
        }
        catch (NoSuchColumnPoemException e) {
            Object var1_2 = null;
        }
    }

    public void test_getColumn() {
    }

    public void testColumns() {
        Enumeration en = this.getDb().tables();
        while (en.hasMoreElements()) {
            Table t = (Table)en.nextElement();
            int colCount = EnumUtils.vectorOf((Enumeration)t.columns()).size();
            TableTest.assertTrue((String)("Table " + t.getName() + " columns(): " + colCount + " t.getDetailDisplayColumnsCount(): " + t.getDetailDisplayColumnsCount()), (colCount == t.getDetailDisplayColumnsCount() ? 1 : 0) != 0);
            int colIndex = 0;
            String[][] cols = new String[colCount][3];
            Enumeration colEn = t.columns();
            while (colEn.hasMoreElements()) {
                Column c = (Column)colEn.nextElement();
                cols[colIndex][0] = c.getName();
                boolean inDetailDisplayColumns = false;
                Enumeration detailDisplayCols = t.getDetailDisplayColumns();
                while (detailDisplayCols.hasMoreElements()) {
                    Column recCol = (Column)detailDisplayCols.nextElement();
                    if (recCol != c) continue;
                    inDetailDisplayColumns = true;
                }
                cols[colIndex][1] = new Boolean(inDetailDisplayColumns).toString();
                ++colIndex;
            }
            for (int i = 0; i < colCount; ++i) {
                TableTest.assertTrue((String)("    " + i + " " + cols[i][0] + " " + cols[i][1]), (boolean)cols[i][1].equals("true"));
            }
        }
    }

    public void testGetColumnsCount() {
        TableTest.assertEquals((int)4, (int)this.getDb().getUserTable().getColumnsCount());
    }

    public void testColumnWithColumnInfoID() {
    }

    public void testTroidColumn() {
    }

    public void testDeletedColumn() {
    }

    public void testDisplayColumn() {
    }

    public void testSetDisplayColumn() {
    }

    public void testPrimaryCriterionColumn() {
        TableTest.assertEquals((String)"name", (String)this.getDb().getUserTable().primaryCriterionColumn().getName());
    }

    public void testSetSearchColumn() {
    }

    public void testDefaultOrderByClause() {
    }

    public void testNotifyColumnInfo() {
    }

    public void testDisplayColumns() {
    }

    public void testDisplayColumnsCount() {
        TableTest.assertEquals((int)1, (int)this.getDb().getUserTable().displayColumnsCount(DisplayLevel.primary));
    }

    public void testGetDetailDisplayColumns() {
        Enumeration them = this.getDb().getUserTable().getDetailDisplayColumns();
        int counter = 0;
        while (them.hasMoreElements()) {
            them.nextElement();
            ++counter;
        }
        TableTest.assertEquals((int)4, (int)counter);
    }

    public void testGetDetailDisplayColumnsCount() {
        TableTest.assertEquals((int)4, (int)this.getDb().getUserTable().getDetailDisplayColumnsCount());
    }

    public void testGetRecordDisplayColumns() {
        Enumeration them = this.getDb().getUserTable().getRecordDisplayColumns();
        int counter = 0;
        while (them.hasMoreElements()) {
            them.nextElement();
            ++counter;
        }
        TableTest.assertEquals((int)3, (int)counter);
    }

    public void testGetRecordDisplayColumnsCount() {
        TableTest.assertEquals((int)3, (int)this.getDb().getUserTable().getRecordDisplayColumnsCount());
    }

    public void testGetSummaryDisplayColumns() {
        Enumeration them = this.getDb().getUserTable().getSummaryDisplayColumns();
        int counter = 0;
        while (them.hasMoreElements()) {
            them.nextElement();
            ++counter;
        }
        TableTest.assertEquals((int)2, (int)counter);
    }

    public void testGetSummaryDisplayColumnsCount() {
        TableTest.assertEquals((int)2, (int)this.getDb().getUserTable().getSummaryDisplayColumnsCount());
    }

    public void testGetSearchCriterionColumns() {
    }

    public void testGetSearchCriterionColumnsCount() {
        TableTest.assertEquals((int)3, (int)this.getDb().getUserTable().getSearchCriterionColumnsCount());
    }

    public void testDbModifyStructure() {
    }

    public void testLoad() {
    }

    public void testDelete() {
    }

    public void testWriteDown() {
        User u = this.getDb().administratorUser();
        String name = u.getName();
        u.setName("changed");
        PoemThread.commit();
        TableTest.assertEquals((String)"changed", (String)u.getName());
        u.setName(name);
        PoemThread.commit();
        TableTest.assertEquals((String)name, (String)u.getName());
    }

    public void testUncacheContents() {
    }

    public void testTrimCache() {
    }

    public void testGetCacheInfo() {
        this.getDb().uncache();
        Enumeration them = this.getDb().getUserTable().getCacheInfo().getHeldElements();
        int counter = 0;
        while (them.hasMoreElements()) {
            them.nextElement();
            ++counter;
        }
        TableTest.assertEquals((int)2, (int)counter);
    }

    public void testAddListener() {
    }

    public void testNotifyTouched() {
    }

    public void testSerial() {
    }

    public void testReadLock() {
    }

    public void testGetObjectInteger() {
        int count1 = this.getDb().getQueryCount();
        User u = this.getDb().guestUser();
        int count2 = this.getDb().getQueryCount();
        UserTable ut = this.getDb().getUserTable();
        int count3 = this.getDb().getQueryCount();
        User u2 = (User)ut.getObject(new Integer(0));
        int count4 = this.getDb().getQueryCount();
        User u3 = (User)ut.getObject(new Integer(0));
        int count5 = this.getDb().getQueryCount();
        TableTest.assertEquals((Object)u, (Object)u2);
        System.err.println(u3.getName());
        int count6 = this.getDb().getQueryCount();
        System.err.println(count1 + ":" + count2 + ":" + count3 + ":" + count4 + ":" + count5 + ":" + count6);
    }

    public void testGetObjectInt() {
        GroupTable t = this.getDb().getGroupTable();
        Persistent p = t.getObject(0);
        TableTest.assertEquals((Object)new Integer(0), (Object)p.getTroid());
    }

    public void testSelectionSQLStringStringBoolean() {
    }

    public void testSelectionSQLStringStringStringBooleanBoolean() {
    }

    public void testTroidSelectionStringStringBooleanPoemTransaction() {
    }

    public void testTroidSelectionPersistentStringBooleanBooleanPoemTransaction() {
    }

    public void testRememberAllTroids() {
    }

    public void testSetCacheLimit() {
    }

    public void testTroidSelectionStringStringBoolean() {
        Enumeration en = this.getDb().getUserTable().troidSelection(null, null, true);
        TableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)en).size());
    }

    public void testSelection() {
    }

    public void testSelectionString() {
    }

    public void testFirstSelection() {
    }

    public void testSelectionStringStringBoolean() {
    }

    public void testSelectionPersistent() {
        User exemplar = (User)this.getDb().getUserTable().newPersistent();
        Enumeration found = this.getDb().getUserTable().selection((Persistent)exemplar);
        int count = 0;
        User outcome = null;
        while (found.hasMoreElements()) {
            ++count;
            outcome = (User)found.nextElement();
        }
        TableTest.assertNotNull(outcome);
        TableTest.assertEquals((int)2, (int)count);
        exemplar.setLogin("_administrator_");
        outcome = null;
        count = 0;
        found = this.getDb().getUserTable().selection((Persistent)exemplar, this.getDb().getUserTable().getNameColumn().fullQuotedName());
        while (found.hasMoreElements()) {
            ++count;
            outcome = (User)found.nextElement();
        }
        TableTest.assertNotNull((Object)outcome);
        TableTest.assertEquals((int)1, (int)count);
        exemplar.setLogin("notSet");
        outcome = null;
        count = 0;
        found = this.getDb().getUserTable().selection((Persistent)exemplar);
        while (found.hasMoreElements()) {
            ++count;
            outcome = (User)found.nextElement();
        }
        TableTest.assertNull((Object)outcome);
        TableTest.assertEquals((int)0, (int)count);
    }

    public void testSelectionPersistentString() {
    }

    public void testSelectionPersistentStringBooleanBoolean() {
    }

    public void testCountSQLString() {
    }

    public void testCountSQLStringStringBooleanBoolean() {
    }

    public void testCountStringBooleanBoolean() {
    }

    public void testCountStringBoolean() {
    }

    public void testCountString() {
    }

    public void testCount() {
        TableTest.assertEquals((int)2, (int)this.getDb().getUserTable().count());
    }

    public void testExistsString() {
    }

    public void testExistsPersistent() {
    }

    public void testAppendWhereClause() {
    }

    public void testWhereClausePersistent() {
    }

    public void testWhereClausePersistentBooleanBoolean() {
    }

    public void testCnfWhereClauseEnumeration() {
        String cnf = this.getDb().getUserTable().cnfWhereClause(this.getDb().getUserTable().selection());
        String expected = "((" + this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("id") + " = 0 AND " + this.getDb().getDbms().caseInsensitiveRegExpSQL(this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("name"), "Melati guest user") + " AND " + this.getDb().getDbms().caseInsensitiveRegExpSQL(this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("login"), "_guest_") + " AND " + this.getDb().getDbms().caseInsensitiveRegExpSQL(this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("password"), "guest") + ") OR" + " (" + this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("id") + " = 1 AND " + this.getDb().getDbms().caseInsensitiveRegExpSQL(this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("name"), "Melati database administrator") + " AND " + this.getDb().getDbms().caseInsensitiveRegExpSQL(this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("login"), "_administrator_") + " AND " + this.getDb().getDbms().caseInsensitiveRegExpSQL(this.getDb().getDbms().getQuotedName("user") + "." + this.getDb().getDbms().getQuotedName("password"), "FIXME") + "))";
        TableTest.assertEquals((String)expected, (String)cnf);
        cnf = this.getDb().getUserTable().cnfWhereClause((Enumeration)new EmptyEnumeration());
        TableTest.assertEquals((String)"", (String)cnf);
        Vector<User> v = new Vector<User>();
        v.addElement((User)this.getDb().getUserTable().newPersistent());
        cnf = this.getDb().getUserTable().cnfWhereClause(v.elements());
        TableTest.assertEquals((String)"", (String)cnf);
    }

    public void testCnfWhereClauseEnumerationBooleanBoolean() {
    }

    public void testReferencesToPersistent() {
    }

    public void testReferencesToTable() {
    }

    public void testTroidFor() {
    }

    public void testCreatePersistent() {
    }

    public void testCreateInitialiser() {
    }

    public void testNewPersistent() {
    }

    public void test_newPersistent() {
    }

    public void testDelete_unsafe() {
        User tester = (User)this.getDb().getUserTable().newPersistent();
        tester.setName("tester");
        tester.setLogin("tester");
        tester.setPassword("pwd");
        tester.makePersistent();
        this.getDb().getUserTable().delete_unsafe(this.getDb().getUserTable().getNameColumn().fullQuotedName() + " = 'tester'");
        PoemThread.commit();
        tester.delete();
        tester = (User)this.getDb().getUserTable().getNameColumn().firstWhereEq((Object)"tester");
        TableTest.assertNull((Object)tester);
    }

    public void testExtrasCount() {
    }

    public void testGetDefaultCanRead() {
    }

    public void testGetDefaultCanWrite() {
    }

    public void testGetDefaultCanDelete() {
    }

    public void testGetCanCreate() {
    }

    public void testCanReadColumn() {
    }

    public void testCanSelectColumn() {
    }

    public void testCanWriteColumn() {
    }

    public void testCanDeleteColumn() {
    }

    public void testAddColumnAndCommitTroid() {
    }

    public void testAddColumnAndCommitDeleted() throws Exception {
    }

    public void testAddColumnAndCommitType() {
    }

    public void testAddColumnAndCommitBoolean() {
    }

    public void testAddColumnAndCommitInteger() {
    }

    public void testAddColumnAndCommitNullableInteger() {
    }

    public void testAddColumnAndCommitDouble() {
    }

    public void testAddColumnAndCommitLong() {
    }

    public void testAddColumnAndCommitBigDecimal() {
    }

    public void testAddColumnAndCommitString() {
    }

    public void testAddColumnAndCommitPassword() {
    }

    public void testAddColumnAndCommitDate() {
    }

    public void testAddColumnAndCommitTimestamp() {
    }

    public void testAddColumnAndCommitBinary() {
    }

    public void testAddColumnAndCommitDisplaylevel() {
    }

    public void testAddColumnAndCommitSearchability() {
    }

    public void testAddColumnAndCommitIntegrityfix() {
    }

    public void testToString() {
        UserTable ut = this.getDb().getUserTable();
        TableTest.assertEquals((String)"user (from the data structure definition)", (String)ut.toString());
    }

    public void testDumpCacheAnalysis() {
    }

    public void testDump() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.getDb().getUserTable().dump(ps);
        System.err.println(baos.toString());
        TableTest.assertTrue((boolean)baos.toString().startsWith("=== table user (tableinfo id 0"));
    }

    public void testCachedSelection() {
    }

    public void testCachedCountStringBoolean() {
    }

    public void testCachedCountStringBooleanBoolean() {
    }

    public void testCachedCountPersistentBooleanBoolean() {
        TableInfo ti = (TableInfo)this.getDb().getTableInfoTable().newPersistent();
        CachedCount cached = this.getDb().getTableInfoTable().cachedCount((Persistent)ti, false, false);
        if (this.getDb().getDbms().canDropColumns()) {
            TableTest.assertEquals((int)9, (int)cached.count());
        }
        ti.setSeqcached(true);
        cached = this.getDb().getTableInfoTable().cachedCount((Persistent)ti, false, false);
        TableTest.assertEquals((int)7, (int)cached.count());
    }

    public void testCachedCountString() {
    }

    public void testCachedCountPersistent() {
        TableInfo ti = (TableInfo)this.getDb().getTableInfoTable().newPersistent();
        CachedCount cached = this.getDb().getTableInfoTable().cachedCount((Persistent)ti);
        if (this.getDb().getDbms().canDropColumns()) {
            TableTest.assertEquals((int)9, (int)cached.count());
        }
        ti.setSeqcached(true);
        cached = this.getDb().getTableInfoTable().cachedCount((Persistent)ti);
        TableTest.assertEquals((int)7, (int)cached.count());
    }

    public void testCachedExists() {
        CachedExists cached = this.getDb().getUserTable().cachedExists(null);
        TableTest.assertEquals((int)2, (int)cached.count());
        User t = (User)this.getDb().getUserTable().newPersistent();
        t.setName("TestUser");
        t.setLogin("TestUser");
        t.setPassword("TestUser");
        t.makePersistent();
        TableTest.assertEquals((int)3, (int)cached.count());
        t.delete();
    }

    public void testCachedSelectionType() {
    }

    public void testCachedSelectionField() {
        String whereClause = this.getDb().getTableInfoTable().getDisplayorderColumn().fullQuotedName() + "  <3000 AND " + this.getDb().getTableInfoTable().getDisplayorderColumn().fullQuotedName() + "  > 2000";
        Field userTableFields = this.getDb().getTableInfoTable().cachedSelectionField(whereClause, null, true, null, "userTables");
        Enumeration them = userTableFields.getPossibilities();
        TableTest.assertEquals((String)"userTables: ", (String)them.nextElement().toString());
        TableTest.assertEquals((String)"userTables: User", (String)them.nextElement().toString());
        TableTest.assertEquals((String)"userTables: Group", (String)them.nextElement().toString());
        TableTest.assertEquals((String)"userTables: Capability", (String)them.nextElement().toString());
        TableTest.assertEquals((String)"userTables: Group membership", (String)them.nextElement().toString());
        TableTest.assertEquals((String)"userTables: Group capability", (String)them.nextElement().toString());
        TableTest.assertFalse((boolean)them.hasMoreElements());
        TableTest.assertEquals(null, (Object)userTableFields.getRaw());
        userTableFields = this.getDb().getTableInfoTable().cachedSelectionField(whereClause, this.getDb().getTableInfoTable().getDisplaynameColumn().fullQuotedName(), true, null, "userTables");
        them = userTableFields.getPossibilities();
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: ");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Capability");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group capability");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group membership");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: User");
        TableTest.assertFalse((boolean)them.hasMoreElements());
        TableTest.assertEquals(null, (Object)userTableFields.getRaw());
        userTableFields = this.getDb().getTableInfoTable().cachedSelectionField(whereClause, this.getDb().getTableInfoTable().getDisplaynameColumn().fullQuotedName(), false, null, "userTables");
        them = userTableFields.getPossibilities();
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Capability");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group capability");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group membership");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: User");
        TableTest.assertFalse((boolean)them.hasMoreElements());
        TableTest.assertEquals(null, (Object)userTableFields.getRaw());
        userTableFields = this.getDb().getTableInfoTable().cachedSelectionField(whereClause, this.getDb().getTableInfoTable().getDisplaynameColumn().fullQuotedName(), false, new Integer(0), "userTables");
        them = userTableFields.getPossibilities();
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Capability");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group capability");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: Group membership");
        TableTest.assertEquals((String)them.nextElement().toString(), (String)"userTables: User");
        TableTest.assertFalse((boolean)them.hasMoreElements());
        TableTest.assertEquals((Object)new Integer(0), (Object)userTableFields.getRaw());
    }

    public void testDefineColumnColumnBoolean() {
    }

    public void testDefineColumnColumn() {
    }

    public void testSetTableInfo() {
    }

    public void testGetTableInfo() {
    }

    public void testDefaultDisplayName() {
    }

    public void testDefaultDisplayOrder() {
    }

    public void testDefaultDescription() {
    }

    public void testDefaultCacheLimit() {
    }

    public void testDefaultRememberAllTroids() {
    }

    public void testDefaultCategory() {
    }

    public void testCreateTableInfo() {
    }

    public void testUnifyWithColumnInfo() {
    }

    public void testUnifyWithDB() {
    }

    public void testInit() {
    }

    public void testHashCode() {
        UserTable ut = this.getDb().getUserTable();
        UserTable ut2 = this.getDb().getUserTable();
        TableTest.assertTrue((boolean)ut.equals(ut2));
        TableTest.assertEquals((int)ut.hashCode(), (int)ut2.hashCode());
    }

    public void testEqualsObject() {
        UserTable ut = this.getDb().getUserTable();
        CapabilityTable ct = this.getDb().getCapabilityTable();
        TableTest.assertFalse((boolean)ut.equals(ct));
        UserTable ut2 = this.getDb().getUserTable();
        TableTest.assertTrue((boolean)ut.equals(ut2));
        TableTest.assertTrue((boolean)ut2.equals(ut));
        TableTest.assertTrue((boolean)ut.equals(ut));
        TableTest.assertFalse((boolean)ut.equals(null));
        TableTest.assertFalse((boolean)ut.equals(new Object()));
    }
}

