/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import org.melati.poem.Table;
import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.dbms.test.DbmsSpec;

public class HsqldbTest
extends DbmsSpec {
    public HsqldbTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void setObjectUnderTest() {
        this.it = DbmsFactory.getDbms((String)"org.melati.poem.dbms.Hsqldb");
    }

    @Override
    public void testCreateTableSql() {
        if (this.getDb().getDbms() == this.it) {
            HsqldbTest.assertEquals((String)"CREATE CACHED TABLE \"USER\" (\"ID\" INT NOT NULL, \"NAME\" VARCHAR(60) NOT NULL, \"LOGIN\" VARCHAR(255) NOT NULL, \"PASSWORD\" VARCHAR(20) NOT NULL)", (String)this.it.createTableSql((Table)this.getDb().getUserTable()));
        }
    }

    @Override
    public void testGetStringSqlDefinition() throws Exception {
        HsqldbTest.assertEquals((String)"LONGVARCHAR", (String)this.it.getStringSqlDefinition(-1));
    }

    @Override
    public void testGetLongSqlDefinition() {
        HsqldbTest.assertEquals((String)"BIGINT", (String)this.it.getLongSqlDefinition());
    }

    @Override
    public void testGetBinarySqlDefinition() throws Exception {
        HsqldbTest.assertEquals((String)"LONGVARBINARY", (String)this.it.getBinarySqlDefinition(0));
    }

    @Override
    public void testMelatiName() {
        HsqldbTest.assertEquals((String)"name", (String)this.it.melatiName("name"));
        HsqldbTest.assertEquals(null, (String)this.it.melatiName(null));
        HsqldbTest.assertEquals((String)"~special", (String)this.it.melatiName("~Special"));
        HsqldbTest.assertEquals((String)"unique", (String)this.it.melatiName("MELATI_UNIQUE"));
        HsqldbTest.assertEquals((String)"constraint", (String)this.it.melatiName("MELATI_CONSTRAINT"));
        HsqldbTest.assertEquals((String)"users", (String)this.it.melatiName("users"));
    }

    @Override
    public void testUnreservedName() {
        HsqldbTest.assertEquals((String)"NAME", (String)this.it.unreservedName("name"));
    }

    @Override
    public void testGetJdbcMetadataName() {
        HsqldbTest.assertEquals((String)"NAME", (String)this.it.getJdbcMetadataName("name"));
    }

    @Override
    public void testGetForeignKeyDefinition() {
        HsqldbTest.assertEquals((String)" ADD FOREIGN KEY (\"USER\") REFERENCES \"USER\"(\"ID\")", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "prevent"));
        HsqldbTest.assertEquals((String)" ADD FOREIGN KEY (\"USER\") REFERENCES \"USER\"(\"ID\") ON DELETE SET NULL", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "clear"));
        HsqldbTest.assertEquals((String)" ADD FOREIGN KEY (\"USER\") REFERENCES \"USER\"(\"ID\") ON DELETE CASCADE", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "delete"));
    }

    @Override
    public void testGetPrimaryKeyDefinition() {
        HsqldbTest.assertEquals((String)" ADD PRIMARY KEY (\"NAME\")", (String)this.it.getPrimaryKeyDefinition("name"));
    }

    @Override
    public void testCaseInsensitiveRegExpSQL() {
        String expected = "a LIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "b");
        HsqldbTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQLQuoted() {
        String expected = "a LIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "\"b\"");
        HsqldbTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQLBlank() {
        String expected = " LIKE '%%'";
        String actual = this.it.caseInsensitiveRegExpSQL("", "");
        HsqldbTest.assertEquals((String)expected, (String)actual);
    }
}

