/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test.throwing;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.melati.poem.Database;
import org.melati.poem.PoemDatabaseFactory;
import org.melati.poem.PreparedSQLSeriousPoemException;
import org.melati.poem.PreparedStatementFactory;
import org.melati.poem.SQLPoemException;
import org.melati.poem.dbms.test.sql.Thrower;

public class PreparedStatementFactoryTest
extends org.melati.poem.test.PreparedStatementFactoryTest {
    public PreparedStatementFactoryTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        PoemDatabaseFactory.removeDatabase((String)this.getDatabaseName());
        super.setUp();
        PreparedStatementFactoryTest.assertEquals((String)"org.melati.poem.dbms.test.HsqldbThrower", (String)this.getDb().getDbms().getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            PoemDatabaseFactory.removeDatabase((String)this.getDatabaseName());
        }
    }

    @Override
    public Database getDatabase(String name) {
        this.maxTrans = 4;
        Database db = PoemDatabaseFactory.getDatabase((String)name, (String)("jdbc:hsqldb:mem:" + name), (String)"sa", (String)"", (String)"org.melati.poem.PoemDatabase", (String)"org.melati.poem.dbms.test.HsqldbThrower", (boolean)false, (boolean)false, (boolean)false, (int)this.maxTrans);
        return db;
    }

    @Override
    public void testGet() {
        super.testGet();
    }

    @Override
    public void testPreparedStatement() throws Exception {
        Thrower.startThrowing(Connection.class, (String)"prepareStatement");
        try {
            super.testPreparedStatement();
            PreparedStatementFactoryTest.fail((String)"Should have bombed");
        }
        catch (SQLPoemException e) {
            PreparedStatementFactoryTest.assertEquals((String)"Connection bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(Connection.class, (String)"prepareStatement");
    }

    @Override
    public void testPreparedStatementFactory() {
    }

    @Override
    public void testPreparedStatementPoemTransaction() {
    }

    @Override
    public void testResultSet() throws Exception {
        PreparedStatementFactory it = new PreparedStatementFactory(this.getDb(), this.getDb().getUserTable().selectionSQL(null, null, null, true, false));
        try {
            Thrower.startThrowing(PreparedStatement.class, (String)"executeQuery");
            it.resultSet();
            PreparedStatementFactoryTest.fail((String)"Should have bombed");
        }
        catch (PreparedSQLSeriousPoemException e) {
            PreparedStatementFactoryTest.assertEquals((String)"PreparedStatement bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(PreparedStatement.class, (String)"executeQuery");
    }
}

