/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import java.sql.Connection;
import java.sql.SQLException;
import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.test.PoemTestCase;

public abstract class DbmsSpec
extends PoemTestCase {
    protected Dbms it = null;

    public DbmsSpec(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.setObjectUnderTest();
    }

    @Override
    protected void tearDown() throws Exception {
        this.it.unloadDriver();
    }

    protected abstract void setObjectUnderTest();

    public void testGetConnection() throws Exception {
        Connection c = PoemThread.transaction().getDatabase().getCommittedConnection();
        if (c.getClass().getName().indexOf("postgresql") == -1) {
            DbmsSpec.assertTrue((String)(c.getTransactionIsolation() + " is not >= " + 2 + " for database " + PoemThread.transaction().getDatabase() + " using " + PoemThread.transaction().getDatabase().getDbms() + " for connection " + c.getClass().getName()), (c.getTransactionIsolation() >= 2 ? 1 : 0) != 0);
        }
    }

    public void testGetSchema() {
        DbmsSpec.assertNull((Object)this.it.getSchema());
    }

    public void testShutdown() {
    }

    public void testGetQuotedName() {
    }

    public void testGetQuotedValue() {
    }

    public void testGetJdbcMetadataName() {
        DbmsSpec.assertEquals((String)"name", (String)this.it.getJdbcMetadataName("name"));
    }

    public void testPreparedStatementPlaceholder() {
        DbmsSpec.assertEquals((String)"?", (String)this.it.preparedStatementPlaceholder((PoemType)new IntegerPoemType(true)));
        DbmsSpec.assertEquals((String)"?", (String)this.it.preparedStatementPlaceholder((PoemType)new LongPoemType(true)));
        DbmsSpec.assertEquals((String)"?", (String)this.it.preparedStatementPlaceholder((PoemType)new DoublePoemType(true)));
        DbmsSpec.assertEquals((String)"?", (String)this.it.preparedStatementPlaceholder((PoemType)new StringPoemType(true, -1)));
    }

    public void testCreateTableSql() {
        if (this.getDb().getDbms() == this.it) {
            DbmsSpec.assertEquals((String)"CREATE TABLE \"MELATI_USER\" (\"id\" INT NOT NULL, \"name\" VARCHAR(60) NOT NULL, \"login\" VARCHAR(255) NOT NULL, \"password\" VARCHAR(20) NOT NULL)", (String)this.it.createTableSql((Table)this.getDb().getUserTable()));
        }
    }

    public void testCreateTableOptionsSql() {
        DbmsSpec.assertEquals((String)"", (String)this.it.createTableOptionsSql());
    }

    public void testGetSqlDefinition() throws Exception {
        DbmsSpec.assertEquals((String)"BOOLEAN", (String)this.it.getSqlDefinition("BOOLEAN"));
        DbmsSpec.assertEquals((String)"DOUBLE PRECISION", (String)this.it.getSqlDefinition("DOUBLE PRECISION"));
        DbmsSpec.assertEquals((String)"INT8", (String)this.it.getSqlDefinition("INT8"));
        DbmsSpec.assertEquals((String)"INT", (String)this.it.getSqlDefinition("INT"));
        DbmsSpec.assertEquals((String)"Big Decimal", (String)this.it.getSqlDefinition("Big Decimal"));
        DbmsSpec.assertEquals((String)"STRING", (String)this.it.getSqlDefinition("STRING"));
    }

    public void testGetStringSqlDefinition() throws Exception {
        DbmsSpec.assertEquals((String)"VARCHAR(0)", (String)this.it.getStringSqlDefinition(0));
        try {
            this.it.getStringSqlDefinition(-1);
            DbmsSpec.fail((String)"Should have blown up");
        }
        catch (SQLException e) {
            Object var1_2 = null;
        }
    }

    public void testGetLongSqlDefinition() {
        DbmsSpec.assertEquals((String)"INT8", (String)this.it.getLongSqlDefinition());
    }

    public void testSqlBooleanValueOfRaw() {
        DbmsSpec.assertEquals((String)"false", (String)this.it.sqlBooleanValueOfRaw((Object)Boolean.FALSE));
        DbmsSpec.assertEquals((String)"true", (String)this.it.sqlBooleanValueOfRaw((Object)Boolean.TRUE));
    }

    public void testGetBinarySqlDefinition() throws Exception {
        DbmsSpec.assertEquals((String)"LONGVARBINARY(0)", (String)this.it.getBinarySqlDefinition(0));
        try {
            this.it.getBinarySqlDefinition(-1);
            DbmsSpec.fail((String)"Should have blown up");
        }
        catch (SQLException e) {
            Object var1_2 = null;
        }
    }

    public void testGetFixedPtSqlDefinition() throws Exception {
        DbmsSpec.assertEquals((String)"DECIMAL(2,22)", (String)this.it.getFixedPtSqlDefinition(22, 2));
        try {
            this.it.getFixedPtSqlDefinition(-1, 2);
            DbmsSpec.fail((String)"Should have blown up");
        }
        catch (SQLException e2) {
            Object e2 = null;
        }
        try {
            this.it.getFixedPtSqlDefinition(22, -1);
            DbmsSpec.fail((String)"Should have blown up");
        }
        catch (SQLException e) {
            Object var1_4 = null;
        }
    }

    public void testCanRepresent() {
        DbmsSpec.assertNull((Object)this.it.canRepresent((PoemType)StringPoemType.nullableInstance, (PoemType)IntegerPoemType.nullableInstance));
        DbmsSpec.assertNull((Object)this.it.canRepresent((PoemType)IntegerPoemType.nullableInstance, (PoemType)StringPoemType.nullableInstance));
        DbmsSpec.assertNull((Object)this.it.canRepresent((PoemType)new BigDecimalPoemType(false), (PoemType)new BigDecimalPoemType(true)));
        DbmsSpec.assertTrue((boolean)(this.it.canRepresent((PoemType)new BigDecimalPoemType(true), (PoemType)new BigDecimalPoemType(false)) instanceof BigDecimalPoemType));
        DbmsSpec.assertNull((Object)this.it.canRepresent((PoemType)new StringPoemType(true, 250), (PoemType)new StringPoemType(true, -1)));
    }

    public void testDefaultPoemTypeOfColumnMetaData() {
    }

    public void testCanDropColumns() throws Exception {
        DbmsSpec.assertTrue((boolean)this.it.canDropColumns());
    }

    public void testExceptionForUpdateTableStringBooleanSQLException() {
    }

    public void testExceptionForUpdateTablePreparedStatementBooleanSQLException() {
    }

    public void testUnreservedName() {
        DbmsSpec.assertEquals((String)"name", (String)this.it.unreservedName("name"));
    }

    public void testMelatiName() {
        DbmsSpec.assertEquals((String)"name", (String)this.it.melatiName("name"));
        DbmsSpec.assertEquals(null, (String)this.it.melatiName(null));
        DbmsSpec.assertEquals((String)"~Special", (String)this.it.melatiName("~Special"));
    }

    public void testGetIndexLength() throws Exception {
        DbmsSpec.assertEquals((String)"", (String)this.it.getIndexLength(null));
    }

    public void testCanBeIndexed() throws Exception {
    }

    public void testGivesCapabilitySQL() {
        String actual = this.it.givesCapabilitySQL(new Integer(42), "hello");
        String expected = "SELECT * FROM " + this.it.getQuotedName("groupMembership") + " WHERE " + this.it.getQuotedName("user") + " = 42 AND " + "EXISTS ( SELECT " + this.it.getQuotedName("groupCapability") + "." + this.it.getQuotedName("group") + " FROM " + this.it.getQuotedName("groupCapability") + " WHERE " + this.it.getQuotedName("groupCapability") + "." + this.it.getQuotedName("group") + " = " + this.it.getQuotedName("groupMembership") + "." + this.it.getQuotedName("group") + " AND " + this.it.getQuotedName("capability") + " = hello)";
        DbmsSpec.assertEquals((String)expected, (String)actual);
    }

    public void testCaseInsensitiveRegExpSQL() {
        String expected = "a ILIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "b");
        DbmsSpec.assertEquals((String)expected, (String)actual);
    }

    public void testCaseInsensitiveRegExpSQLQuoted() {
        String expected = "a ILIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "\"b\"");
        DbmsSpec.assertEquals((String)expected, (String)actual);
    }

    public void testCaseInsensitiveRegExpSQLBlank() {
        String expected = " ILIKE '%%'";
        String actual = this.it.caseInsensitiveRegExpSQL("", "");
        DbmsSpec.assertEquals((String)expected, (String)actual);
    }

    public void testToString() {
    }

    public void testGetForeignKeyDefinition() {
        DbmsSpec.assertEquals((String)" ADD FOREIGN KEY (\"user\") REFERENCES \"user\"(\"id\") ON DELETE RESTRICT", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "prevent"));
        DbmsSpec.assertEquals((String)" ADD FOREIGN KEY (\"user\") REFERENCES \"user\"(\"id\") ON DELETE SET NULL", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "clear"));
        DbmsSpec.assertEquals((String)" ADD FOREIGN KEY (\"user\") REFERENCES \"user\"(\"id\") ON DELETE CASCADE", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "delete"));
    }

    public void testGetPrimaryKeyDefinition() {
        DbmsSpec.assertEquals((String)" ADD PRIMARY KEY (\"name\")", (String)this.it.getPrimaryKeyDefinition("name"));
    }

    public void testAlterColumnNotNullableSQL() {
    }

    public void testSelectLimit() {
        DbmsSpec.assertEquals((String)"SELECT * FROM \"USER\" LIMIT 1", (String)this.it.selectLimit("* FROM \"USER\"", 1));
    }

    public void testBooleanTrueExtression() {
    }
}

