/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Enumeration;
import org.melati.poem.AccessToken;
import org.melati.poem.ColumnInfo;
import org.melati.poem.ColumnRenamePoemException;
import org.melati.poem.DisplayLevel;
import org.melati.poem.DuplicateColumnNamePoemException;
import org.melati.poem.DuplicateDeletedColumnPoemException;
import org.melati.poem.DuplicateTableNamePoemException;
import org.melati.poem.DuplicateTroidColumnPoemException;
import org.melati.poem.IntegrityFix;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabaseFactory;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.ReadPersistentAccessPoemException;
import org.melati.poem.RowDisappearedPoemException;
import org.melati.poem.Searchability;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.Table;
import org.melati.poem.TableInfo;
import org.melati.poem.UnificationPoemException;
import org.melati.poem.test.Dynamic;
import org.melati.poem.test.DynamicTable;
import org.melati.poem.test.EverythingDatabase;
import org.melati.poem.test.EverythingTestCase;
import org.melati.poem.util.EnumUtils;

public class DynamicTableTest
extends EverythingTestCase {
    public DynamicTableTest(String arg0) {
        super(arg0);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.getDb().getDbms().canDropColumns()) {
            this.checkDbUnchanged();
        }
    }

    @Override
    protected void databaseUnchanged() {
        PoemThread.commit();
        this.dropTable("addedtable");
        this.dropTable("addedtable2");
        this.dropTable("addedtable3");
        this.dropTable("dynamic");
        this.dropTable("tableinfo");
        this.dropTable("columninfo");
        this.dropTable("tablecategory");
        PoemDatabaseFactory.removeDatabase((String)"everything");
    }

    public void testAddTableAndCommit() throws Exception {
        Object e3;
        ColumnInfo c;
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        TableInfo info = (TableInfo)this.getDb().getTableInfoTable().newPersistent();
        info.setName("addedtable");
        info.setDisplayname("Junit created table");
        info.setDisplayorder(13);
        info.setSeqcached(new Boolean(false));
        info.setCategory_unsafe(new Integer(1));
        info.setCachelimit(0);
        info.makePersistent();
        Table extra = this.getDb().addTableAndCommit(info, "id");
        ColumnInfo ci = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        ci.setTableinfo(info);
        ci.setTypefactory(PoemTypeFactory.STRING);
        ci.setNullable(false);
        ci.setSize(-1);
        ci.setWidth(20);
        ci.setHeight(1);
        ci.setPrecision(1);
        ci.setScale(1);
        ci.setName("extra");
        ci.setDescription("Description of extra column");
        ci.setDisplayname("Extra");
        ci.setDisplayorder(10);
        ci.setIndexed(true);
        ci.setUnique(true);
        ci.setSearchability(Searchability.yes);
        ci.setDisplaylevel(DisplayLevel.primary);
        ci.setUsereditable(true);
        ci.setUsercreateable(true);
        ci.makePersistent();
        try {
            extra.addColumnAndCommit(ci);
            DynamicTableTest.fail((String)"Should have bombed");
        }
        catch (UnificationPoemException e22) {
            Object e22 = null;
        }
        ci.setIndexed(false);
        ci.setUnique(false);
        extra.addColumnAndCommit(ci);
        Persistent extraPersistent = extra.newPersistent();
        PoemThread.commit();
        DynamicTableTest.assertNull((Object)extraPersistent.getTroid());
        extraPersistent.setCooked("extra", (Object)"Test");
        extraPersistent.makePersistent();
        DynamicTableTest.assertEquals((Object)"Test", (Object)extraPersistent.getField("extra").getRaw());
        extra.getTableInfo().setDefaultcanread(this.getDb().administerCapability());
        extraPersistent.getField("extra").getRaw();
        DynamicTableTest.assertEquals((Object)new Integer(0), (Object)extraPersistent.getTroid());
        Enumeration cols = this.getDb().getColumnInfoTable().getTableinfoColumn().selectionWhereEq((Object)info.getTroid());
        int colCount = 0;
        while (cols.hasMoreElements()) {
            c = (ColumnInfo)cols.nextElement();
            c.delete();
            ++colCount;
        }
        DynamicTableTest.assertEquals((int)2, (int)colCount);
        PoemThread.commit();
        this.dropTable("addedtable");
        try {
            this.getDb().addTableAndCommit(info, "id");
            DynamicTableTest.fail((String)"Should have blown up");
        }
        catch (DuplicateTableNamePoemException e3) {
            e3 = null;
        }
        cols = this.getDb().getColumnInfoTable().getTableinfoColumn().selectionWhereEq((Object)info.getTroid());
        colCount = 0;
        while (cols.hasMoreElements()) {
            c = (ColumnInfo)cols.nextElement();
            c.delete();
            ++colCount;
        }
        DynamicTableTest.assertEquals((int)1, (int)colCount);
        info.delete();
        PoemThread.commit();
        try {
            this.getDb().addTableAndCommit(info, "id");
            DynamicTableTest.fail((String)"Should have blown up");
        }
        catch (RowDisappearedPoemException e4) {
            e3 = null;
        }
        this.dropTable("addedtable");
        TableInfo info3 = (TableInfo)this.getDb().getTableInfoTable().newPersistent();
        info3.setName("addedtable2");
        info3.setDisplayname("Junit created table");
        info3.setDisplayorder(13);
        info3.setSeqcached(new Boolean(false));
        info3.setCategory_unsafe(new Integer(1));
        info3.setCachelimit(0);
        info3.makePersistent();
        PoemThread.commit();
        this.getDb().addTableAndCommit(info3, "id");
        cols = this.getDb().getColumnInfoTable().getTableinfoColumn().selectionWhereEq((Object)info3.getTroid());
        int count = 0;
        while (cols.hasMoreElements()) {
            ColumnInfo c2 = (ColumnInfo)cols.nextElement();
            c2.delete();
        }
        DynamicTableTest.assertEquals((int)0, (int)count);
        info3.deleteAndCommit();
        PoemThread.commit();
    }

    public void testExtraColumnAsField() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        TableInfo ti = (TableInfo)this.getDb().getTableInfoTable().newPersistent();
        ti.setName("addedtable3");
        ti.setDisplayname("Junit created table");
        ti.setDisplayorder(13);
        ti.setSeqcached(new Boolean(false));
        ti.setCategory_unsafe(new Integer(1));
        ti.setCachelimit(0);
        ti.makePersistent();
        Table extra = this.getDb().addTableAndCommit(ti, "id");
        ColumnInfo ci = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        ci.setTableinfo(ti);
        ci.setTypefactory(PoemTypeFactory.STRING);
        ci.setNullable(false);
        ci.setSize(-1);
        ci.setWidth(20);
        ci.setHeight(1);
        ci.setPrecision(1);
        ci.setScale(1);
        ci.setName("extra");
        ci.setDescription("Description of extra column");
        ci.setDisplayname("Extra");
        ci.setDisplayorder(10);
        ci.setIndexed(true);
        ci.setUnique(true);
        ci.setSearchability(Searchability.yes);
        ci.setDisplaylevel(DisplayLevel.primary);
        ci.setUsereditable(true);
        ci.setUsercreateable(true);
        ci.makePersistent();
        try {
            extra.addColumnAndCommit(ci);
            DynamicTableTest.fail((String)"Should have bombed");
        }
        catch (UnificationPoemException e2) {
            Object e2 = null;
        }
        ci.setIndexed(false);
        ci.setUnique(false);
        extra.addColumnAndCommit(ci);
        Persistent extraInstance = extra.newPersistent();
        PoemThread.commit();
        DynamicTableTest.assertNull((Object)extraInstance.getTroid());
        extraInstance.setCooked("extra", (Object)"Test");
        extraInstance.makePersistent();
        DynamicTableTest.assertEquals((Object)"Test", (Object)extraInstance.getField("extra").getRaw());
        extra.getTableInfo().setDefaultcanread(this.getDb().administerCapability());
        PoemThread.setAccessToken((AccessToken)this.getDb().guestAccessToken());
        try {
            extraInstance.getField("extra").getRaw();
            DynamicTableTest.fail((String)"Should have bombed");
        }
        catch (ReadPersistentAccessPoemException e3) {
            Object e3 = null;
        }
    }

    public void testAddColumnAndCommitTroid() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testtroidcol");
        columnInfo.setDisplayname("Test Troid Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Troid column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.TROID);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.detail);
        columnInfo.makePersistent();
        PoemThread.commit();
        try {
            columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
            DynamicTableTest.fail((String)"Should have blown up");
        }
        catch (DuplicateTroidColumnPoemException e2) {
            Object e2 = null;
        }
        try {
            columnInfo.delete();
        }
        catch (RuntimeException e) {
            PoemThread.commit();
            throw e;
        }
    }

    public void testAddColumnAndCommitDeleted() throws Exception {
        Object e2;
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testdeletedcol");
        columnInfo.setDisplayname("Test Deleted Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Deleted column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.DELETED);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testdeletedcol").selectionWhereEq((Object)Boolean.FALSE)).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testdeletedcol").selectionWhereEq((Object)Boolean.FALSE)).size());
        DynamicTableTest.assertEquals((Object)Boolean.FALSE, (Object)dt.two().getRaw("testdeletedcol"));
        DynamicTableTest.assertEquals((Object)Boolean.FALSE, (Object)dt.two().getCooked("testdeletedcol"));
        DynamicTableTest.assertEquals((Object)Boolean.FALSE, (Object)dt.getObject(0).getCooked("testdeletedcol"));
        try {
            columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
            DynamicTableTest.fail((String)"Should have blown up");
        }
        catch (DuplicateColumnNamePoemException e2) {
            DynamicTableTest.assertEquals((String)"Can't add duplicate column Dynamic.testdeletedcol: deleted (BOOLEAN (org.melati.poem.DeletedPoemType)) (from the running application) to Dynamic (from the data structure definition)", (String)e2.getMessage());
            e2 = null;
        }
        try {
            columnInfo.setName("testdeletedcol2");
            DynamicTableTest.fail((String)"Should have blown up");
        }
        catch (ColumnRenamePoemException e3) {
            e2 = null;
        }
        ColumnInfo columnInfo2 = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        columnInfo2.setTableinfo(ti);
        columnInfo2.setName("testdeletedcol2");
        columnInfo2.setDisplayname("Test duplicate Deleted Column");
        columnInfo2.setDisplayorder(99);
        columnInfo2.setSearchability(Searchability.yes);
        columnInfo2.setIndexed(false);
        columnInfo2.setUnique(false);
        columnInfo2.setDescription("A non-nullable extra Deleted column");
        columnInfo2.setUsercreateable(true);
        columnInfo2.setUsereditable(true);
        columnInfo2.setTypefactory(PoemTypeFactory.DELETED);
        columnInfo2.setSize(-1);
        columnInfo2.setWidth(20);
        columnInfo2.setHeight(1);
        columnInfo2.setPrecision(0);
        columnInfo2.setScale(0);
        columnInfo2.setNullable(false);
        columnInfo2.setDisplaylevel(DisplayLevel.summary);
        columnInfo2.makePersistent();
        try {
            columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo2);
            DynamicTableTest.fail((String)"Should have blown up");
        }
        catch (DuplicateDeletedColumnPoemException e42) {
            DynamicTableTest.assertEquals((String)"Can't add testdeletedcol2 to Dynamic as a deleted column, because it already has one, i.e. Dynamic.testdeletedcol: deleted (BOOLEAN (org.melati.poem.DeletedPoemType)) (from the running application)", (String)e42.getMessage());
            Object e42 = null;
        }
        PoemThread.commit();
    }

    public void testAddColumnAndCommitType() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testtypecol");
        columnInfo.setDisplayname("Test Type Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Type column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.TYPE);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        Integer t = null;
        Enumeration en = dt.selection();
        Dynamic d = (Dynamic)((Object)en.nextElement());
        t = (Integer)d.getRaw("testtypecol");
        int count = 0;
        while (en.hasMoreElements()) {
            d = (Dynamic)((Object)en.nextElement());
            if (!d.statusExistent()) continue;
            DynamicTableTest.assertEquals((Object)t, (Object)d.getRaw("testtypecol"));
            ++count;
        }
        DynamicTableTest.assertEquals((int)1, (int)count);
        PoemTypeFactory t2 = null;
        Enumeration en2 = dt.selection();
        t2 = (PoemTypeFactory)((Dynamic)((Object)en2.nextElement())).getCooked("testtypecol");
        while (en2.hasMoreElements()) {
            DynamicTableTest.assertEquals((String)t2.getName(), (String)((PoemTypeFactory)((Dynamic)((Object)en2.nextElement())).getCooked("testtypecol")).getName());
        }
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testtypecol").selectionWhereEq((Object)new Integer(0))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testtypecol").selectionWhereEq((Object)new Integer(0))).size());
        DynamicTableTest.assertEquals((Object)new Integer(0), (Object)dt.two().getRaw("testtypecol"));
        DynamicTableTest.assertEquals((String)"User", (String)((PoemTypeFactory)dt.two().getCooked("testtypecol")).getName());
        DynamicTableTest.assertEquals((String)"User", (String)((PoemTypeFactory)dt.getObject(0).getCooked("testtypecol")).getName());
        columnInfo.delete();
    }

    public void testAddColumnAndCommitBoolean() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testbooleancol");
        columnInfo.setDisplayname("Test Boolean Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Boolean column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.BOOLEAN);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testbooleancol").selectionWhereEq((Object)Boolean.FALSE)).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testbooleancol").selectionWhereEq((Object)Boolean.FALSE)).size());
        DynamicTableTest.assertEquals((Object)Boolean.FALSE, (Object)dt.two().getRaw("testbooleancol"));
        DynamicTableTest.assertEquals((Object)Boolean.FALSE, (Object)dt.two().getCooked("testbooleancol"));
        DynamicTableTest.assertEquals((Object)Boolean.FALSE, (Object)dt.getObject(0).getCooked("testbooleancol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitInteger() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.selection()).size());
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testintegercol");
        columnInfo.setDisplayname("Test Integer Column");
        columnInfo.setDisplayorder(199);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Integer column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.INTEGER);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testintegercol").selectionWhereEq((Object)new Integer(0))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testintegercol").selectionWhereEq((Object)new Integer(0))).size());
        DynamicTableTest.assertEquals((Object)new Integer(0), (Object)dt.two().getRaw("testintegercol"));
        DynamicTableTest.assertEquals((Object)new Integer(0), (Object)dt.two().getCooked("testintegercol"));
        DynamicTableTest.assertEquals((Object)new Integer(0), (Object)dt.getObject(0).getCooked("testintegercol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitNullableInteger() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testnullableintegercol");
        columnInfo.setDisplayname("Test Nullable Integer Column");
        columnInfo.setDisplayorder(199);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A nullable extra Integer column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.INTEGER);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(true);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)0, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testnullableintegercol").selectionWhereEq((Object)new Integer(0))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)0, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testnullableintegercol").selectionWhereEq((Object)new Integer(0))).size());
        DynamicTableTest.assertNull((Object)dt.two().getRaw("testnullableintegercol"));
        DynamicTableTest.assertNull((Object)dt.two().getCooked("testnullableintegercol"));
        DynamicTableTest.assertNull((Object)dt.getObject(0).getCooked("testnullableintegercol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitDouble() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testdoublecol");
        columnInfo.setDisplayname("Test Double Column");
        columnInfo.setDisplayorder(199);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Double column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.DOUBLE);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testdoublecol").selectionWhereEq((Object)new Double(0.0))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testdoublecol").selectionWhereEq((Object)new Double(0.0))).size());
        DynamicTableTest.assertEquals((Object)new Double(0.0), (Object)dt.two().getRaw("testdoublecol"));
        DynamicTableTest.assertEquals((Object)new Double(0.0), (Object)dt.two().getCooked("testdoublecol"));
        DynamicTableTest.assertEquals((Object)new Double(0.0), (Object)dt.getObject(0).getCooked("testdoublecol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitLong() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testlongcol");
        columnInfo.setDisplayname("Test Long Column");
        columnInfo.setDisplayorder(199);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Long column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.LONG);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testlongcol").selectionWhereEq((Object)new Long(0L))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testlongcol").selectionWhereEq((Object)new Long(0L))).size());
        DynamicTableTest.assertEquals((Object)new Long(0L), (Object)dt.two().getRaw("testlongcol"));
        DynamicTableTest.assertEquals((Object)new Long(0L), (Object)dt.two().getCooked("testlongcol"));
        DynamicTableTest.assertEquals((Object)new Long(0L), (Object)dt.getObject(0).getCooked("testlongcol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitBigDecimal() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testbigdecimalcol");
        columnInfo.setDisplayname("Test Big Decimal Column");
        columnInfo.setDisplayorder(199);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Big Decimal column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.BIGDECIMAL);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testbigdecimalcol").selectionWhereEq((Object)new BigDecimal(0.0))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testbigdecimalcol").selectionWhereEq((Object)new BigDecimal(0.0))).size());
        columnInfo.delete();
    }

    public void testAddColumnAndCommitString() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("teststringcol");
        columnInfo.setDisplayname("Test String Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra String column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.STRING);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("teststringcol").selectionWhereEq((Object)"default")).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("teststringcol").selectionWhereEq((Object)"default")).size());
        DynamicTableTest.assertEquals((Object)"default", (Object)dt.two().getRaw("teststringcol"));
        DynamicTableTest.assertEquals((Object)"default", (Object)dt.two().getCooked("teststringcol"));
        DynamicTableTest.assertEquals((Object)"default", (Object)dt.getObject(0).getCooked("teststringcol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitPassword() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testpasswordcol");
        columnInfo.setDisplayname("Test Password Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Password column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.PASSWORD);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testpasswordcol").selectionWhereEq((Object)"FIXME")).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testpasswordcol").selectionWhereEq((Object)"FIXME")).size());
        DynamicTableTest.assertEquals((Object)"FIXME", (Object)dt.two().getRaw("testpasswordcol"));
        DynamicTableTest.assertEquals((Object)"FIXME", (Object)dt.two().getCooked("testpasswordcol"));
        DynamicTableTest.assertEquals((Object)"FIXME", (Object)dt.getObject(0).getCooked("testpasswordcol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitDate() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testdatecol");
        columnInfo.setDisplayname("Test Date Column");
        columnInfo.setDisplayorder(199);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Date column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.DATE);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testdatecol").selectionWhereEq((Object)new Date(new java.util.Date().getTime()))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testdatecol").selectionWhereEq((Object)new Date(new java.util.Date().getTime()))).size());
        DynamicTableTest.assertEquals((String)new Date(new java.util.Date().getTime()).toString(), (String)dt.two().getRaw("testdatecol").toString());
        DynamicTableTest.assertEquals((String)new Date(new java.util.Date().getTime()).toString(), (String)dt.two().getCooked("testdatecol").toString());
        DynamicTableTest.assertEquals((String)new Date(new java.util.Date().getTime()).toString(), (String)dt.getObject(0).getCooked("testdatecol").toString());
        columnInfo.delete();
    }

    public void testAddColumnAndCommitTimestamp() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testtimestampcol");
        columnInfo.setDisplayname("Test Timestamp Column");
        columnInfo.setDisplayorder(199);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Timestamp column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.TIMESTAMP);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        Timestamp t = null;
        Enumeration en = dt.selection();
        t = (Timestamp)((Dynamic)((Object)en.nextElement())).getRaw("testtimestampcol");
        while (en.hasMoreElements()) {
            DynamicTableTest.assertEquals((Object)t, (Object)((Dynamic)((Object)en.nextElement())).getRaw("testtimestampcol"));
        }
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testtimestampcol").selectionWhereEq((Object)t)).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testtimestampcol").selectionWhereEq((Object)t)).size());
        DynamicTableTest.assertEquals((Object)t, (Object)dt.two().getRaw("testtimestampcol"));
        DynamicTableTest.assertEquals((Object)t, (Object)dt.two().getCooked("testtimestampcol"));
        DynamicTableTest.assertEquals((Object)t, (Object)dt.getObject(0).getCooked("testtimestampcol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitBinary() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testbinarycol");
        columnInfo.setDisplayname("Test Binary Column");
        columnInfo.setDisplayorder(199);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Binary column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.BINARY);
        columnInfo.setSize(8);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        byte[] t = null;
        Enumeration en = dt.selection();
        t = (byte[])((Dynamic)((Object)en.nextElement())).getRaw("testbinarycol");
        while (en.hasMoreElements()) {
            DynamicTableTest.assertEquals((int)t.length, (int)((byte[])((Dynamic)((Object)en.nextElement())).getRaw("testbinarycol")).length);
        }
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testbinarycol").selectionWhereEq((Object)t)).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testbinarycol").selectionWhereEq((Object)t)).size());
        DynamicTableTest.assertEquals((int)t.length, (int)((byte[])dt.two().getRaw("testbinarycol")).length);
        DynamicTableTest.assertEquals((int)t.length, (int)((byte[])dt.two().getCooked("testbinarycol")).length);
        DynamicTableTest.assertEquals((int)t.length, (int)((byte[])dt.getObject(0).getCooked("testbinarycol")).length);
        columnInfo.delete();
    }

    public void testAddColumnAndCommitDisplaylevel() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testdisplaylevelcol");
        columnInfo.setDisplayname("Test Displaylevel Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Displaylevel column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.DISPLAYLEVEL);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        Integer t = null;
        Enumeration en = dt.selection();
        t = (Integer)((Dynamic)((Object)en.nextElement())).getRaw("testdisplaylevelcol");
        while (en.hasMoreElements()) {
            DynamicTableTest.assertEquals((Object)t, (Object)((Dynamic)((Object)en.nextElement())).getRaw("testdisplaylevelcol"));
        }
        DisplayLevel t2 = null;
        Enumeration en2 = dt.selection();
        t2 = (DisplayLevel)((Dynamic)((Object)en2.nextElement())).getCooked("testdisplaylevelcol");
        while (en2.hasMoreElements()) {
            DynamicTableTest.assertEquals((Object)t2, (Object)((Dynamic)((Object)en2.nextElement())).getCooked("testdisplaylevelcol"));
        }
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testdisplaylevelcol").selectionWhereEq((Object)new Integer(0))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testdisplaylevelcol").selectionWhereEq((Object)new Integer(0))).size());
        DynamicTableTest.assertEquals((Object)new Integer(0), (Object)dt.two().getRaw("testdisplaylevelcol"));
        DynamicTableTest.assertEquals((Object)DisplayLevel.primary, (Object)dt.two().getCooked("testdisplaylevelcol"));
        DynamicTableTest.assertEquals((Object)DisplayLevel.primary, (Object)dt.getObject(0).getCooked("testdisplaylevelcol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitSearchability() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testsearchabilitycol");
        columnInfo.setDisplayname("Test searchability Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Searchability column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.SEARCHABILITY);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        Integer t = null;
        Enumeration en = dt.selection();
        t = (Integer)((Dynamic)((Object)en.nextElement())).getRaw("testsearchabilitycol");
        while (en.hasMoreElements()) {
            DynamicTableTest.assertEquals((Object)t, (Object)((Dynamic)((Object)en.nextElement())).getRaw("testsearchabilitycol"));
        }
        Searchability t2 = null;
        Enumeration en2 = dt.selection();
        t2 = (Searchability)((Dynamic)((Object)en2.nextElement())).getCooked("testsearchabilitycol");
        while (en2.hasMoreElements()) {
            DynamicTableTest.assertEquals((Object)t2, (Object)((Dynamic)((Object)en2.nextElement())).getCooked("testsearchabilitycol"));
        }
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testsearchabilitycol").selectionWhereEq((Object)new Integer(0))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testsearchabilitycol").selectionWhereEq((Object)new Integer(0))).size());
        DynamicTableTest.assertEquals((Object)new Integer(0), (Object)dt.two().getRaw("testsearchabilitycol"));
        DynamicTableTest.assertEquals((Object)Searchability.primary, (Object)dt.two().getCooked("testsearchabilitycol"));
        DynamicTableTest.assertEquals((Object)Searchability.primary, (Object)dt.getObject(0).getCooked("testsearchabilitycol"));
        columnInfo.delete();
    }

    public void testAddColumnAndCommitIntegrityfix() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DynamicTable<Dynamic> dt = ((EverythingDatabase)this.getDb()).getDynamicTable();
        ColumnInfo columnInfo = (ColumnInfo)this.getDb().getColumnInfoTable().newPersistent();
        TableInfo ti = dt.getTableInfo();
        columnInfo.setTableinfo(ti);
        columnInfo.setName("testintegrityfixcol");
        columnInfo.setDisplayname("Test Integrityfix Column");
        columnInfo.setDisplayorder(99);
        columnInfo.setSearchability(Searchability.yes);
        columnInfo.setIndexed(false);
        columnInfo.setUnique(false);
        columnInfo.setDescription("A non-nullable extra Integrityfix column");
        columnInfo.setUsercreateable(true);
        columnInfo.setUsereditable(true);
        columnInfo.setTypefactory(PoemTypeFactory.INTEGRITYFIX);
        columnInfo.setSize(-1);
        columnInfo.setWidth(20);
        columnInfo.setHeight(1);
        columnInfo.setPrecision(0);
        columnInfo.setScale(0);
        columnInfo.setNullable(false);
        columnInfo.setDisplaylevel(DisplayLevel.record);
        columnInfo.makePersistent();
        columnInfo.getTableinfo().actualTable().addColumnAndCommit(columnInfo);
        Integer t = null;
        Enumeration en = dt.selection();
        t = (Integer)((Dynamic)((Object)en.nextElement())).getRaw("testIntegrityfixcol");
        while (en.hasMoreElements()) {
            DynamicTableTest.assertEquals((Object)t, (Object)((Dynamic)((Object)en.nextElement())).getRaw("testIntegrityfixcol"));
        }
        IntegrityFix t2 = null;
        Enumeration en2 = dt.selection();
        t2 = (IntegrityFix)((Dynamic)((Object)en2.nextElement())).getCooked("testIntegrityfixcol");
        while (en2.hasMoreElements()) {
            DynamicTableTest.assertEquals((Object)t2, (Object)((Dynamic)((Object)en2.nextElement())).getCooked("testIntegrityfixcol"));
        }
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testIntegrityfixcol").selectionWhereEq((Object)new Integer(2))).size());
        PoemThread.commit();
        DynamicTableTest.assertEquals((int)2, (int)EnumUtils.vectorOf((Enumeration)dt.getColumn("testIntegrityfixcol").selectionWhereEq((Object)new Integer(2))).size());
        DynamicTableTest.assertEquals((Object)new Integer(2), (Object)dt.two().getRaw("testIntegrityfixcol"));
        DynamicTableTest.assertEquals((Object)StandardIntegrityFix.prevent, (Object)dt.two().getCooked("testIntegrityfixcol"));
        DynamicTableTest.assertEquals((Object)StandardIntegrityFix.prevent, (Object)dt.getObject(0).getCooked("testIntegrityfixcol"));
        columnInfo.delete();
    }
}

