/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.melati.poem.CachedQuery;
import org.melati.poem.Persistent;
import org.melati.poem.Table;
import org.melati.poem.util.MappedEnumeration;

public class CachedSelection<P extends Persistent>
extends CachedQuery<P> {
    public CachedSelection(Table<?> table, String whereClause, String orderByClause, Table<?>[] otherTables) {
        super(table, null, otherTables);
        String fromClause = table.quotedName();
        if (otherTables != null) {
            for (int i = 0; i < otherTables.length; ++i) {
                fromClause = fromClause + ", " + otherTables[i].quotedName();
            }
        }
        this.setQuery(table.selectionSQL(fromClause, whereClause, orderByClause, false, true));
    }

    public CachedSelection(Table<P> table, String whereClause, String orderByClause) {
        this(table, whereClause, orderByClause, null);
    }

    public Enumeration<Integer> troids() {
        this.compute();
        return this.rows.elements();
    }

    public Enumeration<P> objects() {
        return new MappedEnumeration<P, Integer>(this.troids()){

            @Override
            public P mapped(Integer troid) {
                return CachedSelection.this.table.getObject(troid);
            }
        };
    }

    public List<P> objectList() {
        return Collections.list(this.objects());
    }

    public Persistent firstObject() {
        return this.nth(0);
    }

    public Persistent nth(int n) {
        this.compute();
        return this.rows.size() <= n ? null : (Persistent)this.table.getObject((Integer)this.rows.elementAt(n));
    }

    public int count() {
        this.compute();
        return this.rows.size();
    }
}

