/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.melati.poem.AccessToken;
import org.melati.poem.AlreadyInSessionPoemException;
import org.melati.poem.Capability;
import org.melati.poem.CapabilityTable;
import org.melati.poem.Column;
import org.melati.poem.ColumnInfo;
import org.melati.poem.ColumnInfoTable;
import org.melati.poem.CommitLogEvent;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DuplicateTableNamePoemException;
import org.melati.poem.ExecutingSQLPoemException;
import org.melati.poem.ExtraColumn;
import org.melati.poem.Group;
import org.melati.poem.GroupCapability;
import org.melati.poem.GroupCapabilityTable;
import org.melati.poem.GroupMembership;
import org.melati.poem.GroupMembershipTable;
import org.melati.poem.GroupTable;
import org.melati.poem.JdbcTable;
import org.melati.poem.NoMoreTransactionsException;
import org.melati.poem.NoSuchTablePoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.PoemLogEvent;
import org.melati.poem.PoemTask;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTransaction;
import org.melati.poem.ReconnectionPoemException;
import org.melati.poem.SQLLogEvent;
import org.melati.poem.SQLPoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.SessionToken;
import org.melati.poem.Setting;
import org.melati.poem.SettingTable;
import org.melati.poem.StructuralModificationFailedPoemException;
import org.melati.poem.StructuralModificationLogEvent;
import org.melati.poem.Table;
import org.melati.poem.TableCategory;
import org.melati.poem.TableCategoryTable;
import org.melati.poem.TableInUsePoemException;
import org.melati.poem.TableInfo;
import org.melati.poem.TableInfoTable;
import org.melati.poem.TroidPoemType;
import org.melati.poem.UnexpectedExceptionPoemException;
import org.melati.poem.UnificationPoemException;
import org.melati.poem.User;
import org.melati.poem.UserTable;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.transaction.Transaction;
import org.melati.poem.transaction.TransactionPool;
import org.melati.poem.util.ArrayEnumeration;
import org.melati.poem.util.ArrayUtils;
import org.melati.poem.util.EnumUtils;
import org.melati.poem.util.FlattenedEnumeration;
import org.melati.poem.util.MappedEnumeration;
import org.melati.poem.util.StringUtils;

public abstract class Database
implements TransactionPool {
    final Database _this = this;
    private Vector<Transaction> transactions = null;
    private Vector<Transaction> freeTransactions = null;
    private Connection committedConnection;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private long structureSerial = 0L;
    private Vector<Table<?>> tables = new Vector();
    private Hashtable<String, Table<?>> tablesByName = new Hashtable();
    private Table<?>[] displayTables = null;
    private String name;
    private String displayName;
    private Dbms dbms;
    private boolean logSQL = false;
    private boolean logCommits = false;
    private int transactionsMax;
    private String connectionUrl;
    private int queryCount = 0;
    private String lastQuery = null;
    private boolean initialised = false;
    private final boolean[] connecting = new boolean[1];
    private User guest = null;
    private User administrator = null;
    private UserCapabilityCache capabilityCache = new UserCapabilityCache();
    private Capability canAdminister = null;

    private synchronized void init() {
        if (!this.initialised) {
            for (Table<?> t : this.tables) {
                t.init();
            }
            this.initialised = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String nameIn, String dbmsclass, String url, String username, String password, int transactionsMaxP) throws PoemException {
        this.name = nameIn;
        this.connectionUrl = url;
        boolean[] blArray = this.connecting;
        synchronized (this.connecting) {
            if (this.connecting[0]) {
                throw new ConnectingException();
            }
            this.connecting[0] = true;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            try {
                this.setDbms(DbmsFactory.getDbms(dbmsclass));
                if (this.committedConnection != null) {
                    throw new ReconnectionPoemException(this);
                }
                this.setTransactionsMax(transactionsMaxP);
                this.committedConnection = this.getDbms().getConnection(url, username, password);
                this.transactions = new Vector();
                for (int s = 0; s < this.transactionsMax(); ++s) {
                    this.transactions.add(new PoemTransaction(this, this.getDbms().getConnection(url, username, password), s));
                }
                this.freeTransactions = (Vector)this.transactions.clone();
                try {
                    this.init();
                    DatabaseMetaData m = this.committedConnection.getMetaData();
                    this.getTableInfoTable().unifyWithDB(m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(this.getTableInfoTable().getName()), null), this.dbms.unreservedName("id"));
                    this.getColumnInfoTable().unifyWithDB(m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(this.getColumnInfoTable().getName()), null), this.dbms.unreservedName("id"));
                    this.getTableCategoryTable().unifyWithDB(m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(this.getTableCategoryTable().getName()), null), this.dbms.unreservedName("id"));
                    this.inSession(AccessToken.root, new PoemTask(){

                        @Override
                        public void run() throws PoemException {
                            try {
                                Database.this._this.unifyWithDB();
                            }
                            catch (SQLException e) {
                                throw new SQLPoemException(e);
                            }
                        }

                        public String toString() {
                            return "Unifying with DB";
                        }
                    });
                }
                catch (SQLException e) {
                    if (this.committedConnection != null) {
                        this.disconnect();
                    }
                    throw new UnificationPoemException(e);
                }
            }
            catch (SQLPoemException e) {
                if (this.committedConnection != null) {
                    this.disconnect();
                }
                throw e;
            }
            finally {
                boolean[] blArray2 = this.connecting;
                synchronized (this.connecting) {
                    this.connecting[0] = false;
                    // ** MonitorExit[var11_15] (shouldn't be in output)
                }
            }
            return;
        }
    }

    public void disconnect() throws PoemException {
        if (this.committedConnection == null) {
            throw new ReconnectionPoemException(this);
        }
        try {
            for (Transaction poemTransaction : this.freeTransactions) {
                ((PoemTransaction)poemTransaction).getConnection().close();
            }
            this.freeTransactions.removeAllElements();
            this.getDbms().shutdown(this.committedConnection);
            this.committedConnection.close();
        }
        catch (SQLException e) {
            throw new SQLPoemException(e);
        }
        this.committedConnection = null;
    }

    protected synchronized void defineTable(Table<?> table) throws DuplicateTableNamePoemException {
        if (this.getTableIgnoringCase(table.getName()) != null) {
            throw new DuplicateTableNamePoemException(this, table.getName());
        }
        this.redefineTable(table);
    }

    protected synchronized void redefineTable(Table<?> table) {
        if (table.getDatabase() != this) {
            throw new TableInUsePoemException(this, table);
        }
        if (this.getTableIgnoringCase(table.getName()) == null) {
            this.tablesByName.put(table.getName().toLowerCase(), table);
            this.tables.addElement(table);
        } else {
            this.tables.setElementAt(table, this.tables.indexOf(this.tablesByName.put(table.getName().toLowerCase(), table)));
        }
        this.displayTables = null;
    }

    private ResultSet columnsMetadata(DatabaseMetaData m, String tableName) throws SQLException {
        return m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(tableName), null);
    }

    public Table<?> addTableAndCommit(TableInfo info, String troidName) throws PoemException {
        JdbcTable table = new JdbcTable(this, info.getName(), DefinitionSource.infoTables);
        table.defineColumn(new ExtraColumn<Integer>(table, troidName, TroidPoemType.it, DefinitionSource.infoTables, table.getNextExtrasIndex()));
        table.setTableInfo(info);
        table.unifyWithColumnInfo();
        table.unifyWithDB(null, troidName);
        PoemThread.commit();
        this.defineTable(table);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTableAndCommit(TableInfo info) {
        try {
            Table<?> table = info.actualTable();
            Enumeration<Column<?>> columns = table.columns();
            while (columns.hasMoreElements()) {
                Column<?> c = columns.nextElement();
                table.deleteColumnAndCommit(c.getColumnInfo());
            }
            info.delete();
            this.beginStructuralModification();
            table.dbModifyStructure(" DROP TABLE " + table.quotedName());
            Vector<Table<?>> vector = this.tables;
            synchronized (vector) {
                this.tables.remove(table);
                this.tablesByName.remove(table.getName().toLowerCase());
                if (this.displayTables != null) {
                    this.displayTables = (Table[])ArrayUtils.removed(this.displayTables, table);
                }
                this.uncache();
                table.invalidateTransactionStuffs();
            }
            PoemThread.commit();
        }
        finally {
            this.endStructuralModification();
        }
    }

    private String getTroidColumnName(DatabaseMetaData m, String tableName) throws SQLException {
        String troidColumnName = null;
        ResultSet tables = m.getTables(null, this.dbms.getSchema(), this.dbms.unreservedName(tableName), null);
        if (tables.next()) {
            ResultSet r = m.getPrimaryKeys(null, this.dbms.getSchema(), this.dbms.unreservedName(tableName));
            while (r.next()) {
                troidColumnName = r.getString("COLUMN_NAME");
            }
            r.close();
            if (troidColumnName != null) {
                this.log(this.dbms.getJdbcMetadataName(this.dbms.unreservedName(troidColumnName)));
                ResultSet idCol = m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(tableName), this.dbms.getJdbcMetadataName(this.dbms.unreservedName(troidColumnName)));
                this.log("Discovered a primary key troid candidate column for jdbc table :" + tableName + ":" + troidColumnName);
                if (idCol.next()) {
                    if (this.dbms.canRepresent(this.defaultPoemTypeOfColumnMetaData(idCol), TroidPoemType.it) == null) {
                        if (troidColumnName.equals("id")) {
                            throw new UnificationPoemException("Primary Key " + troidColumnName + " cannot represent a Troid");
                        }
                        this.log("Column " + troidColumnName + " cannot represent troid as it has type " + this.defaultPoemTypeOfColumnMetaData(idCol));
                        ResultSet u = m.getIndexInfo(null, this.dbms.getSchema(), this.dbms.unreservedName(tableName), true, false);
                        String unusableKey = troidColumnName;
                        troidColumnName = null;
                        String uniqueKey = null;
                        String foundKey = null;
                        while (u.next()) {
                            uniqueKey = u.getString("COLUMN_NAME");
                            if (uniqueKey.equals(unusableKey)) continue;
                            ResultSet idColNotPrimeKey = m.getColumns(null, this.dbms.getSchema(), this.dbms.unreservedName(tableName), this.dbms.getJdbcMetadataName(this.dbms.unreservedName(uniqueKey)));
                            if (idColNotPrimeKey.next()) {
                                if (idColNotPrimeKey.getInt("NULLABLE") != 0) {
                                    idColNotPrimeKey.close();
                                    break;
                                }
                                SQLPoemType<?> t = this.defaultPoemTypeOfColumnMetaData(idColNotPrimeKey);
                                if (this.dbms.canRepresent(t, TroidPoemType.it) == null) {
                                    this.log("Unique Column " + uniqueKey + " cannot represent troid as it has type " + t);
                                    uniqueKey = null;
                                }
                                if (uniqueKey != null) {
                                    if (foundKey != null) {
                                        idColNotPrimeKey.close();
                                        throw new UnificationPoemException("Second unique, non-nullable numeric index found :" + uniqueKey + " already found " + foundKey);
                                    }
                                    this.log("Unique Column " + uniqueKey + " can represent troid as it has type " + t);
                                    foundKey = uniqueKey;
                                }
                            } else {
                                throw new UnexpectedExceptionPoemException("Found a unique key but no corresponding column");
                            }
                            idColNotPrimeKey.close();
                            troidColumnName = uniqueKey;
                        }
                        u.close();
                    }
                } else {
                    throw new UnexpectedExceptionPoemException("Found a primary key but no corresponding column");
                }
                idCol.close();
            }
            tables.close();
        }
        return troidColumnName;
    }

    private synchronized void unifyWithDB() throws PoemException, SQLException {
        boolean debug = false;
        Enumeration ti = this.getTableInfoTable().selection();
        while (ti.hasMoreElements()) {
            TableInfo tableInfo = (TableInfo)ti.nextElement();
            Table<?> table = this.getTableIgnoringCase(tableInfo.getName());
            if (table == null) {
                if (debug) {
                    this.log("Defining table:" + tableInfo.getName());
                }
                table = new JdbcTable(this, tableInfo.getName(), DefinitionSource.infoTables);
                this.defineTable(table);
            }
            table.setTableInfo(tableInfo);
        }
        for (Table<?> t : this.tables) {
            t.createTableInfo();
        }
        for (Table<?> t : this.tables) {
            t.unifyWithColumnInfo();
        }
        String[] normalTables = new String[]{"TABLE"};
        DatabaseMetaData m = this.committedConnection.getMetaData();
        ResultSet tableDescs = m.getTables(null, this.dbms.getSchema(), null, normalTables);
        while (tableDescs.next()) {
            if (debug) {
                this.log("Table:" + tableDescs.getString("TABLE_NAME") + " Type:" + tableDescs.getString("TABLE_TYPE"));
            }
            String tableName = this.dbms.melatiName(tableDescs.getString("TABLE_NAME"));
            if (debug) {
                this.log("Melati Table name :" + tableName);
            }
            Table<?> table = null;
            String troidColumnName = null;
            if (tableName != null) {
                table = this.getTableIgnoringCase(tableName);
                if (table == null) {
                    if (debug) {
                        this.log("Unknown to POEM, with JDBC name " + tableName);
                    }
                    troidColumnName = this.getTroidColumnName(m, this.dbms.unreservedName(tableName));
                    if (debug) {
                        this.log("Primary key:" + troidColumnName);
                    }
                    if (troidColumnName != null) {
                        if (debug) {
                            this.log("Got a troid column for discovered jdbc table :" + tableName + ":" + troidColumnName);
                        }
                        try {
                            table = new JdbcTable(this, tableName, DefinitionSource.sqlMetaData);
                            this.defineTable(table);
                        }
                        catch (DuplicateTableNamePoemException e) {
                            throw new UnexpectedExceptionPoemException(e);
                        }
                        table.createTableInfo();
                    } else {
                        this.log("Ignoring table " + tableName + " as it has no plausible troid");
                    }
                } else if (debug) {
                    this.log("Table not null:" + tableName + " has name " + table.getName());
                }
            }
            if (table != null) {
                if (debug) {
                    this.log("table not null now:" + tableName);
                }
                if (debug) {
                    this.log("columnsMetadata(m, tableName):" + this.columnsMetadata(m, tableName));
                }
                table.unifyWithDB(this.columnsMetadata(m, tableName), troidColumnName);
                continue;
            }
            if (!debug) continue;
            this.log("table still null, probably doesn't have a troid:" + tableName);
        }
        for (Table<?> table : this.tables) {
            ResultSet colDescs;
            if (debug) {
                this.log("Unifying:" + table.getName() + "(" + this.dbms.unreservedName(table.getName()) + ")");
            }
            if ((colDescs = this.columnsMetadata(m, this.dbms.unreservedName(table.getName()))).next()) continue;
            table.unifyWithDB(null, this.getTroidColumnName(m, this.dbms.unreservedName(table.getName())));
        }
        for (Table<?> table : this.tables) {
            table.postInitialise();
        }
    }

    public void addConstraints() {
        this.inSession(AccessToken.root, new PoemTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws PoemException {
                PoemThread.commit();
                Database.this.beginStructuralModification();
                try {
                    for (Table table : Database.this.tables) {
                        table.dbAddConstraints();
                    }
                    PoemThread.commit();
                }
                finally {
                    Database.this.endStructuralModification();
                }
            }

            public String toString() {
                return "Adding constraints to DB";
            }
        });
    }

    @Override
    public final int transactionsMax() {
        return this.transactionsMax;
    }

    @Override
    public final void setTransactionsMax(int t) {
        this.transactionsMax = t;
    }

    @Override
    public int getTransactionsCount() {
        return this.transactions.size();
    }

    @Override
    public int getFreeTransactionsCount() {
        return this.freeTransactions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoemTransaction openTransaction() {
        Vector<Transaction> vector = this.freeTransactions;
        synchronized (vector) {
            if (this.freeTransactions.size() == 0) {
                throw new NoMoreTransactionsException("Database " + this.name + " has no free transactions remaining of " + this.transactions.size() + " transactions.");
            }
            PoemTransaction transaction = (PoemTransaction)this.freeTransactions.lastElement();
            this.freeTransactions.setSize(this.freeTransactions.size() - 1);
            return transaction;
        }
    }

    void notifyClosed(PoemTransaction transaction) {
        this.freeTransactions.addElement(transaction);
    }

    public PoemTransaction poemTransaction(int index) {
        return (PoemTransaction)this.transactions.elementAt(index);
    }

    @Override
    public final Transaction transaction(int index) {
        return this.poemTransaction(index);
    }

    public boolean isFree(PoemTransaction trans) {
        return this.freeTransactions.contains(trans);
    }

    public void beginExclusiveLock() {
        if (PoemThread.inSession()) {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
    }

    public void endExclusiveLock() {
        this.lock.writeLock().unlock();
        if (PoemThread.inSession()) {
            this.lock.readLock().lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perform(AccessToken accessToken, final PoemTask task, boolean useCommittedTransaction) throws PoemException {
        this.lock.readLock().lock();
        final PoemTransaction transaction = useCommittedTransaction ? null : this.openTransaction();
        try {
            PoemThread.inSession(new PoemTask(){

                @Override
                public void run() throws PoemException {
                    task.run();
                    if (transaction != null) {
                        transaction.close(true);
                    }
                }

                public String toString() {
                    return task.toString();
                }
            }, accessToken, transaction);
        }
        finally {
            try {
                if (transaction != null && !this.isFree(transaction)) {
                    transaction.close(false);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    public void inSession(AccessToken accessToken, PoemTask task) {
        this.perform(accessToken, task, false);
    }

    public void inSessionAsRoot(PoemTask task) {
        this.perform(AccessToken.root, task, false);
    }

    public void beginSession(AccessToken accessToken) {
        this.lock.readLock().lock();
        PoemTransaction transaction = this.openTransaction();
        try {
            PoemThread.beginSession(accessToken, transaction);
        }
        catch (AlreadyInSessionPoemException e) {
            this.notifyClosed(transaction);
            this.lock.readLock().unlock();
            throw e;
        }
    }

    public void endSession() {
        PoemTransaction tx = PoemThread.sessionToken().transaction;
        PoemThread.endSession();
        tx.close(true);
        this.lock.readLock().unlock();
    }

    public void inCommittedTransaction(AccessToken accessToken, PoemTask task) {
        this.perform(accessToken, task, true);
    }

    public final Table<?> getTable(String tableName) throws NoSuchTablePoemException {
        Table<?> table = this.getTableIgnoringCase(tableName);
        if (table == null) {
            throw new NoSuchTablePoemException(this, tableName);
        }
        return table;
    }

    private Table<?> getTableIgnoringCase(String tableName) {
        return this.tablesByName.get(tableName.toLowerCase());
    }

    public final Enumeration<Table<?>> tables() {
        return this.tables.elements();
    }

    public final List<Table<?>> getTables() {
        return this.tables;
    }

    public Enumeration<Table<?>> displayTables() {
        return this.displayTables(PoemThread.inSession() ? PoemThread.transaction() : null);
    }

    public List<Table<?>> getDisplayTables() {
        return EnumUtils.list(this.displayTables());
    }

    public Enumeration<Table<?>> displayTables(PoemTransaction transaction) {
        Object[] displayTablesL = this.displayTables;
        if (displayTablesL == null) {
            Enumeration<Integer> tableIDs = this.getTableInfoTable().troidSelection(null, this.quotedName("displayorder") + ", " + this.quotedName("name"), false, transaction);
            Vector them = new Vector();
            while (tableIDs.hasMoreElements()) {
                Table<?> table = this.tableWithTableInfoID(tableIDs.nextElement());
                if (table == null) continue;
                them.addElement(table);
            }
            displayTablesL = new Table[them.size()];
            them.copyInto(displayTablesL);
            this.displayTables = displayTablesL;
        }
        return new ArrayEnumeration(this.displayTables);
    }

    Table<?> tableWithTableInfoID(int tableInfoID) {
        for (Table<?> table : this.tables) {
            Integer id = table.tableInfoID();
            if (id == null || id != tableInfoID) continue;
            return table;
        }
        return null;
    }

    public Enumeration<Column<?>> columns() {
        return new FlattenedEnumeration(new MappedEnumeration<Enumeration<Column<?>>, Table<?>>(this.tables()){

            @Override
            public Enumeration<Column<?>> mapped(Table<?> table) {
                return table.columns();
            }
        });
    }

    public List<Column<?>> getColumns() {
        return EnumUtils.list(this.columns());
    }

    public int tableCount() {
        return this.tables.size();
    }

    public int columnCount() {
        return this.getColumns().size();
    }

    public int recordCount() {
        MappedEnumeration counts = new MappedEnumeration<Integer, Table<?>>(this.tables()){

            @Override
            public Integer mapped(Table<?> table) {
                return new Integer(table.count());
            }
        };
        int total = 0;
        while (counts.hasMoreElements()) {
            total += ((Integer)counts.nextElement()).intValue();
        }
        return total;
    }

    Column<?> columnWithColumnInfoID(int columnInfoID) {
        for (Table<?> table : this.tables) {
            Column<?> column = table.columnWithColumnInfoID(columnInfoID);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    public abstract TableInfoTable<TableInfo> getTableInfoTable();

    public abstract TableCategoryTable<TableCategory> getTableCategoryTable();

    public abstract ColumnInfoTable<ColumnInfo> getColumnInfoTable();

    public abstract CapabilityTable<Capability> getCapabilityTable();

    public abstract UserTable<User> getUserTable();

    public abstract GroupTable<Group> getGroupTable();

    public abstract GroupMembershipTable<GroupMembership> getGroupMembershipTable();

    public abstract GroupCapabilityTable<GroupCapability> getGroupCapabilityTable();

    public abstract SettingTable<Setting> getSettingTable();

    public ResultSet sqlQuery(String sql) throws SQLPoemException {
        SessionToken token = PoemThread.sessionToken();
        token.transaction.writeDown();
        try {
            Statement s = token.transaction.getConnection().createStatement();
            token.toTidy().add(s);
            ResultSet rs = s.executeQuery(sql);
            token.toTidy().add(rs);
            if (this.logSQL()) {
                this.log(new SQLLogEvent(sql));
            }
            this.incrementQueryCount(sql);
            return rs;
        }
        catch (SQLException e) {
            throw new ExecutingSQLPoemException(sql, e);
        }
    }

    public int sqlUpdate(String sql) throws SQLPoemException {
        SessionToken token = PoemThread.sessionToken();
        token.transaction.writeDown();
        try {
            Statement s = token.transaction.getConnection().createStatement();
            token.toTidy().add(s);
            int n = s.executeUpdate(sql);
            if (this.logSQL()) {
                this.log(new SQLLogEvent(sql));
            }
            this.incrementQueryCount(sql);
            return n;
        }
        catch (SQLException e) {
            throw this.dbms.exceptionForUpdate(null, sql, sql.indexOf("INSERT") >= 0 || sql.indexOf("insert") >= 0, e);
        }
    }

    public User guestUser() {
        if (this.guest == null) {
            this.guest = this.getUserTable().guestUser();
        }
        return this.guest;
    }

    public User administratorUser() {
        if (this.administrator == null) {
            this.administrator = this.getUserTable().administratorUser();
        }
        return this.administrator;
    }

    public String givesCapabilitySQL(User user, Capability capability) {
        return this.dbms.givesCapabilitySQL(user.troid(), capability.troid().toString());
    }

    private boolean dbGivesCapability(User user, Capability capability) {
        String sql = this.givesCapabilitySQL(user, capability);
        ResultSet rs = null;
        try {
            rs = this.sqlQuery(sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLPoemException e) {
            throw new UnexpectedExceptionPoemException(e);
        }
        catch (SQLException e) {
            throw new SQLSeriousPoemException(e, sql);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                System.err.println("Cannot close resultset after exception.");
            }
        }
    }

    public boolean hasCapability(User user, Capability capability) {
        if (capability == null) {
            return true;
        }
        return this.capabilityCache.hasCapability(user, capability);
    }

    public AccessToken guestAccessToken() {
        return this.getUserTable().guestUser();
    }

    public Capability administerCapability() {
        return this.getCapabilityTable().administer();
    }

    public Capability getCanAdminister() {
        return this.canAdminister;
    }

    public void setCanAdminister() {
        this.canAdminister = this.administerCapability();
    }

    public void setCanAdminister(String capabilityName) {
        this.canAdminister = this.getCapabilityTable().ensure(capabilityName);
    }

    public void trimCache(int maxSize) {
        for (Table<?> table : this.tables) {
            table.trimCache(maxSize);
        }
    }

    public void uncache() {
        for (int t = 0; t < this.tables.size(); ++t) {
            this.tables.elementAt(t).uncache();
        }
    }

    public <P extends Persistent> Enumeration<P> referencesTo(final Persistent persistent) {
        return new FlattenedEnumeration(new MappedEnumeration(this.tables()){

            public Object mapped(Object table) {
                return ((Table)table).referencesTo(persistent);
            }
        });
    }

    public List<Persistent> getReferencesTo(Persistent persistent) {
        return EnumUtils.list(this.referencesTo(persistent));
    }

    public Enumeration<Column<?>> referencesTo(final Table<?> tableIn) {
        return new FlattenedEnumeration(new MappedEnumeration<Enumeration<Column<?>>, Table<?>>(this.tables()){

            @Override
            public Enumeration<Column<?>> mapped(Table<?> table) {
                return table.referencesTo(tableIn);
            }
        });
    }

    public List<Column<?>> getReferencesTo(Table<?> table) {
        return EnumUtils.list(this.referencesTo(table));
    }

    public void dumpCacheAnalysis() {
        for (Table<?> table : this.tables) {
            table.dumpCacheAnalysis();
        }
    }

    public void dump() {
        for (int t = 0; t < this.tables.size(); ++t) {
            System.out.println();
            this.tables.elementAt(t).dump();
        }
        System.err.println("there are " + this.getTransactionsCount() + " transactions " + "of which " + this.getFreeTransactionsCount() + " are free");
    }

    public Dbms getDbms() {
        return this.dbms;
    }

    private void setDbms(Dbms aDbms) {
        this.dbms = aDbms;
    }

    public final String quotedName(String nameIn) {
        return this.getDbms().getQuotedName(nameIn);
    }

    final SQLPoemType<?> defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        return this.getDbms().defaultPoemTypeOfColumnMetaData(md);
    }

    public String toString() {
        if (this.connectionUrl == null) {
            return "unconnected database";
        }
        return this.connectionUrl;
    }

    public Connection getCommittedConnection() {
        return this.committedConnection;
    }

    public boolean logSQL() {
        return this.logSQL;
    }

    public void setLogSQL(boolean value) {
        this.logSQL = value;
    }

    public boolean logCommits() {
        return this.logCommits;
    }

    public void setLogCommits(boolean value) {
        this.logCommits = value;
    }

    void log(PoemLogEvent e) {
        System.err.println("---\n" + e.toString());
    }

    void log(String s) {
        System.err.println(s);
    }

    protected void beginStructuralModification() {
        this.beginExclusiveLock();
    }

    protected void endStructuralModification() {
        for (int t = 0; t < this.tables.size(); ++t) {
            this.tables.elementAt(t).uncache();
        }
        ++this.structureSerial;
        this.endExclusiveLock();
    }

    long structureSerial() {
        return this.structureSerial;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void incrementQueryCount(String sql) {
        this.lastQuery = sql;
        ++this.queryCount;
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return StringUtils.capitalised(this.getName());
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void modifyStructure(String sql) throws StructuralModificationFailedPoemException {
        if (PoemThread.inSession()) {
            PoemThread.commit();
        }
        try {
            this.log("Modifying structure:" + sql);
            Statement updateStatement = this.getCommittedConnection().createStatement();
            updateStatement.executeUpdate(sql);
            updateStatement.close();
            this.getCommittedConnection().commit();
            if (this.logCommits()) {
                this.log(new CommitLogEvent(null));
            }
            if (this.logSQL()) {
                this.log(new StructuralModificationLogEvent(sql));
            }
            this.incrementQueryCount(sql);
        }
        catch (SQLException e) {
            throw new StructuralModificationFailedPoemException(sql, e);
        }
    }

    private class UserCapabilityCache {
        private Hashtable<Long, Boolean> userCapabilities = null;
        private long groupMembershipSerial;
        private long groupCapabilitySerial;

        private UserCapabilityCache() {
        }

        boolean hasCapability(User user, Capability capability) {
            Long pair;
            Boolean known;
            PoemTransaction transaction = PoemThread.transaction();
            long currentGroupMembershipSerial = Database.this.getGroupMembershipTable().serial(transaction);
            long currentGroupCapabilitySerial = Database.this.getGroupCapabilityTable().serial(transaction);
            if (this.userCapabilities == null || this.groupMembershipSerial != currentGroupMembershipSerial || this.groupCapabilitySerial != currentGroupCapabilitySerial) {
                this.userCapabilities = new Hashtable();
                this.groupMembershipSerial = currentGroupMembershipSerial;
                this.groupCapabilitySerial = currentGroupCapabilitySerial;
            }
            if ((known = this.userCapabilities.get(pair = new Long(user.troid().longValue() << 32 | capability.troid().longValue()))) != null) {
                return known;
            }
            boolean does = Database.this.dbGivesCapability(user, capability);
            this.userCapabilities.put(pair, does ? Boolean.TRUE : Boolean.FALSE);
            return does;
        }
    }

    public class ConnectingException
    extends PoemException {
        private static final long serialVersionUID = 1L;

        @Override
        public String getMessage() {
            return "Connection to the database is currently in progress; please try again in a moment";
        }
    }
}

