/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.ColumnInfo;
import org.melati.poem.IndexPoemType;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PersistentReferencePoemType;
import org.melati.poem.PoemException;
import org.melati.poem.PoemLocale;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Table;
import org.melati.poem.TableMismatchPoemException;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.ValidationPoemException;
import org.melati.poem.util.StringUtils;

public class ReferencePoemType
extends IndexPoemType
implements PersistentReferencePoemType {
    private Table<?> targetTable;

    public ReferencePoemType(Table<?> targetTable, boolean nullable) {
        super(nullable);
        if (targetTable == null) {
            throw new NullPointerException();
        }
        this.targetTable = targetTable;
    }

    @Override
    public Table<?> targetTable() {
        return this.targetTable;
    }

    @Override
    protected Enumeration<Integer> _possibleRaws() {
        return this.targetTable.troidSelection(null, null, false);
    }

    @Override
    protected void _assertValidCooked(Object cooked) throws ValidationPoemException {
        if (!(cooked instanceof Persistent)) {
            throw new TypeMismatchPoemException(cooked, this);
        }
        Persistent persistent = (Persistent)cooked;
        if (persistent.getTable() != this.targetTable) {
            throw new ValidationPoemException(this, persistent, new TableMismatchPoemException(persistent, this.targetTable));
        }
    }

    @Override
    protected Object _cookedOfRaw(Object raw) throws NoSuchRowPoemException {
        return this.targetTable.getObject((Integer)raw);
    }

    @Override
    protected Integer _rawOfCooked(Object cooked) {
        return ((Persistent)cooked).troid();
    }

    @Override
    protected String _stringOfCooked(Object cooked, PoemLocale locale, int style) throws PoemException {
        return ((Persistent)cooked).displayString(locale, style);
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        return other instanceof PersistentReferencePoemType && ((PersistentReferencePoemType)((Object)other)).targetTable() == this.targetTable();
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactoryCode(this.targetTable.tableInfoID());
    }

    @Override
    public String toString() {
        return "reference to " + this.targetTable.getName() + " (" + super.toString() + ")";
    }

    @Override
    public String toDsdType() {
        return StringUtils.capitalised(this.targetTable.getName());
    }
}

