/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import org.melati.poem.AccessPoemException;
import org.melati.poem.AppBugPoemException;
import org.melati.poem.Field;
import org.melati.poem.FieldAttributes;
import org.melati.poem.PoemException;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.generated.SettingBase;

public class Setting
extends SettingBase {
    private FieldAttributes<?> valueAttributes = null;
    private Object raw = null;
    private Object cooked = null;

    public Setting() {
    }

    public Setting(Integer typefactory, String name, String value, String displayname, String description) {
        this.setTypefactory_unsafe(typefactory);
        this.setName_unsafe(name);
        this.setValue_unsafe(value);
        this.setDisplayname_unsafe(displayname);
        this.setDescription_unsafe(description);
        this.setUsereditable_unsafe(Boolean.TRUE);
        this.setNullable_unsafe(Boolean.TRUE);
        this.setSize_unsafe(new Integer(-1));
        this.setWidth_unsafe(new Integer(20));
        this.setHeight_unsafe(new Integer(1));
        this.setPrecision_unsafe(new Integer(22));
        this.setScale_unsafe(new Integer(2));
    }

    @Override
    public void setValue(String value) {
        Object rawLocal;
        try {
            rawLocal = this.getType().rawOfString(value);
        }
        catch (Exception e) {
            throw new SettingValidationException(this.getName_unsafe(), e);
        }
        super.setValue(value);
        this.raw = rawLocal;
        this.cooked = null;
    }

    public void setRaw(Object raw) {
        Object newRaw;
        String string;
        try {
            string = this.getType().stringOfRaw(raw);
        }
        catch (Exception e) {
            throw new SettingValidationException(this.getName_unsafe(), e);
        }
        try {
            newRaw = this.getType().rawOfString(string);
        }
        catch (Exception e) {
            throw new SettingValidationException(this.getName_unsafe(), e);
        }
        super.setValue(newRaw == null ? null : string);
        this.raw = newRaw;
        this.cooked = null;
    }

    public Object getRaw() {
        if (this.raw == null) {
            try {
                this.raw = this.getType().rawOfString(this.getValue());
            }
            catch (Exception e) {
                throw new SettingValidationException(this.getName_unsafe(), e);
            }
        }
        return this.raw;
    }

    public Object getCooked() {
        if (this.cooked == null) {
            this.cooked = this.getType().cookedOfRaw(this.getRaw());
        }
        return this.cooked;
    }

    public Integer getIntegerCooked() {
        Object cookedLocal = this.getCooked();
        if (cookedLocal == null && this.getNullable().booleanValue()) {
            return null;
        }
        if (cookedLocal instanceof Integer) {
            return (Integer)cookedLocal;
        }
        throw new SettingTypeMismatchException(this.getName_unsafe(), this.getTypefactory(), "Integer");
    }

    public String getStringCooked() {
        Object cookedLocal = this.getCooked();
        if (cookedLocal == null && this.getNullable().booleanValue()) {
            return null;
        }
        if (cookedLocal instanceof String) {
            return (String)cookedLocal;
        }
        throw new SettingTypeMismatchException(this.getName_unsafe(), this.getTypefactory(), "String");
    }

    public Boolean getBooleanCooked() {
        Object cookedLocal = this.getCooked();
        if (cookedLocal == null && this.getNullable().booleanValue()) {
            return null;
        }
        if (cookedLocal instanceof Boolean) {
            return (Boolean)cookedLocal;
        }
        throw new SettingTypeMismatchException(this.getName_unsafe(), this.getTypefactory(), "Boolean");
    }

    private FieldAttributes valueFieldAttributes() {
        if (this.valueAttributes == null) {
            this.valueAttributes = this.fieldAttributesRenamedAs(this.getSettingTable().getValueColumn());
        }
        return this.valueAttributes;
    }

    public Field getValueField() {
        try {
            return new Field(this.getRaw(), this.valueFieldAttributes());
        }
        catch (AccessPoemException accessException) {
            return new Field(accessException, this.valueFieldAttributes());
        }
    }

    @Override
    public void postEdit(boolean creating) {
        super.postEdit(creating);
        this.valueAttributes = null;
    }

    public static class SettingTypeMismatchException
    extends AppBugPoemException {
        private static final long serialVersionUID = 1L;
        public String name;
        public PoemTypeFactory type;
        public String reqType;

        public SettingTypeMismatchException(String name, PoemTypeFactory type, String reqType) {
            this.name = name;
            this.type = type;
            this.reqType = reqType;
        }

        @Override
        public String getMessage() {
            return "The setting `" + this.name + "' has type `" + this.type + "' but " + "the application asked for a value of type " + this.reqType;
        }
    }

    public static class SettingValidationException
    extends PoemException {
        private static final long serialVersionUID = 1L;
        public String name;

        public SettingValidationException(String name, Exception problem) {
            super(problem);
            this.name = name;
        }

        @Override
        public String getMessage() {
            return "A problem arose updating the value of the `" + this.name + "' setting:\n" + this.subException.getMessage();
        }
    }
}

