/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.DatePoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.dbms.test.DbmsSpec;

public class MimerTest
extends DbmsSpec {
    public MimerTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void setObjectUnderTest() {
        this.it = DbmsFactory.getDbms((String)"org.melati.poem.dbms.Mimer");
    }

    @Override
    public void testGetStringSqlDefinition() throws Exception {
        MimerTest.assertEquals((String)"VARCHAR(2500)", (String)this.it.getStringSqlDefinition(-1));
        MimerTest.assertEquals((String)"VARCHAR(0)", (String)this.it.getStringSqlDefinition(0));
    }

    @Override
    public void testGetSqlDefinition() throws Exception {
        MimerTest.assertEquals((String)"INT", (String)this.it.getSqlDefinition("BOOLEAN"));
        MimerTest.assertEquals((String)"DOUBLE PRECISION", (String)this.it.getSqlDefinition("DOUBLE PRECISION"));
        MimerTest.assertEquals((String)"INT8", (String)this.it.getSqlDefinition("INT8"));
        MimerTest.assertEquals((String)"Big Decimal", (String)this.it.getSqlDefinition("Big Decimal"));
    }

    @Override
    public void testCanRepresent() {
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)StringPoemType.nullableInstance, (PoemType)IntegerPoemType.nullableInstance));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)IntegerPoemType.nullableInstance, (PoemType)StringPoemType.nullableInstance));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new BigDecimalPoemType(false), (PoemType)new BigDecimalPoemType(true)));
        MimerTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BigDecimalPoemType(true), (PoemType)new BigDecimalPoemType(false)) instanceof BigDecimalPoemType));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new StringPoemType(true, 255), (PoemType)new StringPoemType(true, -1)));
        MimerTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, 2500), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        MimerTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, -1), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new TimestampPoemType(true), (PoemType)new DatePoemType(true)));
        MimerTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BooleanPoemType(true), (PoemType)new BooleanPoemType(false)) instanceof BooleanPoemType));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(false), (PoemType)new BigDecimalPoemType(true)));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(true), (PoemType)new BigDecimalPoemType(false)));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new IntegerPoemType(false), (PoemType)new LongPoemType(true)));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new IntegerPoemType(true), (PoemType)new LongPoemType(false)));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new BinaryPoemType(false, 10), (PoemType)new BinaryPoemType(true, 10)));
        MimerTest.assertNull((Object)this.it.canRepresent((PoemType)new BinaryPoemType(true, 10), (PoemType)new BinaryPoemType(true, 11)));
        MimerTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BinaryPoemType(true, -1), (PoemType)new BinaryPoemType(true, -1)) instanceof BinaryPoemType));
        MimerTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BinaryPoemType(true, 2500), (PoemType)new BinaryPoemType(true, 10)) instanceof BinaryPoemType));
        MimerTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new IntegerPoemType(true), (PoemType)new BooleanPoemType(true)) instanceof BooleanPoemType));
    }
}

