/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import org.melati.poem.AccessToken;
import org.melati.poem.CreationAccessPoemException;
import org.melati.poem.DeletePersistentAccessPoemException;
import org.melati.poem.DeletionIntegrityPoemException;
import org.melati.poem.DoubleCreatePoemException;
import org.melati.poem.Field;
import org.melati.poem.InvalidOperationOnFloatingPersistentPoemException;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.JdbcTable;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemLocale;
import org.melati.poem.PoemThread;
import org.melati.poem.RowDisappearedPoemException;
import org.melati.poem.Setting;
import org.melati.poem.TableCategory;
import org.melati.poem.TableInfo;
import org.melati.poem.User;
import org.melati.poem.WritePersistentAccessPoemException;
import org.melati.poem.test.EverythingTestCase;

public class PersistentTest
extends EverythingTestCase {
    public PersistentTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInvalidate() {
        this.getDb().uncache();
        JdbcPersistent p = (JdbcPersistent)this.getDb().getUserTable().newPersistent();
        try {
            p.invalidate();
            PersistentTest.fail((String)"Should have blown up");
        }
        catch (InvalidOperationOnFloatingPersistentPoemException e2) {
            Object e2 = null;
        }
        int hits = this.getDb().getQueryCount();
        int hits2 = this.getDb().getQueryCount();
        this.getDb().getUserTable().guestUser();
        this.getDb().getUserTable().guestUser();
        int hits3 = this.getDb().getQueryCount();
        this.getDb().uncache();
        int hits4 = this.getDb().getQueryCount();
        this.getDb().getUserTable().guestUser();
        int hits5 = this.getDb().getQueryCount();
        PersistentTest.assertTrue((hits == hits2 ? 1 : 0) != 0);
        PersistentTest.assertTrue((hits == hits3 ? 1 : 0) != 0);
        PersistentTest.assertTrue((hits == hits4 ? 1 : 0) != 0);
        PersistentTest.assertTrue((hits == hits5 ? 1 : 0) != 0);
        this.getDb().getUserTable().count();
        int countHits1 = this.getDb().getQueryCount();
        PersistentTest.assertEquals((int)(hits5 + 1), (int)countHits1);
        this.getDb().getUserTable().count();
        int countHits2 = this.getDb().getQueryCount();
        PersistentTest.assertEquals((int)(countHits1 + 1), (int)countHits2);
        this.getDb().getUserTable().selection();
        int selectionHits1 = this.getDb().getQueryCount();
        this.getDb().getUserTable().selection();
        int selectionHits2 = this.getDb().getQueryCount();
        PersistentTest.assertEquals((int)selectionHits1, (int)selectionHits2);
        this.getDb().uncache();
        this.getDb().getUserTable().selection();
        int selectionHits3 = this.getDb().getQueryCount();
        PersistentTest.assertEquals((int)(selectionHits2 + 1), (int)selectionHits3);
        this.getDb().getUserTable().getUserObject(0);
        int getHits1 = this.getDb().getQueryCount();
        PersistentTest.assertEquals((int)(selectionHits3 + 1), (int)getHits1);
        this.getDb().uncache();
        this.getDb().getUserTable().getUserObject(0);
        int getHits2 = this.getDb().getQueryCount();
        PersistentTest.assertEquals((int)(getHits1 + 1), (int)getHits2);
        Persistent p2 = this.getDb().getUserTable().newPersistent();
        p2.setCooked("name", (Object)"testuser");
        p2.setCooked("login", (Object)"testuser");
        p2.setCooked("password", (Object)"testuser");
        p2.makePersistent();
        int getHits3 = this.getDb().getQueryCount();
        PersistentTest.assertEquals((int)(getHits2 + 3), (int)getHits3);
        p2.delete();
        PoemThread.commit();
    }

    public void testPersistent() {
    }

    public void testPersistentStringString() {
        JdbcPersistent p = new JdbcPersistent("user", "0");
        try {
            p.makePersistent();
            PersistentTest.fail((String)"Should have blown up");
        }
        catch (DoubleCreatePoemException e2) {
            Object e2 = null;
        }
        p = new JdbcPersistent((JdbcTable)this.getDb().getUserTable(), new Integer(2));
        try {
            p.makePersistent();
            PersistentTest.fail((String)"Should have blown up");
        }
        catch (DoubleCreatePoemException e) {
            Object var2_5 = null;
        }
    }

    public void testPersistentTableInteger() {
        JdbcPersistent p = new JdbcPersistent((JdbcTable)this.getDb().getUserTable(), new Integer(0));
        try {
            p.makePersistent();
            PersistentTest.fail((String)"Should have blown up");
        }
        catch (DoubleCreatePoemException e2) {
            Object e2 = null;
        }
        p = new JdbcPersistent((JdbcTable)this.getDb().getUserTable(), new Integer(2));
        try {
            p.makePersistent();
            PersistentTest.fail((String)"Should have blown up");
        }
        catch (DoubleCreatePoemException e) {
            Object var2_5 = null;
        }
    }

    public void testSetStatusNonexistent() {
    }

    public void testSetStatusExistent() {
    }

    public void testStatusNonexistent() {
    }

    public void testStatusExistent() {
    }

    public void testMakePersistent() {
    }

    public void testGetTable() {
    }

    public void testSetTable() {
    }

    public void testGetDatabase() {
        JdbcPersistent p = new JdbcPersistent((JdbcTable)this.getDb().getUserTable(), new Integer(0));
        PersistentTest.assertEquals((Object)p.getDatabase(), (Object)this.getDb());
    }

    public void testTroid() {
        JdbcPersistent p = new JdbcPersistent();
        PersistentTest.assertNull((Object)p.troid());
        p = new JdbcPersistent((JdbcTable)this.getDb().getUserTable(), new Integer(0));
        PersistentTest.assertEquals((Object)p.troid(), (Object)new Integer(0));
    }

    public void testGetTroid() {
        JdbcPersistent p = new JdbcPersistent();
        PersistentTest.assertNull((Object)p.getTroid());
        p = new JdbcPersistent((JdbcTable)this.getDb().getUserTable(), new Integer(0));
        PersistentTest.assertEquals((Object)p.getTroid(), (Object)new Integer(0));
    }

    public void testExistenceLock() {
        JdbcPersistent p = new JdbcPersistent();
        p.existenceLock();
        try {
            p.delete();
            PersistentTest.fail((String)"Should have blown up");
        }
        catch (InvalidOperationOnFloatingPersistentPoemException e) {
            Object var2_3 = null;
        }
    }

    public void testAssertCanWriteAccessToken() {
        User p = this.getDb().getUserTable().guestUser();
        User g = this.getDb().getUserTable().guestUser();
        try {
            p.assertCanWrite((AccessToken)g);
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (WritePersistentAccessPoemException e2) {
            Object e2 = null;
        }
        User a = this.getDb().getUserTable().administratorUser();
        p.assertCanWrite((AccessToken)a);
    }

    public void testAssertCanWrite() {
        User p = this.getDb().getUserTable().administratorUser();
        User g = this.getDb().getUserTable().guestUser();
        p.assertCanWrite();
        try {
            PoemThread.setAccessToken((AccessToken)g);
            p.assertCanWrite();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (WritePersistentAccessPoemException e) {
            Object var3_4 = null;
        }
    }

    public void testAssertCanDeleteAccessToken() {
        User p = this.getDb().getUserTable().guestUser();
        User g = this.getDb().getUserTable().guestUser();
        try {
            p.assertCanDelete((AccessToken)g);
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (DeletePersistentAccessPoemException e2) {
            Object e2 = null;
        }
        User a = this.getDb().getUserTable().administratorUser();
        p.assertCanDelete((AccessToken)a);
    }

    public void testAssertCanDelete() {
        User p = this.getDb().getUserTable().administratorUser();
        User g = this.getDb().getUserTable().guestUser();
        p.assertCanDelete();
        try {
            PoemThread.setAccessToken((AccessToken)g);
            p.assertCanDelete();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (DeletePersistentAccessPoemException e) {
            Object var3_4 = null;
        }
    }

    public void testAssertCanCreateAccessToken() {
        User p = this.getDb().getUserTable().guestUser();
        User g = this.getDb().getUserTable().guestUser();
        try {
            p.assertCanCreate((AccessToken)g);
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (CreationAccessPoemException e2) {
            Object e2 = null;
        }
        User a = this.getDb().getUserTable().administratorUser();
        p.assertCanWrite((AccessToken)a);
    }

    public void testAssertCanCreate() {
        User p = this.getDb().getUserTable().administratorUser();
        User g = this.getDb().getUserTable().guestUser();
        p.assertCanCreate();
        try {
            PoemThread.setAccessToken((AccessToken)g);
            p.assertCanCreate();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (CreationAccessPoemException e) {
            Object var3_4 = null;
        }
    }

    public void testGetRaw() {
        User p = this.getDb().getUserTable().administratorUser();
        String name = (String)p.getRaw("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name);
        Integer id = (Integer)p.getRaw("id");
        PersistentTest.assertEquals((Object)new Integer(1), (Object)id);
    }

    public void testGetRawString() {
        User p = this.getDb().getUserTable().administratorUser();
        String name = p.getRawString("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name);
        String id = p.getRawString("id");
        PersistentTest.assertEquals((String)"1", (String)id);
    }

    public void testSetRaw() {
        User p = this.getDb().getUserTable().administratorUser();
        String name = p.getRawString("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name);
        p.setRaw("name", (Object)"test");
        String name2 = p.getRawString("name");
        PersistentTest.assertEquals((String)"test", (String)name2);
        p.setRaw("name", (Object)name);
        String name3 = p.getRawString("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name3);
    }

    public void testSetRawString() {
        User p = this.getDb().getUserTable().administratorUser();
        String name = p.getRawString("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name);
        p.setRawString("name", "test");
        String name2 = p.getRawString("name");
        PersistentTest.assertEquals((String)"test", (String)name2);
        p.setRawString("name", name);
        String name3 = p.getRawString("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name3);
    }

    public void testGetCooked() {
        User p = this.getDb().getUserTable().administratorUser();
        String name = (String)p.getCooked("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name);
        p = this.getDb().getUserTable().getTableInfo();
        TableCategory c = (TableCategory)p.getCooked("category");
        PersistentTest.assertEquals((String)"tableCategory/0", (String)c.toString());
    }

    public void testGetCookedString() {
        User p = this.getDb().getUserTable().administratorUser();
        String name = p.getCookedString("name", PoemLocale.HERE, 2);
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name);
        TableInfo p2 = this.getDb().getUserTable().getTableInfo();
        String c = p2.getCookedString("category", PoemLocale.HERE, 2);
        PersistentTest.assertEquals((String)"User", (String)c);
    }

    public void testSetCooked() {
        User p = this.getDb().getUserTable().administratorUser();
        String name = p.getRawString("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name);
        p.setCooked("name", (Object)"test");
        String name2 = p.getRawString("name");
        PersistentTest.assertEquals((String)"test", (String)name2);
        p.setCooked("name", (Object)name);
        String name3 = p.getRawString("name");
        PersistentTest.assertEquals((String)"Melati database administrator", (String)name3);
        TableInfo p2 = this.getDb().getUserTable().getTableInfo();
        TableCategory c = (TableCategory)p2.getCooked("category");
        TableCategory c2 = (TableCategory)this.getDb().getTableCategoryTable().newPersistent();
        c2.setName("Test");
        c2.makePersistent();
        p2.setCooked("category", (Object)c2);
        String cString = p2.getCookedString("category", PoemLocale.HERE, 2);
        PersistentTest.assertEquals((String)"Test", (String)cString);
        p2.setCooked("category", (Object)c);
        cString = p2.getCookedString("category", PoemLocale.HERE, 2);
        PersistentTest.assertEquals((String)"User", (String)cString);
        c2.delete();
    }

    public void testGetField() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        Field f = p.getField("user");
        PersistentTest.assertEquals((String)"user: Melati database administrator", (String)f.toString());
    }

    public void testFieldsOfColumns() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        Enumeration fields = p.fieldsOfColumns(p.getTable().columns());
        Field f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"id: 0", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"user: Melati database administrator", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"group: Melati database administrators", (String)f.toString());
    }

    public void testGetFields() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        Enumeration fields = p.getFields();
        Field f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"id: 0", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"user: Melati database administrator", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"group: Melati database administrators", (String)f.toString());
    }

    public void testGetRecordDisplayFields() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        Enumeration fields = p.getRecordDisplayFields();
        Field f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"user: Melati database administrator", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"group: Melati database administrators", (String)f.toString());
    }

    public void testGetDetailDisplayFields() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        Enumeration fields = p.getDetailDisplayFields();
        Field f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"id: 0", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"user: Melati database administrator", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"group: Melati database administrators", (String)f.toString());
    }

    public void testGetSummaryDisplayFields() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        Enumeration fields = p.getSummaryDisplayFields();
        Field f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"user: Melati database administrator", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"group: Melati database administrators", (String)f.toString());
    }

    public void testGetSearchCriterionFields() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        Enumeration fields = p.getSearchCriterionFields();
        Field f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"id: 0", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"user: Melati database administrator", (String)f.toString());
        f = (Field)fields.nextElement();
        PersistentTest.assertEquals((String)"group: Melati database administrators", (String)f.toString());
    }

    public void testGetPrimaryDisplayField() {
    }

    public void testDeleteMap() {
        TableInfo ti = this.getDb().getUserTable().getTableInfo();
        try {
            ti.delete();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (DeletionIntegrityPoemException e) {
            Object var2_3 = null;
        }
    }

    public void testDelete() {
        Object e2;
        Persistent p = this.getDb().getCapabilityTable().newPersistent();
        try {
            p.delete();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (InvalidOperationOnFloatingPersistentPoemException e2) {
            e2 = null;
        }
        p.setCooked("name", (Object)"testCapability");
        p.makePersistent();
        PersistentTest.assertEquals((Object)"testCapability", (Object)p.getCooked("name"));
        p.delete();
        try {
            p.delete();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (RowDisappearedPoemException e3) {
            e2 = null;
        }
        try {
            this.getDb().getGroupTable().getObject(p.getTroid());
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (NoSuchRowPoemException e4) {
            e2 = null;
        }
        PoemThread.rollback();
        try {
            this.getDb().getGroupTable().getObject(p.getTroid());
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (NoSuchRowPoemException e5) {
            e2 = null;
        }
        p = this.getDb().getGroupTable().newPersistent();
        p.setCooked("name", (Object)"testGroup");
        p.makePersistent();
        PersistentTest.assertEquals((Object)"testGroup", (Object)p.getCooked("name"));
        PoemThread.commit();
        p.delete();
        try {
            p.delete();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (RowDisappearedPoemException e6) {
            e2 = null;
        }
        try {
            this.getDb().getGroupTable().getObject(p.getTroid());
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (NoSuchRowPoemException e7) {
            e2 = null;
        }
        this.getDb().setLogCommits(true);
        PoemThread.rollback();
        this.getDb().setLogCommits(false);
        this.getDb().getGroupTable().getObject(p.getTroid());
        PersistentTest.assertEquals((Object)"testGroup", (Object)p.getCooked("name"));
        p.delete();
        try {
            p.delete();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (RowDisappearedPoemException e8) {
            e2 = null;
        }
        try {
            this.getDb().getGroupTable().getObject(1);
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (NoSuchRowPoemException e9) {
            Object var2_11 = null;
        }
        this.getDb().setLogCommits(true);
        PoemThread.commit();
        this.getDb().setLogCommits(false);
    }

    public void testDelete_unsafe() {
        Object e2;
        Persistent p = this.getDb().getGroupTable().newPersistent();
        try {
            p.delete_unsafe();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (InvalidOperationOnFloatingPersistentPoemException e2) {
            e2 = null;
        }
        p.setCooked("name", (Object)"test");
        p.makePersistent();
        PersistentTest.assertEquals((Object)"test", (Object)p.getCooked("name"));
        p.delete_unsafe();
        try {
            p.delete_unsafe();
        }
        catch (RowDisappearedPoemException e3) {
            e2 = null;
        }
        try {
            this.getDb().getGroupTable().getObject(2);
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (NoSuchRowPoemException e4) {
            Object var2_6 = null;
        }
    }

    public void testDeleteAndCommit() {
        Object e2;
        Persistent p = this.getDb().getGroupTable().newPersistent();
        try {
            p.deleteAndCommit();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (InvalidOperationOnFloatingPersistentPoemException e2) {
            e2 = null;
        }
        p.setCooked("name", (Object)"test");
        p.makePersistent();
        PersistentTest.assertEquals((Object)"test", (Object)p.getCooked("name"));
        p.deleteAndCommit();
        try {
            p.deleteAndCommit();
        }
        catch (RowDisappearedPoemException e3) {
            e2 = null;
        }
        try {
            this.getDb().getGroupTable().getObject(3);
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (NoSuchRowPoemException e4) {
            Object var2_6 = null;
        }
    }

    public void testDeleteAndCommitMap() {
        Persistent p = this.getDb().getGroupTable().newPersistent();
        try {
            p.deleteAndCommit(null);
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (InvalidOperationOnFloatingPersistentPoemException e2) {
            Object e2 = null;
        }
        p.setCooked("name", (Object)"test");
        p.makePersistent();
        PersistentTest.assertEquals((Object)"test", (Object)p.getCooked("name"));
        Integer troid = p.getTroid();
        p.deleteAndCommit(null);
        try {
            p.deleteAndCommit(null);
        }
        catch (RowDisappearedPoemException e3) {
            Object e3 = null;
        }
        try {
            this.getDb().getGroupTable().getObject(troid);
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (NoSuchRowPoemException e) {
            Object var3_7 = null;
        }
    }

    public void testDuplicated() {
        Persistent p = this.getDb().getGroupTable().getObject(0);
        Persistent p2 = p.duplicated();
        PersistentTest.assertFalse((boolean)p.equals(p2));
        try {
            p2.duplicated();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (InvalidOperationOnFloatingPersistentPoemException e) {
            Object var3_4 = null;
        }
    }

    public void testDuplicatedFloating() {
        Persistent p = this.getDb().getGroupTable().getObject(0);
        Persistent p2 = p.duplicatedFloating();
        PersistentTest.assertFalse((boolean)p.equals(p2));
        Persistent p3 = p2.duplicatedFloating();
        PersistentTest.assertTrue((boolean)p2.equals(p3));
    }

    public void testToString() {
        Persistent p = this.getDb().getGroupMembershipTable().getObject(0);
        PersistentTest.assertEquals((String)"groupMembership/0", (String)p.toString());
    }

    public void testDisplayStringPoemLocaleInt() {
        Persistent p = this.getDb().getGroupTable().getObject(0);
        PersistentTest.assertEquals((String)"Melati database administrators", (String)p.displayString(PoemLocale.HERE, 2));
    }

    public void testDisplayStringPoemLocale() {
        Persistent p = this.getDb().getGroupTable().getObject(0);
        PersistentTest.assertEquals((String)"Melati database administrators", (String)p.displayString(PoemLocale.HERE));
    }

    public void testDisplayString() {
        Persistent p = this.getDb().getGroupTable().getObject(0);
        PersistentTest.assertEquals((String)"Melati database administrators", (String)p.displayString());
    }

    public void testHashCode() {
        User p = this.getDb().getUserTable().guestUser();
        PersistentTest.assertEquals((int)2645995, (int)p.hashCode());
        try {
            p = this.getDb().getUserTable().newPersistent();
            p.hashCode();
            PersistentTest.fail((String)"Should have bombed");
        }
        catch (InvalidOperationOnFloatingPersistentPoemException e) {
            Object var2_3 = null;
        }
    }

    public void testEqualsObject() {
        Persistent p = this.getDb().getGroupTable().getObject(0);
        PersistentTest.assertTrue((boolean)p.equals(p));
        Persistent p2 = this.getDb().getGroupTable().newPersistent();
        PersistentTest.assertTrue((boolean)p2.equals(p2));
        PersistentTest.assertFalse((boolean)p.equals(p2));
        PersistentTest.assertFalse((boolean)p.equals(null));
        PersistentTest.assertFalse((boolean)p.equals(new Integer(0)));
        p2.setRaw("id", (Object)new Integer(0));
        PersistentTest.assertFalse((boolean)p.equals(p2));
    }

    public void testDump() {
        JdbcPersistent p = new JdbcPersistent((JdbcTable)this.getDb().getUserTable(), new Integer(0));
        String d = null;
        try {
            d = p.dump();
            PersistentTest.fail((String)"Should have blown up");
        }
        catch (ClassCastException e2) {
            Object e2 = null;
        }
        PersistentTest.assertNull((Object)d);
        User u = (User)this.getDb().getUserTable().newPersistent();
        d = u.dump();
        PersistentTest.assertTrue((String)d, (boolean)d.startsWith("User/null"));
        u = this.getDb().getUserTable().guestUser();
        d = u.dump();
        PersistentTest.assertTrue((String)d, (boolean)d.startsWith("User/0"));
        Setting stringSetting = this.getDb().getSettingTable().ensure("stringSetting", "set", "String", "A set string setting");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        stringSetting.dump(ps);
        PersistentTest.assertTrue((boolean)baos.toString().startsWith("setting/"));
        stringSetting.delete();
    }

    public void testDumpPrintStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            JdbcPersistent p = new JdbcPersistent((JdbcTable)this.getDb().getUserTable(), new Integer(0));
            p.dump(ps);
            PersistentTest.fail((String)"Should have blown up");
        }
        catch (ClassCastException e2) {
            Object e2 = null;
        }
        PersistentTest.assertEquals((String)baos.toString(), (String)"User/0\n  ", (String)baos.toString());
        baos = new ByteArrayOutputStream();
        ps = new PrintStream(baos);
        User u = (User)this.getDb().getUserTable().newPersistent();
        u.dump(ps);
        PersistentTest.assertTrue((boolean)baos.toString().startsWith("User/null"));
        u = this.getDb().getUserTable().guestUser();
        baos = new ByteArrayOutputStream();
        ps = new PrintStream(baos);
        u.dump(ps);
        PersistentTest.assertTrue((boolean)baos.toString().startsWith("User/0"));
    }

    public void testPostWrite() {
        User p = this.getDb().getUserTable().guestUser();
        p.postWrite();
    }

    public void testPostInsert() {
        User p = this.getDb().getUserTable().guestUser();
        p.postInsert();
    }

    public void testPostModify() {
        User p = this.getDb().getUserTable().guestUser();
        p.postModify();
    }

    public void testPreEdit() {
        User p = this.getDb().getUserTable().guestUser();
        p.preEdit();
    }

    public void testPostEdit() {
        User p = this.getDb().getUserTable().guestUser();
        p.postEdit(true);
        p.postEdit(false);
    }

    public void testToStringNull() {
        JdbcPersistent unit = new JdbcPersistent();
        PersistentTest.assertEquals((String)"null/null", (String)unit.toString());
    }

    public void testEqualsNull() {
        JdbcPersistent unitOne = new JdbcPersistent();
        JdbcPersistent unitTwo = new JdbcPersistent();
        PersistentTest.assertTrue((boolean)unitOne.equals(unitTwo));
    }
}

