/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test.throwing;

import java.sql.ResultSet;
import org.melati.poem.Database;
import org.melati.poem.PoemDatabaseFactory;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.dbms.test.sql.Thrower;

public class ResultSetEnumerationTest
extends org.melati.poem.test.ResultSetEnumerationTest {
    public ResultSetEnumerationTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        PoemDatabaseFactory.removeDatabase((String)this.getDatabaseName());
        super.setUp();
        ResultSetEnumerationTest.assertEquals((String)"org.melati.poem.dbms.test.HsqldbThrower", (String)this.getDb().getDbms().getClass().getName());
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            PoemDatabaseFactory.removeDatabase((String)this.getDatabaseName());
        }
    }

    @Override
    public Database getDatabase(String name) {
        this.maxTrans = 4;
        Database db = PoemDatabaseFactory.getDatabase((String)name, (String)("jdbc:hsqldb:mem:" + name), (String)"sa", (String)"", (String)"org.melati.poem.PoemDatabase", (String)"org.melati.poem.dbms.test.HsqldbThrower", (boolean)false, (boolean)false, (boolean)false, (int)this.maxTrans);
        return db;
    }

    @Override
    public void testHasMoreElements() {
        Thrower.startThrowing(ResultSet.class, (String)"close");
        try {
            super.testHasMoreElements();
            ResultSetEnumerationTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            ResultSetEnumerationTest.assertEquals((String)"ResultSet bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(ResultSet.class, (String)"close");
        Thrower.startThrowing(ResultSet.class, (String)"next");
        try {
            super.testHasMoreElements();
            ResultSetEnumerationTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            ResultSetEnumerationTest.assertEquals((String)"ResultSet bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(ResultSet.class, (String)"next");
    }

    @Override
    public void testNextElement() {
        Thrower.startThrowing(ResultSet.class, (String)"close");
        try {
            super.testNextElement();
            ResultSetEnumerationTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            ResultSetEnumerationTest.assertEquals((String)"ResultSet bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(ResultSet.class, (String)"close");
        Thrower.startThrowing(ResultSet.class, (String)"next");
        try {
            super.testNextElement();
            ResultSetEnumerationTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            ResultSetEnumerationTest.assertEquals((String)"ResultSet bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(ResultSet.class, (String)"next");
    }

    @Override
    public void testResultSetEnumeration() {
        super.testResultSetEnumeration();
    }

    @Override
    public void testSkip() {
        Thrower.startThrowing(ResultSet.class, (String)"next");
        try {
            super.testSkip();
            ResultSetEnumerationTest.fail((String)"Should have bombed");
        }
        catch (SQLSeriousPoemException e) {
            ResultSetEnumerationTest.assertEquals((String)"ResultSet bombed", (String)e.innermostException().getMessage());
        }
        Thrower.stopThrowing(ResultSet.class, (String)"next");
    }
}

