/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.util.Enumeration;
import junit.framework.TestCase;
import org.melati.poem.AccessToken;
import org.melati.poem.Capability;
import org.melati.poem.Database;
import org.melati.poem.PoemDatabase;
import org.melati.poem.PoemThread;
import org.melati.poem.ReconnectionPoemException;
import org.melati.poem.TableCategoryTable;
import org.melati.poem.TableInfo;
import org.melati.poem.util.EnumUtils;

public class DatabaseTest
extends TestCase {
    private static PoemDatabase db;

    public DatabaseTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private static Database getDb() {
        if (db != null) {
            return db;
        }
        db = new PoemDatabase();
        db.connect("m2", "org.melati.poem.dbms.Hsqldb", "jdbc:hsqldb:mem:m2", "sa", "", 8);
        DatabaseTest.assertEquals((int)8, (int)db.getFreeTransactionsCount());
        DatabaseTest.assertTrue((boolean)db.getClass().getName().equals("org.melati.poem.PoemDatabase"));
        return db;
    }

    public void testDatabase() {
    }

    public void testConnect() {
        try {
            DatabaseTest.getDb().connect("m2", "org.melati.poem.dbms.Hsqldb", "jdbc:hsqldb:mem:m2", "sa", "", 8);
            DatabaseTest.fail((String)"Should have blown up");
        }
        catch (ReconnectionPoemException e) {
            Object var1_2 = null;
        }
        DatabaseTest.assertTrue((db.getClass().getName() == "org.melati.poem.PoemDatabase" ? 1 : 0) != 0);
        DatabaseTest.assertEquals((int)8, (int)db.getFreeTransactionsCount());
        db.disconnect();
        DatabaseTest.assertEquals((int)0, (int)db.getFreeTransactionsCount());
        db = null;
    }

    public void testDisconnect() {
    }

    public void testShutdown() {
    }

    public void testAddTableAndCommit() {
    }

    public void testDeleteTableAndCommit() {
        String name = "abouttodie";
        DatabaseTest.getDb().beginSession(AccessToken.root);
        TableInfo tableInfo = (TableInfo)DatabaseTest.getDb().getTableInfoTable().newPersistent();
        tableInfo.setName(name);
        tableInfo.setDisplayname(name);
        tableInfo.setDescription(String.valueOf(name) + " element table");
        tableInfo.setDisplayorder(13);
        tableInfo.setSeqcached(Boolean.FALSE);
        tableInfo.setCategory(TableCategoryTable.NORMAL);
        tableInfo.setCachelimit(555);
        tableInfo.makePersistent();
        DatabaseTest.assertEquals((int)9, (int)EnumUtils.vectorOf((Enumeration)DatabaseTest.getDb().tables()).size());
        DatabaseTest.getDb().addTableAndCommit(tableInfo, "troid");
        DatabaseTest.assertEquals((int)10, (int)EnumUtils.vectorOf((Enumeration)DatabaseTest.getDb().tables()).size());
        DatabaseTest.getDb().deleteTableAndCommit(tableInfo);
        DatabaseTest.assertEquals((int)9, (int)EnumUtils.vectorOf((Enumeration)DatabaseTest.getDb().tables()).size());
        DatabaseTest.getDb().endSession();
    }

    public void testAddConstraints() {
        DatabaseTest.getDb().addConstraints();
    }

    public void testTransactionsMax() {
    }

    public void testSetTransactionsMax() {
    }

    public void testGetTransactionsCount() {
    }

    public void testGetFreeTransactionsCount() {
    }

    public void testPoemTransaction() {
    }

    public void testTransaction() {
    }

    public void testIsFree() {
    }

    public void testBeginExclusiveLock() {
    }

    public void testEndExclusiveLock() {
    }

    public void testInSession() {
    }

    public void testBeginSession() {
    }

    public void testEndSession() {
        DatabaseTest.getDb().beginSession(AccessToken.root);
        DatabaseTest.assertEquals((int)PoemThread.database().getTransactionsCount(), (int)(PoemThread.database().getFreeTransactionsCount() + 1));
        DatabaseTest.getDb().endSession();
    }

    public void testInCommittedTransaction() {
    }

    public void testGetTable() {
    }

    public void testTables() {
    }

    public void testGetTables() {
        DatabaseTest.assertEquals((int)9, (int)DatabaseTest.getDb().getTables().size());
    }

    public void testGetDisplayTables() {
    }

    public void testColumns() {
    }

    public void testGetColumns() {
        DatabaseTest.assertEquals((int)69, (int)DatabaseTest.getDb().getColumns().size());
    }

    public void testGetTableInfoTable() {
    }

    public void testGetTableCategoryTable() {
    }

    public void testGetColumnInfoTable() {
    }

    public void testGetCapabilityTable() {
    }

    public void testGetUserTable() {
    }

    public void testGetGroupTable() {
    }

    public void testGetGroupMembershipTable() {
    }

    public void testGetGroupCapabilityTable() {
    }

    public void testGetSettingTable() {
    }

    public void testSqlQuery() {
    }

    public void testSqlUpdate() {
    }

    public void testGuestUser() {
    }

    public void testAdministratorUser() {
    }

    public void testGivesCapabilitySQL() {
    }

    public void testHasCapability() {
    }

    public void testGuestAccessToken() {
    }

    public void testAdministerCapability() {
        Capability c = DatabaseTest.getDb().administerCapability();
        DatabaseTest.assertEquals((String)"_administer_", (String)c.toString());
    }

    public void testGetCanAdminister() {
    }

    public void testSetCanAdminister() {
    }

    public void testSetCanAdministerString() {
    }

    public void testTrimCache() {
    }

    public void testUncacheContents() {
    }

    public void testReferencesToPersistent() {
    }

    public void testGetReferencesToPersistent() {
    }

    public void testReferencesToTable() {
    }

    public void testDumpCacheAnalysis() {
    }

    public void testDump() {
    }

    public void testGetDbms() {
    }

    public void testQuotedName() {
    }

    public void testToString() {
    }

    public void testGetCommittedConnection() {
    }

    public void testLogSQL() {
    }

    public void testSetLogSQL() {
    }

    public void testLogCommits() {
    }

    public void testSetLogCommits() {
    }

    public void testGetQueryCount() {
    }

    public void testIncrementQueryCount() {
    }

    public void testGetName() {
        DatabaseTest.assertEquals((String)"m2", (String)DatabaseTest.getDb().getName());
    }

    public void testGetDisplayName() {
        DatabaseTest.assertEquals((String)"M2", (String)DatabaseTest.getDb().getDisplayName());
    }
}

