/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTransaction;
import org.melati.poem.PreparedStatementFactory;
import org.melati.poem.SQLSeriousPoemException;
import org.melati.poem.SessionToken;
import org.melati.poem.Table;

public abstract class CachedQuery<T> {
    protected PreparedStatementFactory statements = null;
    protected Vector<Integer> rows = null;
    private long tableSerial;
    protected Table<?> table;
    private String query;
    private Table<?>[] otherTables;
    private long[] otherTablesSerial;

    public CachedQuery(Table<?> table, String query, Table<?>[] otherTables) {
        this.table = table;
        this.query = query;
        this.otherTables = otherTables;
        if (otherTables != null) {
            this.otherTablesSerial = new long[otherTables.length];
        }
    }

    protected PreparedStatementFactory statements() {
        if (this.statements == null) {
            this.statements = new PreparedStatementFactory(this.table.getDatabase(), this.query);
        }
        return this.statements;
    }

    protected Integer extract(ResultSet rs) throws SQLException {
        return new Integer(rs.getInt(1));
    }

    protected void compute() {
        Vector<Integer> rowsLocal = this.rows;
        SessionToken token = PoemThread.sessionToken();
        if (rowsLocal == null || this.somethingHasChanged(token.transaction)) {
            rowsLocal = new Vector();
            try {
                ResultSet rs = this.statements().resultSet(token);
                try {
                    while (rs.next()) {
                        rowsLocal.addElement(this.extract(rs));
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e2) {
                        Object e2 = null;
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLSeriousPoemException(e);
            }
            this.rows = rowsLocal;
            this.updateSerials(token.transaction);
        }
    }

    private boolean somethingHasChanged(PoemTransaction transaction) {
        if (this.table.serial(transaction) != this.tableSerial) {
            return true;
        }
        if (this.otherTables != null) {
            int i = 0;
            while (i < this.otherTables.length) {
                if (this.otherTables[i].serial(transaction) != this.otherTablesSerial[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void updateSerials(PoemTransaction transaction) {
        this.tableSerial = this.table.serial(transaction);
        if (this.otherTables != null) {
            int i = 0;
            while (i < this.otherTables.length) {
                this.otherTablesSerial[i] = this.otherTables[i].serial(transaction);
                ++i;
            }
        }
    }

    public Table<?> getTable() {
        return this.table;
    }

    protected void setQuery(String query) {
        this.query = query;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.query;
    }
}

