/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.csv;

import java.util.Vector;
import org.melati.poem.Persistent;
import org.melati.poem.PoemThread;
import org.melati.poem.Table;
import org.melati.poem.csv.CSVField;
import org.melati.poem.csv.CSVWriteDownException;
import org.melati.poem.csv.NoPrimaryKeyInCSVTableException;

public class CSVRecord {
    private Vector<CSVField> fields;
    String primaryKeyValue = null;
    Table<?> table = null;
    Persistent poemRecord = null;
    private int lineNo;
    private int recordNo;

    public CSVRecord(Table<?> table) {
        this.table = table;
        this.fields = new Vector();
    }

    public synchronized void addField(CSVField field) {
        if (field.column.isPrimaryKey) {
            this.primaryKeyValue = field.value;
        }
        this.fields.addElement(field);
    }

    /*
     * Unable to fully structure code
     */
    private void createPersistent() throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        if (this.poemRecord != null) {
            return;
        }
        newObj = this.table.newPersistent();
        j = 0;
        while (j < this.fields.size()) {
            col = this.fields.elementAt((int)j).column;
            csvValue = this.fields.elementAt((int)j).value;
            if (col.foreignTable == null) {
                if (col.poemName != null) {
                    try {
                        if (csvValue == null || csvValue.equals("")) ** GOTO lbl25
                        newObj.setRawString(col.poemName, csvValue);
                    }
                    catch (Exception e) {
                        throw new CSVWriteDownException(this.table.getName(), this.getLineNo(), new RuntimeException("Problem processing column " + col.poemName + " of table " + this.table.getName() + " on line " + this.getLineNo() + " value :" + csvValue + ": " + e.toString()));
                    }
                }
            } else if (csvValue == null || csvValue.trim().equals("")) {
                if (!newObj.getTable().getColumn(col.poemName).getColumnInfo().getNullable().booleanValue()) {
                    throw new RuntimeException("CSV value missing for required column " + col.poemName + " of table " + this.table.getName() + " on line " + this.getLineNo());
                }
            } else {
                lookup = col.foreignTable.getRecordWithID(csvValue);
                if (lookup == null) {
                    throw new RuntimeException("No persistent found with primary key " + csvValue + " for column " + col.poemName + " of table " + this.table.getName() + " on line " + this.getLineNo());
                }
                newObj.setCooked(col.poemName, lookup);
            }
lbl25:
            // 5 sources

            ++j;
        }
        this.poemRecord = newObj;
    }

    public Persistent getPersistent() throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        if (this.poemRecord != null) {
            return this.poemRecord;
        }
        this.createPersistent();
        return this.poemRecord;
    }

    void makePersistent() throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        try {
            this.getPersistent();
            this.poemRecord.makePersistent();
        }
        catch (NoPrimaryKeyInCSVTableException e1) {
            throw e1;
        }
        catch (CSVWriteDownException e2) {
            throw e2;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(String.valueOf(e.toString()) + " in table " + this.table.getName() + " on line " + this.getLineNo());
        }
        if (PoemThread.inSession()) {
            PoemThread.writeDown();
        }
        PoemThread.commit();
    }

    public void setRecordNo(int recordNo) {
        this.recordNo = recordNo;
    }

    public int getRecordNo() {
        return this.recordNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public Vector<CSVField> getFields() {
        return this.fields;
    }
}

