/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AtomPoemType;
import org.melati.poem.ColumnInfo;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.ParsingPoemException;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.SQLPoemType;
import org.melati.poem.TypeMismatchPoemException;
import org.melati.poem.dbms.Dbms;
import org.melati.poem.util.LongEnumeration;

public class LongPoemType
extends AtomPoemType<Long> {
    public static final LongPoemType nullableInstance = new LongPoemType(true);

    public LongPoemType(boolean nullable) {
        super(-5, "INT8", nullable);
    }

    protected LongPoemType(int sqlTypeCode, String sqlTypeName, boolean nullable) {
        super(sqlTypeCode, sqlTypeName, nullable);
    }

    @Override
    protected Enumeration<Long> _possibleRaws() {
        Long low = (Long)this.getLowRaw();
        Long limit = (Long)this.getLimitRaw();
        return low == null ? null : new LongEnumeration(low, limit == null ? Long.MAX_VALUE : limit);
    }

    @Override
    protected void _assertValidRaw(Object raw) {
        if (raw != null && !(raw instanceof Long)) {
            throw new TypeMismatchPoemException(raw, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long _getRaw(ResultSet rs, int col) throws SQLException {
        ResultSet resultSet = rs;
        synchronized (resultSet) {
            long i = rs.getLong(col);
            return i == 0L && rs.wasNull() ? null : new Long(i);
        }
    }

    @Override
    protected void _setRaw(PreparedStatement ps, int col, Object integer) throws SQLException {
        ps.setLong(col, (Long)integer);
    }

    @Override
    protected Long _rawOfString(String rawString) throws ParsingPoemException {
        try {
            return new Long(rawString);
        }
        catch (NumberFormatException e) {
            throw new ParsingPoemException(this, rawString, e);
        }
    }

    @Override
    protected String _sqlDefinition(Dbms dbms) {
        return dbms.getLongSqlDefinition();
    }

    @Override
    protected boolean _canRepresent(SQLPoemType<?> other) {
        if (other instanceof LongPoemType) {
            return true;
        }
        return other instanceof IntegerPoemType;
    }

    @Override
    public String toDsdType() {
        return "Long";
    }

    @Override
    protected void _saveColumnInfo(ColumnInfo columnInfo) throws AccessPoemException {
        columnInfo.setTypefactory(PoemTypeFactory.LONG);
    }
}

