/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem;

import java.util.Hashtable;
import org.melati.poem.PoemException;

public final class Searchability {
    public final Integer index;
    private final String name;
    public static final Searchability primary;
    public static final Searchability yes;
    public static final Searchability no;
    private static int n;
    private static final Searchability[] searchabilities;
    private static final Hashtable<String, Searchability> searchabilityOfName;

    static {
        n = 0;
        searchabilities = new Searchability[]{primary = new Searchability(n++, "primary"), yes = new Searchability(n++, "yes"), no = new Searchability(n++, "no")};
        searchabilityOfName = new Hashtable();
        int i = 0;
        while (i < searchabilities.length) {
            searchabilityOfName.put(Searchability.searchabilities[i].name, searchabilities[i]);
            ++i;
        }
    }

    private Searchability(int index, String name) {
        this.index = new Integer(index);
        this.name = name;
    }

    public static Searchability forIndex(int index) {
        return searchabilities[index];
    }

    public static int count() {
        return searchabilities.length;
    }

    public static Searchability named(String name) {
        Searchability it = searchabilityOfName.get(name);
        if (it == null) {
            throw new NameUnrecognisedException(name);
        }
        return it;
    }

    public String toString() {
        return String.valueOf(this.name) + "/" + this.index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static class NameUnrecognisedException
    extends PoemException {
        private static final long serialVersionUID = 1L;
        public String name;

        public NameUnrecognisedException(String name) {
            this.name = name;
        }

        @Override
        public String getMessage() {
            return "No searchability level found which goes by the name `" + this.name + "'";
        }
    }
}

