/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.csv;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.melati.poem.Database;
import org.melati.poem.PoemBugPoemException;
import org.melati.poem.PoemThread;
import org.melati.poem.Table;
import org.melati.poem.csv.CSVParseException;
import org.melati.poem.csv.CSVTable;
import org.melati.poem.csv.CSVWriteDownException;
import org.melati.poem.csv.NoPrimaryKeyInCSVTableException;

public class CSVFilesProcessor {
    protected Vector<CSVTable> tables = new Vector();
    Database db = null;

    public CSVFilesProcessor(Database db) {
        this.db = db;
    }

    public CSVTable addTable(String tablename, File file) {
        return this.addTable(this.db.getTable(tablename), file);
    }

    public CSVTable addTable(Table<?> tab, File file) {
        if (!file.exists()) {
            throw new RuntimeException("File not found: " + file.getPath());
        }
        CSVTable table = new CSVTable(tab, file);
        this.tables.addElement(table);
        return table;
    }

    public void process(boolean writeOnFly, boolean emptyTables, boolean recordDetails, boolean fieldDetails, Writer output) throws IOException, CSVParseException, NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        CSVTable t;
        int i;
        output.write("Trying to get exclusive lock on the database\n");
        this.db.beginExclusiveLock();
        output.write("Got exclusive lock on the database!!!\n");
        if (emptyTables) {
            i = 0;
            while (i < this.tables.size()) {
                t = this.tables.elementAt(i);
                t.emptyTable();
                output.write("Emptied table :" + t.getName() + "\n");
                System.err.println("Emptied table :" + t.getName());
                ++i;
            }
            PoemThread.writeDown();
        }
        i = 0;
        while (i < this.tables.size()) {
            t = this.tables.elementAt(i);
            t.load(writeOnFly);
            output.write("Loaded table :" + t.getName() + "\n");
            System.err.println("Loaded table :" + t.getName());
            ++i;
        }
        if (!writeOnFly) {
            this.writeData(output);
            output.write("Written records\n");
        }
        this.db.endExclusiveLock();
        output.write("Ended exclusive lock on the database!!!\n");
        output.write("***** REPORT ******\n");
        i = 0;
        while (i < this.tables.size()) {
            this.tables.elementAt(i).report(recordDetails, fieldDetails, output);
            ++i;
        }
    }

    public void process(boolean emptyTables, boolean recordDetails, boolean fieldDetails, Writer output) throws IOException, CSVParseException, NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        this.process(false, emptyTables, recordDetails, fieldDetails, output);
    }

    protected void writeData(Writer o) throws NoPrimaryKeyInCSVTableException, CSVWriteDownException {
        int i = 0;
        while (i < this.tables.size()) {
            CSVTable t = this.tables.elementAt(i);
            try {
                o.write("Writing " + t.getName() + ".\n");
            }
            catch (IOException e) {
                throw new PoemBugPoemException("Problem writing log", e);
            }
            t.writeRecords();
            ++i;
        }
    }
}

