/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLType;
import org.melati.poem.StringPoemType;
import org.melati.poem.dbms.AnsiStandard;

public class Oracle
extends AnsiStandard {
    public static int oracleTextHack = 266;

    public Oracle() {
        this.setDriverClassName("oracle.jdbc.OracleDriver");
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getStringSqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "VARCHAR(" + oracleTextHack + ")";
        }
        return super.getStringSqlDefinition(size);
    }

    @Override
    public String getLongSqlDefinition() {
        return "NUMBER";
    }

    @Override
    public String getSqlDefinition(String sqlTypeName) {
        if (sqlTypeName.equals("BOOLEAN")) {
            return "CHAR(1)";
        }
        return super.getSqlDefinition(sqlTypeName);
    }

    @Override
    public String sqlBooleanValueOfRaw(Object raw) {
        if (((Boolean)raw).booleanValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public String getBinarySqlDefinition(int size) throws SQLException {
        return "BLOB";
    }

    @Override
    public String unreservedName(String name) {
        if (name.equalsIgnoreCase("user")) {
            name = "melati_" + name;
        }
        if (name.equalsIgnoreCase("group")) {
            name = "melati_" + name;
        }
        return name.toUpperCase();
    }

    @Override
    public String melatiName(String name) {
        if (name == null) {
            return name;
        }
        if (name.equalsIgnoreCase("melati_user")) {
            name = "user";
        }
        if (name.equalsIgnoreCase("melati_group")) {
            name = "group";
        }
        return name.toLowerCase();
    }

    @Override
    public <S, O> PoemType<O> canRepresent(PoemType<S> storage, PoemType<O> type) {
        if (storage instanceof IntegerPoemType && type instanceof BigDecimalPoemType && (storage.getNullable() || !type.getNullable())) {
            return type;
        }
        if (storage instanceof IntegerPoemType && type instanceof LongPoemType && (storage.getNullable() || !type.getNullable())) {
            return type;
        }
        return storage.canRepresent(type);
    }

    @Override
    public SQLPoemType<?> defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        if (md.getString("TYPE_NAME").equals("VARCHAR2")) {
            return new OracleStringPoemType(md.getInt("NULLABLE") == 1, md.getInt("COLUMN_SIZE"));
        }
        if (md.getString("TYPE_NAME").equals("CHAR")) {
            return new OracleBooleanPoemType(md.getInt("NULLABLE") == 1);
        }
        if (md.getString("TYPE_NAME").equals("BLOB")) {
            return new BinaryPoemType(md.getInt("NULLABLE") == 1, md.getInt("COLUMN_SIZE"));
        }
        if (md.getString("TYPE_NAME").equals("FLOAT")) {
            return new DoublePoemType(md.getInt("NULLABLE") == 1);
        }
        SQLPoemType<Integer> t = md.getString("TYPE_NAME").equals("NUMBER") ? new IntegerPoemType(md.getInt("NULLABLE") == 1) : super.defaultPoemTypeOfColumnMetaData(md);
        return t;
    }

    @Override
    public String getForeignKeyDefinition(String tableName, String fieldName, String targetTableName, String targetTableFieldName, String fixName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ADD (CONSTRAINT FK_" + tableName + "_" + fieldName + ") FOREIGN KEY (" + this.getQuotedName(fieldName) + ") REFERENCES " + this.getQuotedName(targetTableName) + "(" + this.getQuotedName(targetTableFieldName) + ")");
        if (fixName.equals("delete")) {
            sb.append(" ON DELETE CASCADE");
        }
        if (fixName.equals("clear")) {
            sb.append(" ON DELETE SET NULL");
        }
        return sb.toString();
    }

    @Override
    public String getPrimaryKeyDefinition(String fieldName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ADD (CONSTRAINT PK_" + fieldName + " PRIMARY KEY(" + this.getQuotedName(fieldName) + "))");
        return sb.toString();
    }

    @Override
    public String booleanTrueExpression(Column<Boolean> booleanColumn) {
        return String.valueOf(booleanColumn.fullQuotedName()) + "=1";
    }

    @Override
    public String getSqlDefaultValue(SQLType<?> sqlType) {
        if (sqlType instanceof BooleanPoemType) {
            return "0";
        }
        return super.getSqlDefaultValue(sqlType);
    }

    public static class OracleBooleanPoemType
    extends BooleanPoemType {
        public OracleBooleanPoemType(boolean nullable) {
            super(nullable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean _getRaw(ResultSet rs, int col) throws SQLException {
            ResultSet resultSet = rs;
            synchronized (resultSet) {
                boolean v = rs.getBoolean(col);
                return rs.wasNull() ? null : (v ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        @Override
        protected void _setRaw(PreparedStatement ps, int col, Object bool) throws SQLException {
            ps.setInt(col, (Boolean)bool != false ? 1 : 0);
        }
    }

    public static class OracleStringPoemType
    extends StringPoemType {
        public OracleStringPoemType(boolean nullable, int size) {
            super(nullable, size);
        }

        @Override
        protected boolean _canRepresent(SQLPoemType<?> other) {
            return this.sqlTypeCode() == other.sqlTypeCode() && this.getSize() == oracleTextHack && ((StringPoemType)other).getSize() == -1 || this.getSize() >= ((StringPoemType)other).getSize();
        }

        @Override
        public <O> PoemType<O> canRepresent(PoemType<O> other) {
            return other instanceof StringPoemType && this._canRepresent((StringPoemType)other) && (this.getNullable() || !((StringPoemType)other).getNullable()) ? other : null;
        }
    }
}

