/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.DatePoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.PoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.SQLType;
import org.melati.poem.StringPoemType;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.dbms.AnsiStandard;
import org.melati.poem.util.StringUtils;

public class SQLServer
extends AnsiStandard {
    public static final int sqlServerTextHack = 2333;
    public static final int sqlServerMaxBinarySize = Integer.MAX_VALUE;

    public SQLServer() {
        this.setDriverClassName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getSqlDefinition(String sqlTypeName) {
        if (sqlTypeName.equals("BOOLEAN")) {
            return "BIT";
        }
        if (sqlTypeName.equals("DATE")) {
            return "DATETIME";
        }
        if (sqlTypeName.equals("TIMESTAMP")) {
            return "DATETIME";
        }
        return super.getSqlDefinition(sqlTypeName);
    }

    @Override
    public String getStringSqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "VARCHAR(2333)";
        }
        return super.getStringSqlDefinition(size);
    }

    @Override
    public <S, O> PoemType<O> canRepresent(PoemType<S> storage, PoemType<O> type) {
        if (storage instanceof StringPoemType && type instanceof StringPoemType) {
            if (((StringPoemType)storage).getSize() == 2333 && ((StringPoemType)type).getSize() == -1 && (storage.getNullable() || !type.getNullable())) {
                return type;
            }
            return storage.canRepresent(type);
        }
        if (storage instanceof BinaryPoemType && type instanceof BinaryPoemType) {
            if (((BinaryPoemType)storage).getSize() == Integer.MAX_VALUE && ((BinaryPoemType)type).getSize() == -1 && (storage.getNullable() || !type.getNullable())) {
                return type;
            }
            return storage.canRepresent(type);
        }
        if (storage instanceof DatePoemType && type instanceof TimestampPoemType) {
            if (storage.getNullable() || !type.getNullable()) {
                return type;
            }
            return storage.canRepresent(type);
        }
        return super.canRepresent(storage, type);
    }

    @Override
    public String sqlBooleanValueOfRaw(Object raw) {
        if (((Boolean)raw).booleanValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public String getLongSqlDefinition() {
        return "BIGINT";
    }

    @Override
    public String getBinarySqlDefinition(int size) throws SQLException {
        if (size < 0) {
            return "VARBINARY(MAX)";
        }
        return "VARBINARY(" + size + ")";
    }

    @Override
    public SQLPoemType<?> defaultPoemTypeOfColumnMetaData(ResultSet md) throws SQLException {
        if (md.getString("TYPE_NAME").equals("varchar") && md.getInt("COLUMN_SIZE") == 2333) {
            return new StringPoemType(md.getInt("NULLABLE") == 1, -1);
        }
        if (md.getString("TYPE_NAME").equals("char")) {
            return new StringPoemType(md.getInt("NULLABLE") == 1, md.getInt("COLUMN_SIZE"));
        }
        if (md.getString("TYPE_NAME").equals("float")) {
            return new DoublePoemType(md.getInt("NULLABLE") == 1);
        }
        if (md.getString("TYPE_NAME").equals("datetime")) {
            return new DatePoemType(md.getInt("NULLABLE") == 1);
        }
        if (md.getString("TYPE_NAME").equals("bit")) {
            return new SQLServerBooleanPoemType(md.getInt("NULLABLE") == 1);
        }
        return super.defaultPoemTypeOfColumnMetaData(md);
    }

    @Override
    public String melatiName(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase("dtproperties")) {
            return null;
        }
        return name;
    }

    @Override
    public boolean canBeIndexed(Column<?> column) {
        PoemType<?> t = column.getType();
        return !(t instanceof StringPoemType) || ((StringPoemType)t).getSize() >= 0;
    }

    @Override
    public String caseInsensitiveRegExpSQL(String term1, String term2) {
        if (StringUtils.isQuoted(term2)) {
            term2 = term2.substring(1, term2.length() - 1);
        }
        term2 = StringUtils.quoted(StringUtils.quoted(term2, '%'), '\'');
        return String.valueOf(term1) + " LIKE " + term2;
    }

    @Override
    public String getForeignKeyDefinition(String tableName, String fieldName, String targetTableName, String targetTableFieldName, String fixName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ADD FOREIGN KEY (" + this.getQuotedName(fieldName) + ") REFERENCES " + this.getQuotedName(targetTableName) + "(" + this.getQuotedName(targetTableFieldName) + ")");
        if (fixName.equals("prevent")) {
            sb.append(" ON DELETE NO ACTION");
        }
        if (fixName.equals("delete")) {
            sb.append(" ON DELETE CASCADE");
        }
        if (fixName.equals("clear")) {
            sb.append(" ON DELETE SET NULL");
        }
        return sb.toString();
    }

    @Override
    public String alterColumnNotNullableSQL(String tableName, Column<?> column) {
        return "ALTER TABLE " + this.getQuotedName(tableName) + " ALTER COLUMN " + this.getQuotedName(column.getName()) + " " + column.getSQLType().sqlDefinition(this);
    }

    @Override
    public String selectLimit(String querySelection, int limit) {
        return "SELECT TOP " + limit + querySelection;
    }

    @Override
    public String booleanTrueExpression(Column<Boolean> booleanColumn) {
        return String.valueOf(booleanColumn.fullQuotedName()) + "=1";
    }

    @Override
    public String getSqlDefaultValue(SQLType<?> sqlType) {
        if (sqlType instanceof BooleanPoemType) {
            return "0";
        }
        if (sqlType instanceof BinaryPoemType) {
            return "convert(varbinary, '')";
        }
        return super.getSqlDefaultValue(sqlType);
    }

    @Override
    public String getQuotedValue(SQLType<?> sqlType, String value) {
        if (sqlType instanceof BinaryPoemType) {
            return value;
        }
        return super.getQuotedValue(sqlType, value);
    }

    public static class SQLServerBooleanPoemType
    extends BooleanPoemType {
        public SQLServerBooleanPoemType(boolean nullable) {
            super(nullable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean _getRaw(ResultSet rs, int col) throws SQLException {
            ResultSet resultSet = rs;
            synchronized (resultSet) {
                boolean v = rs.getBoolean(col);
                return rs.wasNull() ? null : (v ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        @Override
        protected void _setRaw(PreparedStatement ps, int col, Object bool) throws SQLException {
            ps.setInt(col, (Boolean)bool != false ? 1 : 0);
        }
    }
}

