/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import org.melati.poem.BigDecimalPoemType;
import org.melati.poem.BinaryPoemType;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.DatePoemType;
import org.melati.poem.DoublePoemType;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.LongPoemType;
import org.melati.poem.PoemType;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.dbms.test.DbmsSpec;

public class MckoiTest
extends DbmsSpec {
    public MckoiTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void setObjectUnderTest() {
        this.it = DbmsFactory.getDbms((String)"org.melati.poem.dbms.Mckoi");
    }

    @Override
    public void testGetSqlDefinition() throws Exception {
        MckoiTest.assertEquals((String)"BOOLEAN", (String)this.it.getSqlDefinition("BOOLEAN"));
        MckoiTest.assertEquals((String)"DOUBLE PRECISION", (String)this.it.getSqlDefinition("DOUBLE PRECISION"));
        MckoiTest.assertEquals((String)"INT8", (String)this.it.getSqlDefinition("INT8"));
        MckoiTest.assertEquals((String)"INTEGER", (String)this.it.getSqlDefinition("INT"));
        MckoiTest.assertEquals((String)"Big Decimal", (String)this.it.getSqlDefinition("Big Decimal"));
        MckoiTest.assertEquals((String)"STRING", (String)this.it.getSqlDefinition("STRING"));
    }

    @Override
    public void testGetStringSqlDefinition() throws Exception {
        MckoiTest.assertEquals((String)"VARCHAR(0)", (String)this.it.getStringSqlDefinition(0));
        MckoiTest.assertEquals((String)"TEXT", (String)this.it.getStringSqlDefinition(-1));
    }

    @Override
    public void testGetBinarySqlDefinition() throws Exception {
        MckoiTest.assertEquals((String)"LONGVARBINARY", (String)this.it.getBinarySqlDefinition(0));
    }

    @Override
    public void testCanRepresent() {
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)StringPoemType.nullableInstance, (PoemType)IntegerPoemType.nullableInstance));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)IntegerPoemType.nullableInstance, (PoemType)StringPoemType.nullableInstance));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new BigDecimalPoemType(false), (PoemType)new BigDecimalPoemType(true)));
        MckoiTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BigDecimalPoemType(true), (PoemType)new BigDecimalPoemType(false)) instanceof BigDecimalPoemType));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new StringPoemType(true, 255), (PoemType)new StringPoemType(true, -1)));
        MckoiTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, Integer.MAX_VALUE), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        MckoiTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new StringPoemType(true, -1), (PoemType)new StringPoemType(true, -1)) instanceof StringPoemType));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new TimestampPoemType(true), (PoemType)new DatePoemType(true)));
        MckoiTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BooleanPoemType(true), (PoemType)new BooleanPoemType(false)) instanceof BooleanPoemType));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(false), (PoemType)new BigDecimalPoemType(true)));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new DoublePoemType(true), (PoemType)new BigDecimalPoemType(false)));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new IntegerPoemType(false), (PoemType)new LongPoemType(true)));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new IntegerPoemType(true), (PoemType)new LongPoemType(false)));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new BinaryPoemType(false, 10), (PoemType)new BinaryPoemType(true, 10)));
        MckoiTest.assertNull((Object)this.it.canRepresent((PoemType)new BinaryPoemType(true, 10), (PoemType)new BinaryPoemType(true, 11)));
        MckoiTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BinaryPoemType(true, Integer.MAX_VALUE), (PoemType)new BinaryPoemType(true, -1)) instanceof BinaryPoemType));
        MckoiTest.assertTrue((boolean)(this.it.canRepresent((PoemType)new BinaryPoemType(true, Integer.MAX_VALUE), (PoemType)new BinaryPoemType(true, 10)) instanceof BinaryPoemType));
    }

    @Override
    public void testGetForeignKeyDefinition() {
        MckoiTest.assertEquals((String)" ADD FOREIGN KEY (user) REFERENCES user(id) ON DELETE CASCADE", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "delete"));
    }

    @Override
    public void testGetPrimaryKeyDefinition() {
        MckoiTest.assertEquals((String)" ADD PRIMARY KEY (name)", (String)this.it.getPrimaryKeyDefinition("name"));
    }

    @Override
    public void testGivesCapabilitySQL() {
        String actual = this.it.givesCapabilitySQL(new Integer(42), "hello");
        String expected = "SELECT " + this.it.getQuotedName("groupmembership") + ".* " + "FROM " + this.it.getQuotedName("groupmembership") + " LEFT JOIN " + this.it.getQuotedName("groupcapability") + " ON " + this.it.getQuotedName("groupmembership") + "." + this.it.getQuotedName("group") + " =  " + this.it.getQuotedName("groupcapability") + "." + this.it.getQuotedName("group") + " WHERE " + this.it.getQuotedName("user") + " = 42" + " " + "AND " + this.it.getQuotedName("groupcapability") + "." + this.it.getQuotedName("group") + " IS NOT NULL " + "AND " + this.it.getQuotedName("capability") + " = hello";
        MckoiTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCreateTableSql() {
        if (this.getDb().getDbms() == this.it) {
            MckoiTest.assertEquals((String)"CREATE TABLE \"user\" (\"id\" INTEGER NOT NULL, \"name\" VARCHAR(60) NOT NULL, \"login\" VARCHAR(255) NOT NULL, \"password\" VARCHAR(20) NOT NULL)", (String)this.it.createTableSql((Table)this.getDb().getUserTable()));
        }
    }
}

