/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.melati.poem.AccessToken;
import org.melati.poem.Database;
import org.melati.poem.DatabaseInitialisationPoemException;
import org.melati.poem.Group;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabase;
import org.melati.poem.PoemDatabaseFactory;
import org.melati.poem.PoemTask;
import org.melati.poem.Table;
import org.melati.poem.User;
import org.melati.poem.test.PoemTestCase;
import org.melati.poem.transaction.WriteCommittedException;
import org.melati.poem.util.EnumUtils;

public class DatabasePerformInCommittedTransactionTest
extends TestCase
implements Test {
    private PoemDatabase db = null;
    private String dbName = "melatijunit";
    private AccessToken userToRunAs;
    boolean skipTest = false;
    String dbUrl = null;
    public static Properties databaseDefs = null;

    public DatabasePerformInCommittedTransactionTest() {
    }

    public DatabasePerformInCommittedTransactionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setDbName(this.getDbName());
        this.setDb(this.getDbName());
    }

    protected void tearDown() throws Exception {
        this.checkDbUnchanged();
    }

    protected void checkDbUnchanged() {
        this.getDb().inSession(AccessToken.root, new PoemTask(){

            public void run() {
                if (DatabasePerformInCommittedTransactionTest.this.dbName.equals("poemtest")) {
                    DatabasePerformInCommittedTransactionTest.this.poemtestUnchanged();
                }
                if (DatabasePerformInCommittedTransactionTest.this.dbName.equals("melatijunit")) {
                    DatabasePerformInCommittedTransactionTest.this.melatijunitUnchanged();
                }
            }
        });
    }

    protected void melatijunitUnchanged() {
        if (!this.getDb().getDbms().canDropColumns()) {
            return;
        }
        DatabasePerformInCommittedTransactionTest.assertEquals((int)0, (int)this.getDb().getSettingTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)1, (int)this.getDb().getGroupTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)1, (int)this.getDb().getGroupMembershipTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)5, (int)this.getDb().getCapabilityTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)1, (int)this.getDb().getGroupCapabilityTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)3, (int)this.getDb().getTableCategoryTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)2, (int)this.getDb().getUserTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)69, (int)this.getDb().getColumnInfoTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)9, (int)this.getDb().getTableInfoTable().count());
    }

    protected void poemtestUnchanged() {
        DatabasePerformInCommittedTransactionTest.assertEquals((int)0, (int)this.getDb().getSettingTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)1, (int)this.getDb().getGroupTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)1, (int)this.getDb().getGroupMembershipTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)5, (int)this.getDb().getCapabilityTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)1, (int)this.getDb().getGroupCapabilityTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)4, (int)this.getDb().getTableCategoryTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)2, (int)this.getDb().getUserTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)147, (int)this.getDb().getColumnInfoTable().count());
        DatabasePerformInCommittedTransactionTest.assertEquals((int)23, (int)this.getDb().getTableInfoTable().count());
    }

    protected <P extends Persistent> void dumpTable(Table<P> t) {
        Enumeration them = t.selection();
        while (them.hasMoreElements()) {
            Persistent it = (Persistent)them.nextElement();
            System.err.println(it.getTroid() + " " + it.getCooked("name") + " " + it.getTable().getName());
        }
    }

    protected String getDbName() {
        return this.dbName;
    }

    protected void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public PoemDatabase getDb() {
        return this.db;
    }

    public void setDb(String dbName) {
        if (dbName == null) {
            throw new NullPointerException();
        }
        try {
            this.db = (PoemDatabase)this.getDatabase(dbName);
        }
        catch (DatabaseInitialisationPoemException e) {
            e.printStackTrace();
            DatabasePerformInCommittedTransactionTest.fail((String)e.getMessage());
        }
    }

    public Database getDatabase(String name) {
        String pref;
        Properties defs = this.databaseDefs();
        if (PoemTestCase.getOrDie(defs, (pref = "org.melati.poem.test.PoemTestCase." + name + ".") + "dbmsclass").indexOf("Postgres") > 0) {
            this.skipTest = true;
        }
        return PoemDatabaseFactory.getDatabase((String)name, (String)PoemTestCase.getOrDie(defs, pref + "url"), (String)PoemTestCase.getOrDie(defs, pref + "user"), (String)PoemTestCase.getOrDie(defs, pref + "password"), (String)PoemTestCase.getOrDie(defs, pref + "class"), (String)PoemTestCase.getOrDie(defs, pref + "dbmsclass"), (boolean)new Boolean(PoemTestCase.getOrDie(defs, pref + "addconstraints")), (boolean)new Boolean(PoemTestCase.getOrDie(defs, pref + "logsql")), (boolean)new Boolean(PoemTestCase.getOrDie(defs, pref + "logcommits")), (int)new Integer(PoemTestCase.getOrDie(defs, pref + "maxtransactions")));
    }

    public Properties databaseDefs() {
        if (databaseDefs == null) {
            databaseDefs = this.getProperties();
        }
        return databaseDefs;
    }

    public Properties getProperties() {
        String className = "org.melati.poem.test.PoemTestCase";
        String name = className + ".properties";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (is == null) {
            throw new RuntimeException(new FileNotFoundException(name + ": is it in CLASSPATH?"));
        }
        Properties them = new Properties();
        try {
            them.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(new IOException("Corrupt properties file `" + name + "': " + e.getMessage()));
        }
        return them;
    }

    public AccessToken getUserToRunAs() {
        if (this.userToRunAs == null) {
            return AccessToken.root;
        }
        return this.userToRunAs;
    }

    public void setUserToRunAs(AccessToken userToRunAs) {
        this.userToRunAs = userToRunAs == null ? AccessToken.root : userToRunAs;
    }

    public void testInCommittedTransaction() {
        PoemTask doNothing = new PoemTask(){

            public void run() {
            }
        };
        this.getDb().inCommittedTransaction(AccessToken.root, doNothing);
    }

    public void testReadInCommittedTransaction() {
        if (this.skipTest) {
            return;
        }
        PoemTask read = new PoemTask(){

            public void run() {
                Assert.assertEquals((String)"Melati guest user", (String)((User)DatabasePerformInCommittedTransactionTest.this.getDb().getUserTable().getObject(new Integer(0))).getName());
            }
        };
        this.getDb().inCommittedTransaction(AccessToken.root, read);
        this.getDb().uncache();
        this.getDb().inCommittedTransaction(AccessToken.root, read);
    }

    public void testUpdateInCommittedTransaction() {
        if (this.skipTest) {
            return;
        }
        PoemTask modify = new PoemTask(){

            public void run() {
                try {
                    DatabasePerformInCommittedTransactionTest.this.getDb().guestUser().setName(DatabasePerformInCommittedTransactionTest.this.getDb().guestUser().getName());
                    Assert.fail((String)"Should have blown up");
                }
                catch (WriteCommittedException e) {
                    Object var1_2 = null;
                }
            }
        };
        this.getDb().inCommittedTransaction(AccessToken.root, modify);
    }

    public void testDeleteInCommittedTransaction() {
        if (this.skipTest) {
            return;
        }
        PoemTask modify = new PoemTask(){

            public void run() {
                try {
                    DatabasePerformInCommittedTransactionTest.this.getDb().guestUser().delete_unsafe();
                    Assert.fail((String)"Should have blown up");
                }
                catch (WriteCommittedException e) {
                    Object var1_2 = null;
                }
            }
        };
        this.getDb().inCommittedTransaction(AccessToken.root, modify);
    }

    public void testCreateInCommittedTransaction() {
        if (this.skipTest) {
            return;
        }
        Object create = new PoemTask(){

            public void run() {
                try {
                    Group g = (Group)DatabasePerformInCommittedTransactionTest.this.getDb().getGroupTable().newPersistent();
                    g.setName("failure");
                    g.makePersistent();
                    Assert.fail((String)"Should have blown up");
                }
                catch (NullPointerException e) {
                    Object var1_3 = null;
                }
            }
        };
        this.getDb().inCommittedTransaction(AccessToken.root, create);
        create = new PoemTask(){

            public void run() {
                try {
                    DatabasePerformInCommittedTransactionTest.this.getDb().getGroupTable().ensure("failure");
                    Assert.fail((String)"Should have blown up");
                }
                catch (NullPointerException e) {
                    Object var1_2 = null;
                }
            }
        };
    }

    public void testToString() {
        PoemDatabase d = new PoemDatabase();
        DatabasePerformInCommittedTransactionTest.assertEquals((String)"unconnected database", (String)d.toString());
    }

    public void testTableTroidSelection() {
        this.getDb().inSession(AccessToken.root, new PoemTask(){

            public void run() {
                Enumeration en = DatabasePerformInCommittedTransactionTest.this.getDb().getUserTable().troidSelection("id=0", null, false);
                Assert.assertEquals((int)1, (int)EnumUtils.vectorOf((Enumeration)en).size());
            }
        });
    }

    public void testTableCount() {
        if (this.skipTest) {
            return;
        }
        this.getDb().setLogSQL(true);
        DatabasePerformInCommittedTransactionTest.assertEquals((int)1, (int)this.getDb().getGroupTable().count());
        this.getDb().setLogSQL(false);
        DatabasePerformInCommittedTransactionTest.assertEquals((int)1, (int)this.getDb().getGroupTable().count(null, true));
    }
}

