/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.test;

import java.sql.Date;
import org.melati.poem.Persistent;
import org.melati.poem.PoemThread;
import org.melati.poem.PoemTypeFactory;
import org.melati.poem.Setting;
import org.melati.poem.test.EverythingTestCase;

public class SettingTest
extends EverythingTestCase {
    public SettingTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSetValue() {
        Setting stringSetting = this.getDb().getSettingTable().ensure("stringSetting", "set", "String", "A set string setting");
        stringSetting.setValue("new");
        SettingTest.assertEquals((Object)"new", (Object)stringSetting.getCooked());
        stringSetting.setRaw((Object)"new2");
        SettingTest.assertEquals((Object)"new2", (Object)stringSetting.getCooked());
        stringSetting.delete();
        Setting integerSetting = this.getDb().getSettingTable().ensure("integerSetting", 12, "Integer Setting", "A set Integer setting");
        integerSetting.setRaw((Object)new Integer(13));
        SettingTest.assertEquals((Object)new Integer(13), (Object)integerSetting.getCooked());
        try {
            integerSetting.setValue("ghgh");
            SettingTest.fail((String)"Should have blown up");
        }
        catch (Setting.SettingValidationException e2) {
            Object e2 = null;
        }
        try {
            integerSetting.setRaw((Object)"ghgh");
            SettingTest.fail((String)"Should have blown up");
        }
        catch (Setting.SettingValidationException e) {
            Object var3_6 = null;
        }
        integerSetting.delete();
    }

    public void testGetValueField() {
        Setting s = new Setting(PoemTypeFactory.STRING.getCode(), "testSetting", "eggs", "Test Setting", "A test setting");
        this.getDb().getSettingTable().create((Persistent)s);
        SettingTest.assertEquals((Object)"eggs", (Object)s.getValueField().getCooked());
        s.delete();
        s = new Setting(PoemTypeFactory.PASSWORD.getCode(), "columnSetting", "0", "Password", "A test setting");
        this.getDb().getSettingTable().create((Persistent)s);
        s.setRaw((Object)this.getDb().getUserTable().administratorUser().getPasswordField());
        SettingTest.assertEquals((Object)"password: FIXME", (Object)s.getValueField().getCooked());
        s.delete();
    }

    public void testSettingIntegerStringStringStringString() {
        Setting s = new Setting(PoemTypeFactory.STRING.getCode(), "testSetting", "eggs", "Test Setting", "A test setting");
        this.getDb().getSettingTable().create((Persistent)s);
        SettingTest.assertEquals((String)"eggs", (String)s.getValue());
        s.delete();
    }

    public void testSetRawObject() {
        Setting s = new Setting(PoemTypeFactory.STRING.getCode(), "testSetting", "eggs", "Test Setting", "A test setting");
        this.getDb().getSettingTable().create((Persistent)s);
        SettingTest.assertEquals((String)"eggs", (String)s.getValue());
        s.delete();
        Setting integerSetting = this.getDb().getSettingTable().ensure("integerSetting", 12, "Integer", "A set Integer setting");
        integerSetting.setRaw((Object)new Integer(13));
        SettingTest.assertEquals((Object)new Integer(13), (Object)integerSetting.getCooked());
        try {
            integerSetting.setRaw((Object)"pp");
            SettingTest.fail((String)"Should have bombed.");
        }
        catch (Setting.SettingValidationException e2) {
            Object e2 = null;
        }
        integerSetting.delete();
        Setting timestampSetting = this.getDb().getSettingTable().ensure("timestampSetting", PoemTypeFactory.TIMESTAMP, (Object)new Date(System.currentTimeMillis()), "Timestamp", "A timestamp setting");
        try {
            timestampSetting.setRaw((Object)"Not a date");
            SettingTest.fail((String)"Should have bombed");
        }
        catch (Setting.SettingValidationException e3) {
            Object e3 = null;
        }
        timestampSetting.delete();
    }

    public void testGetRaw() {
        Setting s = new Setting(PoemTypeFactory.STRING.getCode(), "testSetting", "eggs", "Test Setting", "A test setting");
        this.getDb().getSettingTable().create((Persistent)s);
        s.setNullable(true);
        SettingTest.assertEquals((String)"eggs", (String)s.getValue());
        s.setValue(null);
        s.setNullable(false);
        PoemThread.commit();
        try {
            s.getRaw();
        }
        catch (Setting.SettingValidationException e) {
            e.printStackTrace();
            Object var2_3 = null;
        }
        s.delete();
    }

    public void testGetCooked() {
    }

    public void testGetIntegerCooked() {
        Setting integerSetting = this.getDb().getSettingTable().ensure("integerSetting", 12, "Integer", "A set Integer setting");
        integerSetting.setRaw((Object)new Integer(13));
        SettingTest.assertEquals((Object)new Integer(13), (Object)integerSetting.getCooked());
        SettingTest.assertEquals((Object)new Integer(13), (Object)integerSetting.getIntegerCooked());
        integerSetting.setNullable(true);
        integerSetting.setRaw(null);
        SettingTest.assertNull((Object)integerSetting.getIntegerCooked());
        integerSetting.setNullable(false);
        try {
            integerSetting.getIntegerCooked();
            SettingTest.fail((String)"Should have bombed.");
        }
        catch (Setting.SettingTypeMismatchException e) {
            Object var2_3 = null;
        }
        integerSetting.delete();
    }

    public void testGetStringCooked() {
        Setting stringSetting = this.getDb().getSettingTable().ensure("stringSetting", "set", "String", "A set String setting");
        stringSetting.setRaw((Object)"v2");
        SettingTest.assertEquals((Object)"v2", (Object)stringSetting.getCooked());
        SettingTest.assertEquals((String)"v2", (String)stringSetting.getStringCooked());
        stringSetting.setNullable(true);
        stringSetting.setRaw(null);
        SettingTest.assertNull((Object)stringSetting.getStringCooked());
        stringSetting.setNullable(false);
        try {
            stringSetting.getStringCooked();
            SettingTest.fail((String)"Should have bombed.");
        }
        catch (Setting.SettingTypeMismatchException e) {
            Object var2_3 = null;
        }
        stringSetting.delete();
    }

    public void testGetBooleanCooked() {
        Setting booleanSetting = this.getDb().getSettingTable().ensure("booleanSetting", false, "Boolean", "A set boolean setting");
        booleanSetting.setRaw((Object)Boolean.TRUE);
        SettingTest.assertEquals((Object)Boolean.TRUE, (Object)booleanSetting.getCooked());
        SettingTest.assertEquals((Object)Boolean.TRUE, (Object)booleanSetting.getBooleanCooked());
        booleanSetting.setNullable(true);
        booleanSetting.setRaw(null);
        SettingTest.assertNull((Object)booleanSetting.getBooleanCooked());
        booleanSetting.setNullable(false);
        try {
            booleanSetting.getBooleanCooked();
            SettingTest.fail((String)"Should have bombed.");
        }
        catch (Setting.SettingTypeMismatchException e) {
            Object var2_3 = null;
        }
        booleanSetting.delete();
    }

    public void testGetValue() {
        Setting userSetting = this.getDb().getSettingTable().ensure("userSetting", PoemTypeFactory.TROID, (Object)this.getDb().guestUser().getTroid(), "User", "A User setting");
        SettingTest.assertEquals((Object)new Integer(0), (Object)userSetting.getCooked());
        userSetting.delete();
    }
}

