/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.dbms.test;

import org.melati.poem.dbms.DbmsFactory;
import org.melati.poem.dbms.test.DbmsSpec;

public class SQLServerTest
extends DbmsSpec {
    public SQLServerTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void setObjectUnderTest() {
        this.it = DbmsFactory.getDbms((String)"org.melati.poem.dbms.SQLServer");
    }

    @Override
    public void testGetStringSqlDefinition() throws Exception {
        SQLServerTest.assertEquals((String)"VARCHAR(0)", (String)this.it.getStringSqlDefinition(0));
        SQLServerTest.assertEquals((String)"VARCHAR(2333)", (String)this.it.getStringSqlDefinition(-1));
    }

    @Override
    public void testGetSqlDefinition() throws Exception {
        SQLServerTest.assertEquals((String)"DOUBLE PRECISION", (String)this.it.getSqlDefinition("DOUBLE PRECISION"));
        SQLServerTest.assertEquals((String)"INT8", (String)this.it.getSqlDefinition("INT8"));
        SQLServerTest.assertEquals((String)"Big Decimal", (String)this.it.getSqlDefinition("Big Decimal"));
        SQLServerTest.assertEquals((String)"BIT", (String)this.it.getSqlDefinition("BOOLEAN"));
        SQLServerTest.assertEquals((String)"DATETIME", (String)this.it.getSqlDefinition("DATE"));
        SQLServerTest.assertEquals((String)"DATETIME", (String)this.it.getSqlDefinition("TIMESTAMP"));
    }

    @Override
    public void testMelatiName() {
        SQLServerTest.assertEquals((String)"name", (String)this.it.melatiName("name"));
        SQLServerTest.assertEquals(null, (String)this.it.melatiName(null));
        SQLServerTest.assertNull((Object)this.it.melatiName("dtproperties"));
    }

    @Override
    public void testCanBeIndexed() throws Exception {
        SQLServerTest.assertFalse((boolean)this.it.canBeIndexed(this.getDb().getTableInfoTable().getDescriptionColumn()));
        SQLServerTest.assertTrue((boolean)this.it.canBeIndexed(this.getDb().getUserTable().getNameColumn()));
    }

    @Override
    public void testCaseInsensitiveRegExpSQL() {
        String expected = "a LIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "b");
        SQLServerTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQLQuoted() {
        String expected = "a LIKE '%b%'";
        String actual = this.it.caseInsensitiveRegExpSQL("a", "\"b\"");
        SQLServerTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testCaseInsensitiveRegExpSQLBlank() {
        String expected = " LIKE '%%'";
        String actual = this.it.caseInsensitiveRegExpSQL("", "");
        SQLServerTest.assertEquals((String)expected, (String)actual);
    }

    @Override
    public void testGetLongSqlDefinition() {
        SQLServerTest.assertEquals((String)"BIGINT", (String)this.it.getLongSqlDefinition());
    }

    @Override
    public void testSqlBooleanValueOfRaw() {
        SQLServerTest.assertEquals((String)"0", (String)this.it.sqlBooleanValueOfRaw((Object)Boolean.FALSE));
        SQLServerTest.assertEquals((String)"1", (String)this.it.sqlBooleanValueOfRaw((Object)Boolean.TRUE));
    }

    @Override
    public void testGetBinarySqlDefinition() throws Exception {
        SQLServerTest.assertEquals((String)"VARBINARY(0)", (String)this.it.getBinarySqlDefinition(0));
        SQLServerTest.assertEquals((String)"VARBINARY(MAX)", (String)this.it.getBinarySqlDefinition(-1));
    }

    @Override
    public void testGetForeignKeyDefinition() {
        SQLServerTest.assertEquals((String)" ADD FOREIGN KEY (\"user\") REFERENCES \"user\"(\"id\") ON DELETE NO ACTION", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "prevent"));
        SQLServerTest.assertEquals((String)" ADD FOREIGN KEY (\"user\") REFERENCES \"user\"(\"id\") ON DELETE SET NULL", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "clear"));
        SQLServerTest.assertEquals((String)" ADD FOREIGN KEY (\"user\") REFERENCES \"user\"(\"id\") ON DELETE CASCADE", (String)this.it.getForeignKeyDefinition("test", "user", "user", "id", "delete"));
    }

    @Override
    public void testSelectLimit() {
        SQLServerTest.assertEquals((String)"SELECT TOP 1* FROM \"USER\"", (String)this.it.selectLimit("* FROM \"USER\"", 1));
    }
}

